/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPhoneNumbersRequest extends ChimeSdkVoiceRequest implements
        ToCopyableBuilder<ListPhoneNumbersRequest.Builder, ListPhoneNumbersRequest> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListPhoneNumbersRequest::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()).build();

    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductType").getter(getter(ListPhoneNumbersRequest::productTypeAsString))
            .setter(setter(Builder::productType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("product-type").build()).build();

    private static final SdkField<String> FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterName").getter(getter(ListPhoneNumbersRequest::filterNameAsString))
            .setter(setter(Builder::filterName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("filter-name").build()).build();

    private static final SdkField<String> FILTER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterValue").getter(getter(ListPhoneNumbersRequest::filterValue)).setter(setter(Builder::filterValue))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("filter-value").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListPhoneNumbersRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPhoneNumbersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            PRODUCT_TYPE_FIELD, FILTER_NAME_FIELD, FILTER_VALUE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String status;

    private final String productType;

    private final String filterName;

    private final String filterValue;

    private final Integer maxResults;

    private final String nextToken;

    private ListPhoneNumbersRequest(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.productType = builder.productType;
        this.filterName = builder.filterName;
        this.filterValue = builder.filterValue;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns the value of the Status property for this object.
     * 
     * @return The value of the Status property for this object.
     */
    public final String status() {
        return status;
    }

    /**
     * Returns the value of the ProductType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link PhoneNumberProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The value of the ProductType property for this object.
     * @see PhoneNumberProductType
     */
    public final PhoneNumberProductType productType() {
        return PhoneNumberProductType.fromValue(productType);
    }

    /**
     * Returns the value of the ProductType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link PhoneNumberProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The value of the ProductType property for this object.
     * @see PhoneNumberProductType
     */
    public final String productTypeAsString() {
        return productType;
    }

    /**
     * Returns the value of the FilterName property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterName} will
     * return {@link PhoneNumberAssociationName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #filterNameAsString}.
     * </p>
     * 
     * @return The value of the FilterName property for this object.
     * @see PhoneNumberAssociationName
     */
    public final PhoneNumberAssociationName filterName() {
        return PhoneNumberAssociationName.fromValue(filterName);
    }

    /**
     * Returns the value of the FilterName property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterName} will
     * return {@link PhoneNumberAssociationName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #filterNameAsString}.
     * </p>
     * 
     * @return The value of the FilterName property for this object.
     * @see PhoneNumberAssociationName
     */
    public final String filterNameAsString() {
        return filterName;
    }

    /**
     * Returns the value of the FilterValue property for this object.
     * 
     * @return The value of the FilterValue property for this object.
     */
    public final String filterValue() {
        return filterValue;
    }

    /**
     * Returns the value of the MaxResults property for this object.
     * 
     * @return The value of the MaxResults property for this object.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(productTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filterNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filterValue());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPhoneNumbersRequest)) {
            return false;
        }
        ListPhoneNumbersRequest other = (ListPhoneNumbersRequest) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(productTypeAsString(), other.productTypeAsString())
                && Objects.equals(filterNameAsString(), other.filterNameAsString())
                && Objects.equals(filterValue(), other.filterValue()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPhoneNumbersRequest").add("Status", status()).add("ProductType", productTypeAsString())
                .add("FilterName", filterNameAsString()).add("FilterValue", filterValue()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "ProductType":
            return Optional.ofNullable(clazz.cast(productTypeAsString()));
        case "FilterName":
            return Optional.ofNullable(clazz.cast(filterNameAsString()));
        case "FilterValue":
            return Optional.ofNullable(clazz.cast(filterValue()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPhoneNumbersRequest, T> g) {
        return obj -> g.apply((ListPhoneNumbersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListPhoneNumbersRequest> {
        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * Sets the value of the ProductType property for this object.
         *
         * @param productType
         *        The new value for the ProductType property for this object.
         * @see PhoneNumberProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberProductType
         */
        Builder productType(String productType);

        /**
         * Sets the value of the ProductType property for this object.
         *
         * @param productType
         *        The new value for the ProductType property for this object.
         * @see PhoneNumberProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberProductType
         */
        Builder productType(PhoneNumberProductType productType);

        /**
         * Sets the value of the FilterName property for this object.
         *
         * @param filterName
         *        The new value for the FilterName property for this object.
         * @see PhoneNumberAssociationName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberAssociationName
         */
        Builder filterName(String filterName);

        /**
         * Sets the value of the FilterName property for this object.
         *
         * @param filterName
         *        The new value for the FilterName property for this object.
         * @see PhoneNumberAssociationName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberAssociationName
         */
        Builder filterName(PhoneNumberAssociationName filterName);

        /**
         * Sets the value of the FilterValue property for this object.
         *
         * @param filterValue
         *        The new value for the FilterValue property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterValue(String filterValue);

        /**
         * Sets the value of the MaxResults property for this object.
         *
         * @param maxResults
         *        The new value for the MaxResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkVoiceRequest.BuilderImpl implements Builder {
        private String status;

        private String productType;

        private String filterName;

        private String filterValue;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPhoneNumbersRequest model) {
            super(model);
            status(model.status);
            productType(model.productType);
            filterName(model.filterName);
            filterValue(model.filterValue);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getProductType() {
            return productType;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(PhoneNumberProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final String getFilterName() {
            return filterName;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        @Override
        public final Builder filterName(PhoneNumberAssociationName filterName) {
            this.filterName(filterName == null ? null : filterName.toString());
            return this;
        }

        public final String getFilterValue() {
            return filterValue;
        }

        public final void setFilterValue(String filterValue) {
            this.filterValue = filterValue;
        }

        @Override
        public final Builder filterValue(String filterValue) {
            this.filterValue = filterValue;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPhoneNumbersRequest build() {
            return new ListPhoneNumbersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
