/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSipRulesResponse extends ChimeSdkVoiceResponse implements
        ToCopyableBuilder<ListSipRulesResponse.Builder, ListSipRulesResponse> {
    private static final SdkField<List<SipRule>> SIP_RULES_FIELD = SdkField
            .<List<SipRule>> builder(MarshallingType.LIST)
            .memberName("SipRules")
            .getter(getter(ListSipRulesResponse::sipRules))
            .setter(setter(Builder::sipRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SipRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SipRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(SipRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSipRulesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIP_RULES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<SipRule> sipRules;

    private final String nextToken;

    private ListSipRulesResponse(BuilderImpl builder) {
        super(builder);
        this.sipRules = builder.sipRules;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SipRules property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSipRules() {
        return sipRules != null && !(sipRules instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the SipRules property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSipRules} method.
     * </p>
     * 
     * @return The value of the SipRules property for this object.
     */
    public final List<SipRule> sipRules() {
        return sipRules;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSipRules() ? sipRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSipRulesResponse)) {
            return false;
        }
        ListSipRulesResponse other = (ListSipRulesResponse) obj;
        return hasSipRules() == other.hasSipRules() && Objects.equals(sipRules(), other.sipRules())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSipRulesResponse").add("SipRules", hasSipRules() ? sipRules() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SipRules":
            return Optional.ofNullable(clazz.cast(sipRules()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSipRulesResponse, T> g) {
        return obj -> g.apply((ListSipRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSipRulesResponse> {
        /**
         * Sets the value of the SipRules property for this object.
         *
         * @param sipRules
         *        The new value for the SipRules property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sipRules(Collection<SipRule> sipRules);

        /**
         * Sets the value of the SipRules property for this object.
         *
         * @param sipRules
         *        The new value for the SipRules property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sipRules(SipRule... sipRules);

        /**
         * Sets the value of the SipRules property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.SipRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.chimesdkvoice.model.SipRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.SipRule.Builder#build()} is called immediately and
         * its result is passed to {@link #sipRules(List<SipRule>)}.
         * 
         * @param sipRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkvoice.model.SipRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sipRules(java.util.Collection<SipRule>)
         */
        Builder sipRules(Consumer<SipRule.Builder>... sipRules);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChimeSdkVoiceResponse.BuilderImpl implements Builder {
        private List<SipRule> sipRules = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSipRulesResponse model) {
            super(model);
            sipRules(model.sipRules);
            nextToken(model.nextToken);
        }

        public final List<SipRule.Builder> getSipRules() {
            List<SipRule.Builder> result = SipRuleListCopier.copyToBuilder(this.sipRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSipRules(Collection<SipRule.BuilderImpl> sipRules) {
            this.sipRules = SipRuleListCopier.copyFromBuilder(sipRules);
        }

        @Override
        public final Builder sipRules(Collection<SipRule> sipRules) {
            this.sipRules = SipRuleListCopier.copy(sipRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sipRules(SipRule... sipRules) {
            sipRules(Arrays.asList(sipRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sipRules(Consumer<SipRule.Builder>... sipRules) {
            sipRules(Stream.of(sipRules).map(c -> SipRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSipRulesResponse build() {
            return new ListSipRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
