/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class Participant implements SdkPojo, Serializable, ToCopyableBuilder<Participant.Builder, Participant> {
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(Participant::phoneNumber)).setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<String> PROXY_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyPhoneNumber").getter(getter(Participant::proxyPhoneNumber))
            .setter(setter(Builder::proxyPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyPhoneNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_FIELD,
            PROXY_PHONE_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String phoneNumber;

    private final String proxyPhoneNumber;

    private Participant(BuilderImpl builder) {
        this.phoneNumber = builder.phoneNumber;
        this.proxyPhoneNumber = builder.proxyPhoneNumber;
    }

    /**
     * Returns the value of the PhoneNumber property for this object.
     * 
     * @return The value of the PhoneNumber property for this object.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    /**
     * Returns the value of the ProxyPhoneNumber property for this object.
     * 
     * @return The value of the ProxyPhoneNumber property for this object.
     */
    public final String proxyPhoneNumber() {
        return proxyPhoneNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(proxyPhoneNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Participant)) {
            return false;
        }
        Participant other = (Participant) obj;
        return Objects.equals(phoneNumber(), other.phoneNumber()) && Objects.equals(proxyPhoneNumber(), other.proxyPhoneNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Participant")
                .add("PhoneNumber", phoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ProxyPhoneNumber", proxyPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "ProxyPhoneNumber":
            return Optional.ofNullable(clazz.cast(proxyPhoneNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Participant, T> g) {
        return obj -> g.apply((Participant) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Participant> {
        /**
         * Sets the value of the PhoneNumber property for this object.
         *
         * @param phoneNumber
         *        The new value for the PhoneNumber property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * Sets the value of the ProxyPhoneNumber property for this object.
         *
         * @param proxyPhoneNumber
         *        The new value for the ProxyPhoneNumber property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyPhoneNumber(String proxyPhoneNumber);
    }

    static final class BuilderImpl implements Builder {
        private String phoneNumber;

        private String proxyPhoneNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(Participant model) {
            phoneNumber(model.phoneNumber);
            proxyPhoneNumber(model.proxyPhoneNumber);
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getProxyPhoneNumber() {
            return proxyPhoneNumber;
        }

        public final void setProxyPhoneNumber(String proxyPhoneNumber) {
            this.proxyPhoneNumber = proxyPhoneNumber;
        }

        @Override
        public final Builder proxyPhoneNumber(String proxyPhoneNumber) {
            this.proxyPhoneNumber = proxyPhoneNumber;
            return this;
        }

        @Override
        public Participant build() {
            return new Participant(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
