/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SipMediaApplication implements SdkPojo, Serializable,
        ToCopyableBuilder<SipMediaApplication.Builder, SipMediaApplication> {
    private static final SdkField<String> SIP_MEDIA_APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SipMediaApplicationId").getter(getter(SipMediaApplication::sipMediaApplicationId))
            .setter(setter(Builder::sipMediaApplicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SipMediaApplicationId").build())
            .build();

    private static final SdkField<String> AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsRegion").getter(getter(SipMediaApplication::awsRegion)).setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SipMediaApplication::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<SipMediaApplicationEndpoint>> ENDPOINTS_FIELD = SdkField
            .<List<SipMediaApplicationEndpoint>> builder(MarshallingType.LIST)
            .memberName("Endpoints")
            .getter(getter(SipMediaApplication::endpoints))
            .setter(setter(Builder::endpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SipMediaApplicationEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(SipMediaApplicationEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp")
            .getter(getter(SipMediaApplication::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp")
            .getter(getter(SipMediaApplication::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SIP_MEDIA_APPLICATION_ID_FIELD, AWS_REGION_FIELD, NAME_FIELD, ENDPOINTS_FIELD, CREATED_TIMESTAMP_FIELD,
            UPDATED_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sipMediaApplicationId;

    private final String awsRegion;

    private final String name;

    private final List<SipMediaApplicationEndpoint> endpoints;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private SipMediaApplication(BuilderImpl builder) {
        this.sipMediaApplicationId = builder.sipMediaApplicationId;
        this.awsRegion = builder.awsRegion;
        this.name = builder.name;
        this.endpoints = builder.endpoints;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    /**
     * Returns the value of the SipMediaApplicationId property for this object.
     * 
     * @return The value of the SipMediaApplicationId property for this object.
     */
    public final String sipMediaApplicationId() {
        return sipMediaApplicationId;
    }

    /**
     * Returns the value of the AwsRegion property for this object.
     * 
     * @return The value of the AwsRegion property for this object.
     */
    public final String awsRegion() {
        return awsRegion;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Endpoints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEndpoints() {
        return endpoints != null && !(endpoints instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Endpoints property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpoints} method.
     * </p>
     * 
     * @return The value of the Endpoints property for this object.
     */
    public final List<SipMediaApplicationEndpoint> endpoints() {
        return endpoints;
    }

    /**
     * Returns the value of the CreatedTimestamp property for this object.
     * 
     * @return The value of the CreatedTimestamp property for this object.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * Returns the value of the UpdatedTimestamp property for this object.
     * 
     * @return The value of the UpdatedTimestamp property for this object.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sipMediaApplicationId());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpoints() ? endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SipMediaApplication)) {
            return false;
        }
        SipMediaApplication other = (SipMediaApplication) obj;
        return Objects.equals(sipMediaApplicationId(), other.sipMediaApplicationId())
                && Objects.equals(awsRegion(), other.awsRegion()) && Objects.equals(name(), other.name())
                && hasEndpoints() == other.hasEndpoints() && Objects.equals(endpoints(), other.endpoints())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SipMediaApplication").add("SipMediaApplicationId", sipMediaApplicationId())
                .add("AwsRegion", awsRegion()).add("Name", name()).add("Endpoints", hasEndpoints() ? endpoints() : null)
                .add("CreatedTimestamp", createdTimestamp()).add("UpdatedTimestamp", updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SipMediaApplicationId":
            return Optional.ofNullable(clazz.cast(sipMediaApplicationId()));
        case "AwsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SipMediaApplication, T> g) {
        return obj -> g.apply((SipMediaApplication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SipMediaApplication> {
        /**
         * Sets the value of the SipMediaApplicationId property for this object.
         *
         * @param sipMediaApplicationId
         *        The new value for the SipMediaApplicationId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sipMediaApplicationId(String sipMediaApplicationId);

        /**
         * Sets the value of the AwsRegion property for this object.
         *
         * @param awsRegion
         *        The new value for the AwsRegion property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Endpoints property for this object.
         *
         * @param endpoints
         *        The new value for the Endpoints property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Collection<SipMediaApplicationEndpoint> endpoints);

        /**
         * Sets the value of the Endpoints property for this object.
         *
         * @param endpoints
         *        The new value for the Endpoints property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(SipMediaApplicationEndpoint... endpoints);

        /**
         * Sets the value of the Endpoints property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationEndpoint.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationEndpoint.Builder#build()} is
         * called immediately and its result is passed to {@link #endpoints(List<SipMediaApplicationEndpoint>)}.
         * 
         * @param endpoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoints(java.util.Collection<SipMediaApplicationEndpoint>)
         */
        Builder endpoints(Consumer<SipMediaApplicationEndpoint.Builder>... endpoints);

        /**
         * Sets the value of the CreatedTimestamp property for this object.
         *
         * @param createdTimestamp
         *        The new value for the CreatedTimestamp property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * Sets the value of the UpdatedTimestamp property for this object.
         *
         * @param updatedTimestamp
         *        The new value for the UpdatedTimestamp property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String sipMediaApplicationId;

        private String awsRegion;

        private String name;

        private List<SipMediaApplicationEndpoint> endpoints = DefaultSdkAutoConstructList.getInstance();

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(SipMediaApplication model) {
            sipMediaApplicationId(model.sipMediaApplicationId);
            awsRegion(model.awsRegion);
            name(model.name);
            endpoints(model.endpoints);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
        }

        public final String getSipMediaApplicationId() {
            return sipMediaApplicationId;
        }

        public final void setSipMediaApplicationId(String sipMediaApplicationId) {
            this.sipMediaApplicationId = sipMediaApplicationId;
        }

        @Override
        public final Builder sipMediaApplicationId(String sipMediaApplicationId) {
            this.sipMediaApplicationId = sipMediaApplicationId;
            return this;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<SipMediaApplicationEndpoint.Builder> getEndpoints() {
            List<SipMediaApplicationEndpoint.Builder> result = SipMediaApplicationEndpointListCopier
                    .copyToBuilder(this.endpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpoints(Collection<SipMediaApplicationEndpoint.BuilderImpl> endpoints) {
            this.endpoints = SipMediaApplicationEndpointListCopier.copyFromBuilder(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<SipMediaApplicationEndpoint> endpoints) {
            this.endpoints = SipMediaApplicationEndpointListCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(SipMediaApplicationEndpoint... endpoints) {
            endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<SipMediaApplicationEndpoint.Builder>... endpoints) {
            endpoints(Stream.of(endpoints).map(c -> SipMediaApplicationEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        @Override
        public SipMediaApplication build() {
            return new SipMediaApplication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
