/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SipRule implements SdkPojo, Serializable, ToCopyableBuilder<SipRule.Builder, SipRule> {
    private static final SdkField<String> SIP_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SipRuleId").getter(getter(SipRule::sipRuleId)).setter(setter(Builder::sipRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SipRuleId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SipRule::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Disabled").getter(getter(SipRule::disabled)).setter(setter(Builder::disabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()).build();

    private static final SdkField<String> TRIGGER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TriggerType").getter(getter(SipRule::triggerTypeAsString)).setter(setter(Builder::triggerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerType").build()).build();

    private static final SdkField<String> TRIGGER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TriggerValue").getter(getter(SipRule::triggerValue)).setter(setter(Builder::triggerValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerValue").build()).build();

    private static final SdkField<List<SipRuleTargetApplication>> TARGET_APPLICATIONS_FIELD = SdkField
            .<List<SipRuleTargetApplication>> builder(MarshallingType.LIST)
            .memberName("TargetApplications")
            .getter(getter(SipRule::targetApplications))
            .setter(setter(Builder::targetApplications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetApplications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SipRuleTargetApplication> builder(MarshallingType.SDK_POJO)
                                            .constructor(SipRuleTargetApplication::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp")
            .getter(getter(SipRule::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp")
            .getter(getter(SipRule::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIP_RULE_ID_FIELD, NAME_FIELD,
            DISABLED_FIELD, TRIGGER_TYPE_FIELD, TRIGGER_VALUE_FIELD, TARGET_APPLICATIONS_FIELD, CREATED_TIMESTAMP_FIELD,
            UPDATED_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sipRuleId;

    private final String name;

    private final Boolean disabled;

    private final String triggerType;

    private final String triggerValue;

    private final List<SipRuleTargetApplication> targetApplications;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private SipRule(BuilderImpl builder) {
        this.sipRuleId = builder.sipRuleId;
        this.name = builder.name;
        this.disabled = builder.disabled;
        this.triggerType = builder.triggerType;
        this.triggerValue = builder.triggerValue;
        this.targetApplications = builder.targetApplications;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    /**
     * Returns the value of the SipRuleId property for this object.
     * 
     * @return The value of the SipRuleId property for this object.
     */
    public final String sipRuleId() {
        return sipRuleId;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the Disabled property for this object.
     * 
     * @return The value of the Disabled property for this object.
     */
    public final Boolean disabled() {
        return disabled;
    }

    /**
     * Returns the value of the TriggerType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #triggerType} will
     * return {@link SipRuleTriggerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #triggerTypeAsString}.
     * </p>
     * 
     * @return The value of the TriggerType property for this object.
     * @see SipRuleTriggerType
     */
    public final SipRuleTriggerType triggerType() {
        return SipRuleTriggerType.fromValue(triggerType);
    }

    /**
     * Returns the value of the TriggerType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #triggerType} will
     * return {@link SipRuleTriggerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #triggerTypeAsString}.
     * </p>
     * 
     * @return The value of the TriggerType property for this object.
     * @see SipRuleTriggerType
     */
    public final String triggerTypeAsString() {
        return triggerType;
    }

    /**
     * Returns the value of the TriggerValue property for this object.
     * 
     * @return The value of the TriggerValue property for this object.
     */
    public final String triggerValue() {
        return triggerValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetApplications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetApplications() {
        return targetApplications != null && !(targetApplications instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the TargetApplications property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetApplications} method.
     * </p>
     * 
     * @return The value of the TargetApplications property for this object.
     */
    public final List<SipRuleTargetApplication> targetApplications() {
        return targetApplications;
    }

    /**
     * Returns the value of the CreatedTimestamp property for this object.
     * 
     * @return The value of the CreatedTimestamp property for this object.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * Returns the value of the UpdatedTimestamp property for this object.
     * 
     * @return The value of the UpdatedTimestamp property for this object.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sipRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(disabled());
        hashCode = 31 * hashCode + Objects.hashCode(triggerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(triggerValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetApplications() ? targetApplications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SipRule)) {
            return false;
        }
        SipRule other = (SipRule) obj;
        return Objects.equals(sipRuleId(), other.sipRuleId()) && Objects.equals(name(), other.name())
                && Objects.equals(disabled(), other.disabled())
                && Objects.equals(triggerTypeAsString(), other.triggerTypeAsString())
                && Objects.equals(triggerValue(), other.triggerValue())
                && hasTargetApplications() == other.hasTargetApplications()
                && Objects.equals(targetApplications(), other.targetApplications())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SipRule").add("SipRuleId", sipRuleId()).add("Name", name()).add("Disabled", disabled())
                .add("TriggerType", triggerTypeAsString()).add("TriggerValue", triggerValue())
                .add("TargetApplications", hasTargetApplications() ? targetApplications() : null)
                .add("CreatedTimestamp", createdTimestamp()).add("UpdatedTimestamp", updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SipRuleId":
            return Optional.ofNullable(clazz.cast(sipRuleId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Disabled":
            return Optional.ofNullable(clazz.cast(disabled()));
        case "TriggerType":
            return Optional.ofNullable(clazz.cast(triggerTypeAsString()));
        case "TriggerValue":
            return Optional.ofNullable(clazz.cast(triggerValue()));
        case "TargetApplications":
            return Optional.ofNullable(clazz.cast(targetApplications()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SipRule, T> g) {
        return obj -> g.apply((SipRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SipRule> {
        /**
         * Sets the value of the SipRuleId property for this object.
         *
         * @param sipRuleId
         *        The new value for the SipRuleId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sipRuleId(String sipRuleId);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Disabled property for this object.
         *
         * @param disabled
         *        The new value for the Disabled property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabled(Boolean disabled);

        /**
         * Sets the value of the TriggerType property for this object.
         *
         * @param triggerType
         *        The new value for the TriggerType property for this object.
         * @see SipRuleTriggerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SipRuleTriggerType
         */
        Builder triggerType(String triggerType);

        /**
         * Sets the value of the TriggerType property for this object.
         *
         * @param triggerType
         *        The new value for the TriggerType property for this object.
         * @see SipRuleTriggerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SipRuleTriggerType
         */
        Builder triggerType(SipRuleTriggerType triggerType);

        /**
         * Sets the value of the TriggerValue property for this object.
         *
         * @param triggerValue
         *        The new value for the TriggerValue property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerValue(String triggerValue);

        /**
         * Sets the value of the TargetApplications property for this object.
         *
         * @param targetApplications
         *        The new value for the TargetApplications property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetApplications(Collection<SipRuleTargetApplication> targetApplications);

        /**
         * Sets the value of the TargetApplications property for this object.
         *
         * @param targetApplications
         *        The new value for the TargetApplications property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetApplications(SipRuleTargetApplication... targetApplications);

        /**
         * Sets the value of the TargetApplications property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.SipRuleTargetApplication.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.SipRuleTargetApplication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.SipRuleTargetApplication.Builder#build()} is
         * called immediately and its result is passed to {@link #targetApplications(List<SipRuleTargetApplication>)}.
         * 
         * @param targetApplications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkvoice.model.SipRuleTargetApplication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetApplications(java.util.Collection<SipRuleTargetApplication>)
         */
        Builder targetApplications(Consumer<SipRuleTargetApplication.Builder>... targetApplications);

        /**
         * Sets the value of the CreatedTimestamp property for this object.
         *
         * @param createdTimestamp
         *        The new value for the CreatedTimestamp property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * Sets the value of the UpdatedTimestamp property for this object.
         *
         * @param updatedTimestamp
         *        The new value for the UpdatedTimestamp property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String sipRuleId;

        private String name;

        private Boolean disabled;

        private String triggerType;

        private String triggerValue;

        private List<SipRuleTargetApplication> targetApplications = DefaultSdkAutoConstructList.getInstance();

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(SipRule model) {
            sipRuleId(model.sipRuleId);
            name(model.name);
            disabled(model.disabled);
            triggerType(model.triggerType);
            triggerValue(model.triggerValue);
            targetApplications(model.targetApplications);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
        }

        public final String getSipRuleId() {
            return sipRuleId;
        }

        public final void setSipRuleId(String sipRuleId) {
            this.sipRuleId = sipRuleId;
        }

        @Override
        public final Builder sipRuleId(String sipRuleId) {
            this.sipRuleId = sipRuleId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getDisabled() {
            return disabled;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public final String getTriggerType() {
            return triggerType;
        }

        public final void setTriggerType(String triggerType) {
            this.triggerType = triggerType;
        }

        @Override
        public final Builder triggerType(String triggerType) {
            this.triggerType = triggerType;
            return this;
        }

        @Override
        public final Builder triggerType(SipRuleTriggerType triggerType) {
            this.triggerType(triggerType == null ? null : triggerType.toString());
            return this;
        }

        public final String getTriggerValue() {
            return triggerValue;
        }

        public final void setTriggerValue(String triggerValue) {
            this.triggerValue = triggerValue;
        }

        @Override
        public final Builder triggerValue(String triggerValue) {
            this.triggerValue = triggerValue;
            return this;
        }

        public final List<SipRuleTargetApplication.Builder> getTargetApplications() {
            List<SipRuleTargetApplication.Builder> result = SipRuleTargetApplicationListCopier
                    .copyToBuilder(this.targetApplications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetApplications(Collection<SipRuleTargetApplication.BuilderImpl> targetApplications) {
            this.targetApplications = SipRuleTargetApplicationListCopier.copyFromBuilder(targetApplications);
        }

        @Override
        public final Builder targetApplications(Collection<SipRuleTargetApplication> targetApplications) {
            this.targetApplications = SipRuleTargetApplicationListCopier.copy(targetApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetApplications(SipRuleTargetApplication... targetApplications) {
            targetApplications(Arrays.asList(targetApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetApplications(Consumer<SipRuleTargetApplication.Builder>... targetApplications) {
            targetApplications(Stream.of(targetApplications)
                    .map(c -> SipRuleTargetApplication.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        @Override
        public SipRule build() {
            return new SipRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
