/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class Termination implements SdkPojo, Serializable, ToCopyableBuilder<Termination.Builder, Termination> {
    private static final SdkField<Integer> CPS_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CpsLimit").getter(getter(Termination::cpsLimit)).setter(setter(Builder::cpsLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpsLimit").build()).build();

    private static final SdkField<String> DEFAULT_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultPhoneNumber").getter(getter(Termination::defaultPhoneNumber))
            .setter(setter(Builder::defaultPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultPhoneNumber").build())
            .build();

    private static final SdkField<List<String>> CALLING_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CallingRegions")
            .getter(getter(Termination::callingRegions))
            .setter(setter(Builder::callingRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallingRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CIDR_ALLOWED_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CidrAllowedList")
            .getter(getter(Termination::cidrAllowedList))
            .setter(setter(Builder::cidrAllowedList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrAllowedList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Disabled").getter(getter(Termination::disabled)).setter(setter(Builder::disabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPS_LIMIT_FIELD,
            DEFAULT_PHONE_NUMBER_FIELD, CALLING_REGIONS_FIELD, CIDR_ALLOWED_LIST_FIELD, DISABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer cpsLimit;

    private final String defaultPhoneNumber;

    private final List<String> callingRegions;

    private final List<String> cidrAllowedList;

    private final Boolean disabled;

    private Termination(BuilderImpl builder) {
        this.cpsLimit = builder.cpsLimit;
        this.defaultPhoneNumber = builder.defaultPhoneNumber;
        this.callingRegions = builder.callingRegions;
        this.cidrAllowedList = builder.cidrAllowedList;
        this.disabled = builder.disabled;
    }

    /**
     * Returns the value of the CpsLimit property for this object.
     * 
     * @return The value of the CpsLimit property for this object.
     */
    public final Integer cpsLimit() {
        return cpsLimit;
    }

    /**
     * Returns the value of the DefaultPhoneNumber property for this object.
     * 
     * @return The value of the DefaultPhoneNumber property for this object.
     */
    public final String defaultPhoneNumber() {
        return defaultPhoneNumber;
    }

    /**
     * For responses, this returns true if the service returned a value for the CallingRegions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCallingRegions() {
        return callingRegions != null && !(callingRegions instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the CallingRegions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCallingRegions} method.
     * </p>
     * 
     * @return The value of the CallingRegions property for this object.
     */
    public final List<String> callingRegions() {
        return callingRegions;
    }

    /**
     * For responses, this returns true if the service returned a value for the CidrAllowedList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCidrAllowedList() {
        return cidrAllowedList != null && !(cidrAllowedList instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the CidrAllowedList property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCidrAllowedList} method.
     * </p>
     * 
     * @return The value of the CidrAllowedList property for this object.
     */
    public final List<String> cidrAllowedList() {
        return cidrAllowedList;
    }

    /**
     * Returns the value of the Disabled property for this object.
     * 
     * @return The value of the Disabled property for this object.
     */
    public final Boolean disabled() {
        return disabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cpsLimit());
        hashCode = 31 * hashCode + Objects.hashCode(defaultPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(hasCallingRegions() ? callingRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCidrAllowedList() ? cidrAllowedList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(disabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Termination)) {
            return false;
        }
        Termination other = (Termination) obj;
        return Objects.equals(cpsLimit(), other.cpsLimit()) && Objects.equals(defaultPhoneNumber(), other.defaultPhoneNumber())
                && hasCallingRegions() == other.hasCallingRegions() && Objects.equals(callingRegions(), other.callingRegions())
                && hasCidrAllowedList() == other.hasCidrAllowedList()
                && Objects.equals(cidrAllowedList(), other.cidrAllowedList()) && Objects.equals(disabled(), other.disabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Termination").add("CpsLimit", cpsLimit())
                .add("DefaultPhoneNumber", defaultPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CallingRegions", hasCallingRegions() ? callingRegions() : null)
                .add("CidrAllowedList", hasCidrAllowedList() ? cidrAllowedList() : null).add("Disabled", disabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CpsLimit":
            return Optional.ofNullable(clazz.cast(cpsLimit()));
        case "DefaultPhoneNumber":
            return Optional.ofNullable(clazz.cast(defaultPhoneNumber()));
        case "CallingRegions":
            return Optional.ofNullable(clazz.cast(callingRegions()));
        case "CidrAllowedList":
            return Optional.ofNullable(clazz.cast(cidrAllowedList()));
        case "Disabled":
            return Optional.ofNullable(clazz.cast(disabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Termination, T> g) {
        return obj -> g.apply((Termination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Termination> {
        /**
         * Sets the value of the CpsLimit property for this object.
         *
         * @param cpsLimit
         *        The new value for the CpsLimit property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpsLimit(Integer cpsLimit);

        /**
         * Sets the value of the DefaultPhoneNumber property for this object.
         *
         * @param defaultPhoneNumber
         *        The new value for the DefaultPhoneNumber property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultPhoneNumber(String defaultPhoneNumber);

        /**
         * Sets the value of the CallingRegions property for this object.
         *
         * @param callingRegions
         *        The new value for the CallingRegions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callingRegions(Collection<String> callingRegions);

        /**
         * Sets the value of the CallingRegions property for this object.
         *
         * @param callingRegions
         *        The new value for the CallingRegions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callingRegions(String... callingRegions);

        /**
         * Sets the value of the CidrAllowedList property for this object.
         *
         * @param cidrAllowedList
         *        The new value for the CidrAllowedList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrAllowedList(Collection<String> cidrAllowedList);

        /**
         * Sets the value of the CidrAllowedList property for this object.
         *
         * @param cidrAllowedList
         *        The new value for the CidrAllowedList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrAllowedList(String... cidrAllowedList);

        /**
         * Sets the value of the Disabled property for this object.
         *
         * @param disabled
         *        The new value for the Disabled property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabled(Boolean disabled);
    }

    static final class BuilderImpl implements Builder {
        private Integer cpsLimit;

        private String defaultPhoneNumber;

        private List<String> callingRegions = DefaultSdkAutoConstructList.getInstance();

        private List<String> cidrAllowedList = DefaultSdkAutoConstructList.getInstance();

        private Boolean disabled;

        private BuilderImpl() {
        }

        private BuilderImpl(Termination model) {
            cpsLimit(model.cpsLimit);
            defaultPhoneNumber(model.defaultPhoneNumber);
            callingRegions(model.callingRegions);
            cidrAllowedList(model.cidrAllowedList);
            disabled(model.disabled);
        }

        public final Integer getCpsLimit() {
            return cpsLimit;
        }

        public final void setCpsLimit(Integer cpsLimit) {
            this.cpsLimit = cpsLimit;
        }

        @Override
        public final Builder cpsLimit(Integer cpsLimit) {
            this.cpsLimit = cpsLimit;
            return this;
        }

        public final String getDefaultPhoneNumber() {
            return defaultPhoneNumber;
        }

        public final void setDefaultPhoneNumber(String defaultPhoneNumber) {
            this.defaultPhoneNumber = defaultPhoneNumber;
        }

        @Override
        public final Builder defaultPhoneNumber(String defaultPhoneNumber) {
            this.defaultPhoneNumber = defaultPhoneNumber;
            return this;
        }

        public final Collection<String> getCallingRegions() {
            if (callingRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return callingRegions;
        }

        public final void setCallingRegions(Collection<String> callingRegions) {
            this.callingRegions = CallingRegionListCopier.copy(callingRegions);
        }

        @Override
        public final Builder callingRegions(Collection<String> callingRegions) {
            this.callingRegions = CallingRegionListCopier.copy(callingRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callingRegions(String... callingRegions) {
            callingRegions(Arrays.asList(callingRegions));
            return this;
        }

        public final Collection<String> getCidrAllowedList() {
            if (cidrAllowedList instanceof SdkAutoConstructList) {
                return null;
            }
            return cidrAllowedList;
        }

        public final void setCidrAllowedList(Collection<String> cidrAllowedList) {
            this.cidrAllowedList = StringListCopier.copy(cidrAllowedList);
        }

        @Override
        public final Builder cidrAllowedList(Collection<String> cidrAllowedList) {
            this.cidrAllowedList = StringListCopier.copy(cidrAllowedList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrAllowedList(String... cidrAllowedList) {
            cidrAllowedList(Arrays.asList(cidrAllowedList));
            return this;
        }

        public final Boolean getDisabled() {
            return disabled;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        @Override
        public Termination build() {
            return new Termination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
