/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidateE911AddressRequest extends ChimeSdkVoiceRequest implements
        ToCopyableBuilder<ValidateE911AddressRequest.Builder, ValidateE911AddressRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(ValidateE911AddressRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> STREET_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreetNumber").getter(getter(ValidateE911AddressRequest::streetNumber))
            .setter(setter(Builder::streetNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreetNumber").build()).build();

    private static final SdkField<String> STREET_INFO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreetInfo").getter(getter(ValidateE911AddressRequest::streetInfo)).setter(setter(Builder::streetInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreetInfo").build()).build();

    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("City")
            .getter(getter(ValidateE911AddressRequest::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ValidateE911AddressRequest::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Country")
            .getter(getter(ValidateE911AddressRequest::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PostalCode").getter(getter(ValidateE911AddressRequest::postalCode)).setter(setter(Builder::postalCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            STREET_NUMBER_FIELD, STREET_INFO_FIELD, CITY_FIELD, STATE_FIELD, COUNTRY_FIELD, POSTAL_CODE_FIELD));

    private final String awsAccountId;

    private final String streetNumber;

    private final String streetInfo;

    private final String city;

    private final String state;

    private final String country;

    private final String postalCode;

    private ValidateE911AddressRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.streetNumber = builder.streetNumber;
        this.streetInfo = builder.streetInfo;
        this.city = builder.city;
        this.state = builder.state;
        this.country = builder.country;
        this.postalCode = builder.postalCode;
    }

    /**
     * Returns the value of the AwsAccountId property for this object.
     * 
     * @return The value of the AwsAccountId property for this object.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * Returns the value of the StreetNumber property for this object.
     * 
     * @return The value of the StreetNumber property for this object.
     */
    public final String streetNumber() {
        return streetNumber;
    }

    /**
     * Returns the value of the StreetInfo property for this object.
     * 
     * @return The value of the StreetInfo property for this object.
     */
    public final String streetInfo() {
        return streetInfo;
    }

    /**
     * Returns the value of the City property for this object.
     * 
     * @return The value of the City property for this object.
     */
    public final String city() {
        return city;
    }

    /**
     * Returns the value of the State property for this object.
     * 
     * @return The value of the State property for this object.
     */
    public final String state() {
        return state;
    }

    /**
     * Returns the value of the Country property for this object.
     * 
     * @return The value of the Country property for this object.
     */
    public final String country() {
        return country;
    }

    /**
     * Returns the value of the PostalCode property for this object.
     * 
     * @return The value of the PostalCode property for this object.
     */
    public final String postalCode() {
        return postalCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(streetNumber());
        hashCode = 31 * hashCode + Objects.hashCode(streetInfo());
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(postalCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateE911AddressRequest)) {
            return false;
        }
        ValidateE911AddressRequest other = (ValidateE911AddressRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(streetNumber(), other.streetNumber())
                && Objects.equals(streetInfo(), other.streetInfo()) && Objects.equals(city(), other.city())
                && Objects.equals(state(), other.state()) && Objects.equals(country(), other.country())
                && Objects.equals(postalCode(), other.postalCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidateE911AddressRequest").add("AwsAccountId", awsAccountId())
                .add("StreetNumber", streetNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StreetInfo", streetInfo() == null ? null : "*** Sensitive Data Redacted ***")
                .add("City", city() == null ? null : "*** Sensitive Data Redacted ***")
                .add("State", state() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Country", country() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PostalCode", postalCode() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "StreetNumber":
            return Optional.ofNullable(clazz.cast(streetNumber()));
        case "StreetInfo":
            return Optional.ofNullable(clazz.cast(streetInfo()));
        case "City":
            return Optional.ofNullable(clazz.cast(city()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "PostalCode":
            return Optional.ofNullable(clazz.cast(postalCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidateE911AddressRequest, T> g) {
        return obj -> g.apply((ValidateE911AddressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceRequest.Builder, SdkPojo, CopyableBuilder<Builder, ValidateE911AddressRequest> {
        /**
         * Sets the value of the AwsAccountId property for this object.
         *
         * @param awsAccountId
         *        The new value for the AwsAccountId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * Sets the value of the StreetNumber property for this object.
         *
         * @param streetNumber
         *        The new value for the StreetNumber property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streetNumber(String streetNumber);

        /**
         * Sets the value of the StreetInfo property for this object.
         *
         * @param streetInfo
         *        The new value for the StreetInfo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streetInfo(String streetInfo);

        /**
         * Sets the value of the City property for this object.
         *
         * @param city
         *        The new value for the City property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * Sets the value of the State property for this object.
         *
         * @param state
         *        The new value for the State property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * Sets the value of the Country property for this object.
         *
         * @param country
         *        The new value for the Country property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * Sets the value of the PostalCode property for this object.
         *
         * @param postalCode
         *        The new value for the PostalCode property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(String postalCode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkVoiceRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String streetNumber;

        private String streetInfo;

        private String city;

        private String state;

        private String country;

        private String postalCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateE911AddressRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            streetNumber(model.streetNumber);
            streetInfo(model.streetInfo);
            city(model.city);
            state(model.state);
            country(model.country);
            postalCode(model.postalCode);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getStreetNumber() {
            return streetNumber;
        }

        public final void setStreetNumber(String streetNumber) {
            this.streetNumber = streetNumber;
        }

        @Override
        public final Builder streetNumber(String streetNumber) {
            this.streetNumber = streetNumber;
            return this;
        }

        public final String getStreetInfo() {
            return streetInfo;
        }

        public final void setStreetInfo(String streetInfo) {
            this.streetInfo = streetInfo;
        }

        @Override
        public final Builder streetInfo(String streetInfo) {
            this.streetInfo = streetInfo;
            return this;
        }

        public final String getCity() {
            return city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getPostalCode() {
            return postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ValidateE911AddressRequest build() {
            return new ValidateE911AddressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
