/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class VoiceToneAnalysisTask implements SdkPojo, Serializable,
        ToCopyableBuilder<VoiceToneAnalysisTask.Builder, VoiceToneAnalysisTask> {
    private static final SdkField<String> VOICE_TONE_ANALYSIS_TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceToneAnalysisTaskId").getter(getter(VoiceToneAnalysisTask::voiceToneAnalysisTaskId))
            .setter(setter(Builder::voiceToneAnalysisTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceToneAnalysisTaskId").build())
            .build();

    private static final SdkField<String> VOICE_TONE_ANALYSIS_TASK_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VoiceToneAnalysisTaskStatus")
            .getter(getter(VoiceToneAnalysisTask::voiceToneAnalysisTaskStatus))
            .setter(setter(Builder::voiceToneAnalysisTaskStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceToneAnalysisTaskStatus")
                    .build()).build();

    private static final SdkField<CallDetails> CALL_DETAILS_FIELD = SdkField.<CallDetails> builder(MarshallingType.SDK_POJO)
            .memberName("CallDetails").getter(getter(VoiceToneAnalysisTask::callDetails)).setter(setter(Builder::callDetails))
            .constructor(CallDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallDetails").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp")
            .getter(getter(VoiceToneAnalysisTask::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp")
            .getter(getter(VoiceToneAnalysisTask::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> STARTED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedTimestamp")
            .getter(getter(VoiceToneAnalysisTask::startedTimestamp))
            .setter(setter(Builder::startedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(VoiceToneAnalysisTask::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VOICE_TONE_ANALYSIS_TASK_ID_FIELD, VOICE_TONE_ANALYSIS_TASK_STATUS_FIELD, CALL_DETAILS_FIELD,
            CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD, STARTED_TIMESTAMP_FIELD, STATUS_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String voiceToneAnalysisTaskId;

    private final String voiceToneAnalysisTaskStatus;

    private final CallDetails callDetails;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private final Instant startedTimestamp;

    private final String statusMessage;

    private VoiceToneAnalysisTask(BuilderImpl builder) {
        this.voiceToneAnalysisTaskId = builder.voiceToneAnalysisTaskId;
        this.voiceToneAnalysisTaskStatus = builder.voiceToneAnalysisTaskStatus;
        this.callDetails = builder.callDetails;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
        this.startedTimestamp = builder.startedTimestamp;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * Returns the value of the VoiceToneAnalysisTaskId property for this object.
     * 
     * @return The value of the VoiceToneAnalysisTaskId property for this object.
     */
    public final String voiceToneAnalysisTaskId() {
        return voiceToneAnalysisTaskId;
    }

    /**
     * Returns the value of the VoiceToneAnalysisTaskStatus property for this object.
     * 
     * @return The value of the VoiceToneAnalysisTaskStatus property for this object.
     */
    public final String voiceToneAnalysisTaskStatus() {
        return voiceToneAnalysisTaskStatus;
    }

    /**
     * Returns the value of the CallDetails property for this object.
     * 
     * @return The value of the CallDetails property for this object.
     */
    public final CallDetails callDetails() {
        return callDetails;
    }

    /**
     * Returns the value of the CreatedTimestamp property for this object.
     * 
     * @return The value of the CreatedTimestamp property for this object.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * Returns the value of the UpdatedTimestamp property for this object.
     * 
     * @return The value of the UpdatedTimestamp property for this object.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    /**
     * Returns the value of the StartedTimestamp property for this object.
     * 
     * @return The value of the StartedTimestamp property for this object.
     */
    public final Instant startedTimestamp() {
        return startedTimestamp;
    }

    /**
     * Returns the value of the StatusMessage property for this object.
     * 
     * @return The value of the StatusMessage property for this object.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(voiceToneAnalysisTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(voiceToneAnalysisTaskStatus());
        hashCode = 31 * hashCode + Objects.hashCode(callDetails());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(startedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceToneAnalysisTask)) {
            return false;
        }
        VoiceToneAnalysisTask other = (VoiceToneAnalysisTask) obj;
        return Objects.equals(voiceToneAnalysisTaskId(), other.voiceToneAnalysisTaskId())
                && Objects.equals(voiceToneAnalysisTaskStatus(), other.voiceToneAnalysisTaskStatus())
                && Objects.equals(callDetails(), other.callDetails())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp())
                && Objects.equals(startedTimestamp(), other.startedTimestamp())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VoiceToneAnalysisTask").add("VoiceToneAnalysisTaskId", voiceToneAnalysisTaskId())
                .add("VoiceToneAnalysisTaskStatus", voiceToneAnalysisTaskStatus()).add("CallDetails", callDetails())
                .add("CreatedTimestamp", createdTimestamp()).add("UpdatedTimestamp", updatedTimestamp())
                .add("StartedTimestamp", startedTimestamp()).add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceToneAnalysisTaskId":
            return Optional.ofNullable(clazz.cast(voiceToneAnalysisTaskId()));
        case "VoiceToneAnalysisTaskStatus":
            return Optional.ofNullable(clazz.cast(voiceToneAnalysisTaskStatus()));
        case "CallDetails":
            return Optional.ofNullable(clazz.cast(callDetails()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        case "StartedTimestamp":
            return Optional.ofNullable(clazz.cast(startedTimestamp()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VoiceToneAnalysisTask, T> g) {
        return obj -> g.apply((VoiceToneAnalysisTask) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VoiceToneAnalysisTask> {
        /**
         * Sets the value of the VoiceToneAnalysisTaskId property for this object.
         *
         * @param voiceToneAnalysisTaskId
         *        The new value for the VoiceToneAnalysisTaskId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceToneAnalysisTaskId(String voiceToneAnalysisTaskId);

        /**
         * Sets the value of the VoiceToneAnalysisTaskStatus property for this object.
         *
         * @param voiceToneAnalysisTaskStatus
         *        The new value for the VoiceToneAnalysisTaskStatus property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceToneAnalysisTaskStatus(String voiceToneAnalysisTaskStatus);

        /**
         * Sets the value of the CallDetails property for this object.
         *
         * @param callDetails
         *        The new value for the CallDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callDetails(CallDetails callDetails);

        /**
         * Sets the value of the CallDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CallDetails.Builder} avoiding the need to
         * create one manually via {@link CallDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CallDetails.Builder#build()} is called immediately and its result
         * is passed to {@link #callDetails(CallDetails)}.
         * 
         * @param callDetails
         *        a consumer that will call methods on {@link CallDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #callDetails(CallDetails)
         */
        default Builder callDetails(Consumer<CallDetails.Builder> callDetails) {
            return callDetails(CallDetails.builder().applyMutation(callDetails).build());
        }

        /**
         * Sets the value of the CreatedTimestamp property for this object.
         *
         * @param createdTimestamp
         *        The new value for the CreatedTimestamp property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * Sets the value of the UpdatedTimestamp property for this object.
         *
         * @param updatedTimestamp
         *        The new value for the UpdatedTimestamp property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);

        /**
         * Sets the value of the StartedTimestamp property for this object.
         *
         * @param startedTimestamp
         *        The new value for the StartedTimestamp property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedTimestamp(Instant startedTimestamp);

        /**
         * Sets the value of the StatusMessage property for this object.
         *
         * @param statusMessage
         *        The new value for the StatusMessage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String voiceToneAnalysisTaskId;

        private String voiceToneAnalysisTaskStatus;

        private CallDetails callDetails;

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private Instant startedTimestamp;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceToneAnalysisTask model) {
            voiceToneAnalysisTaskId(model.voiceToneAnalysisTaskId);
            voiceToneAnalysisTaskStatus(model.voiceToneAnalysisTaskStatus);
            callDetails(model.callDetails);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
            startedTimestamp(model.startedTimestamp);
            statusMessage(model.statusMessage);
        }

        public final String getVoiceToneAnalysisTaskId() {
            return voiceToneAnalysisTaskId;
        }

        public final void setVoiceToneAnalysisTaskId(String voiceToneAnalysisTaskId) {
            this.voiceToneAnalysisTaskId = voiceToneAnalysisTaskId;
        }

        @Override
        public final Builder voiceToneAnalysisTaskId(String voiceToneAnalysisTaskId) {
            this.voiceToneAnalysisTaskId = voiceToneAnalysisTaskId;
            return this;
        }

        public final String getVoiceToneAnalysisTaskStatus() {
            return voiceToneAnalysisTaskStatus;
        }

        public final void setVoiceToneAnalysisTaskStatus(String voiceToneAnalysisTaskStatus) {
            this.voiceToneAnalysisTaskStatus = voiceToneAnalysisTaskStatus;
        }

        @Override
        public final Builder voiceToneAnalysisTaskStatus(String voiceToneAnalysisTaskStatus) {
            this.voiceToneAnalysisTaskStatus = voiceToneAnalysisTaskStatus;
            return this;
        }

        public final CallDetails.Builder getCallDetails() {
            return callDetails != null ? callDetails.toBuilder() : null;
        }

        public final void setCallDetails(CallDetails.BuilderImpl callDetails) {
            this.callDetails = callDetails != null ? callDetails.build() : null;
        }

        @Override
        public final Builder callDetails(CallDetails callDetails) {
            this.callDetails = callDetails;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final Instant getStartedTimestamp() {
            return startedTimestamp;
        }

        public final void setStartedTimestamp(Instant startedTimestamp) {
            this.startedTimestamp = startedTimestamp;
        }

        @Override
        public final Builder startedTimestamp(Instant startedTimestamp) {
            this.startedTimestamp = startedTimestamp;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public VoiceToneAnalysisTask build() {
            return new VoiceToneAnalysisTask(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
