/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSpeakerSearchTaskRequest extends ChimeSdkVoiceRequest implements
        ToCopyableBuilder<StartSpeakerSearchTaskRequest.Builder, StartSpeakerSearchTaskRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceConnectorId").getter(getter(StartSpeakerSearchTaskRequest::voiceConnectorId))
            .setter(setter(Builder::voiceConnectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("VoiceConnectorId").build()).build();

    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransactionId").getter(getter(StartSpeakerSearchTaskRequest::transactionId))
            .setter(setter(Builder::transactionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()).build();

    private static final SdkField<String> VOICE_PROFILE_DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceProfileDomainId").getter(getter(StartSpeakerSearchTaskRequest::voiceProfileDomainId))
            .setter(setter(Builder::voiceProfileDomainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceProfileDomainId").build())
            .build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken").getter(getter(StartSpeakerSearchTaskRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD,
            TRANSACTION_ID_FIELD, VOICE_PROFILE_DOMAIN_ID_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final String voiceConnectorId;

    private final String transactionId;

    private final String voiceProfileDomainId;

    private final String clientRequestToken;

    private StartSpeakerSearchTaskRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorId = builder.voiceConnectorId;
        this.transactionId = builder.transactionId;
        this.voiceProfileDomainId = builder.voiceProfileDomainId;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The Voice Connector ID.
     * </p>
     * 
     * @return The Voice Connector ID.
     */
    public final String voiceConnectorId() {
        return voiceConnectorId;
    }

    /**
     * <p>
     * The transaction ID of the call being analyzed.
     * </p>
     * 
     * @return The transaction ID of the call being analyzed.
     */
    public final String transactionId() {
        return transactionId;
    }

    /**
     * <p>
     * The ID of the voice profile domain that will store the voice profile.
     * </p>
     * 
     * @return The ID of the voice profile domain that will store the voice profile.
     */
    public final String voiceProfileDomainId() {
        return voiceProfileDomainId;
    }

    /**
     * <p>
     * The unique identifier for the client request. Use a different token for different speaker search tasks.
     * </p>
     * 
     * @return The unique identifier for the client request. Use a different token for different speaker search tasks.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(voiceProfileDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSpeakerSearchTaskRequest)) {
            return false;
        }
        StartSpeakerSearchTaskRequest other = (StartSpeakerSearchTaskRequest) obj;
        return Objects.equals(voiceConnectorId(), other.voiceConnectorId())
                && Objects.equals(transactionId(), other.transactionId())
                && Objects.equals(voiceProfileDomainId(), other.voiceProfileDomainId())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSpeakerSearchTaskRequest").add("VoiceConnectorId", voiceConnectorId())
                .add("TransactionId", transactionId()).add("VoiceProfileDomainId", voiceProfileDomainId())
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceConnectorId":
            return Optional.ofNullable(clazz.cast(voiceConnectorId()));
        case "TransactionId":
            return Optional.ofNullable(clazz.cast(transactionId()));
        case "VoiceProfileDomainId":
            return Optional.ofNullable(clazz.cast(voiceProfileDomainId()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSpeakerSearchTaskRequest, T> g) {
        return obj -> g.apply((StartSpeakerSearchTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartSpeakerSearchTaskRequest> {
        /**
         * <p>
         * The Voice Connector ID.
         * </p>
         * 
         * @param voiceConnectorId
         *        The Voice Connector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorId(String voiceConnectorId);

        /**
         * <p>
         * The transaction ID of the call being analyzed.
         * </p>
         * 
         * @param transactionId
         *        The transaction ID of the call being analyzed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionId(String transactionId);

        /**
         * <p>
         * The ID of the voice profile domain that will store the voice profile.
         * </p>
         * 
         * @param voiceProfileDomainId
         *        The ID of the voice profile domain that will store the voice profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceProfileDomainId(String voiceProfileDomainId);

        /**
         * <p>
         * The unique identifier for the client request. Use a different token for different speaker search tasks.
         * </p>
         * 
         * @param clientRequestToken
         *        The unique identifier for the client request. Use a different token for different speaker search
         *        tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkVoiceRequest.BuilderImpl implements Builder {
        private String voiceConnectorId;

        private String transactionId;

        private String voiceProfileDomainId;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSpeakerSearchTaskRequest model) {
            super(model);
            voiceConnectorId(model.voiceConnectorId);
            transactionId(model.transactionId);
            voiceProfileDomainId(model.voiceProfileDomainId);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getVoiceConnectorId() {
            return voiceConnectorId;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final String getTransactionId() {
            return transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final String getVoiceProfileDomainId() {
            return voiceProfileDomainId;
        }

        public final void setVoiceProfileDomainId(String voiceProfileDomainId) {
            this.voiceProfileDomainId = voiceProfileDomainId;
        }

        @Override
        public final Builder voiceProfileDomainId(String voiceProfileDomainId) {
            this.voiceProfileDomainId = voiceProfileDomainId;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSpeakerSearchTaskRequest build() {
            return new StartSpeakerSearchTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
