/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkvoice.model.AlexaSkillIdListCopier;
import software.amazon.awssdk.services.chimesdkvoice.model.AlexaSkillStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SipMediaApplicationAlexaSkillConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SipMediaApplicationAlexaSkillConfiguration> {
    private static final SdkField<String> ALEXA_SKILL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlexaSkillStatus").getter(SipMediaApplicationAlexaSkillConfiguration.getter(SipMediaApplicationAlexaSkillConfiguration::alexaSkillStatusAsString)).setter(SipMediaApplicationAlexaSkillConfiguration.setter(Builder::alexaSkillStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlexaSkillStatus").build()}).build();
    private static final SdkField<List<String>> ALEXA_SKILL_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AlexaSkillIds").getter(SipMediaApplicationAlexaSkillConfiguration.getter(SipMediaApplicationAlexaSkillConfiguration::alexaSkillIds)).setter(SipMediaApplicationAlexaSkillConfiguration.setter(Builder::alexaSkillIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlexaSkillIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALEXA_SKILL_STATUS_FIELD, ALEXA_SKILL_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String alexaSkillStatus;
    private final List<String> alexaSkillIds;

    private SipMediaApplicationAlexaSkillConfiguration(BuilderImpl builder) {
        this.alexaSkillStatus = builder.alexaSkillStatus;
        this.alexaSkillIds = builder.alexaSkillIds;
    }

    public final AlexaSkillStatus alexaSkillStatus() {
        return AlexaSkillStatus.fromValue(this.alexaSkillStatus);
    }

    public final String alexaSkillStatusAsString() {
        return this.alexaSkillStatus;
    }

    public final boolean hasAlexaSkillIds() {
        return this.alexaSkillIds != null && !(this.alexaSkillIds instanceof SdkAutoConstructList);
    }

    public final List<String> alexaSkillIds() {
        return this.alexaSkillIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alexaSkillStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlexaSkillIds() ? this.alexaSkillIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SipMediaApplicationAlexaSkillConfiguration)) {
            return false;
        }
        SipMediaApplicationAlexaSkillConfiguration other = (SipMediaApplicationAlexaSkillConfiguration)obj;
        return Objects.equals(this.alexaSkillStatusAsString(), other.alexaSkillStatusAsString()) && this.hasAlexaSkillIds() == other.hasAlexaSkillIds() && Objects.equals(this.alexaSkillIds(), other.alexaSkillIds());
    }

    public final String toString() {
        return ToString.builder((String)"SipMediaApplicationAlexaSkillConfiguration").add("AlexaSkillStatus", (Object)this.alexaSkillStatusAsString()).add("AlexaSkillIds", (Object)(this.alexaSkillIds() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlexaSkillStatus": {
                return Optional.ofNullable(clazz.cast(this.alexaSkillStatusAsString()));
            }
            case "AlexaSkillIds": {
                return Optional.ofNullable(clazz.cast(this.alexaSkillIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SipMediaApplicationAlexaSkillConfiguration, T> g) {
        return obj -> g.apply((SipMediaApplicationAlexaSkillConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alexaSkillStatus;
        private List<String> alexaSkillIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SipMediaApplicationAlexaSkillConfiguration model) {
            this.alexaSkillStatus(model.alexaSkillStatus);
            this.alexaSkillIds(model.alexaSkillIds);
        }

        public final String getAlexaSkillStatus() {
            return this.alexaSkillStatus;
        }

        public final void setAlexaSkillStatus(String alexaSkillStatus) {
            this.alexaSkillStatus = alexaSkillStatus;
        }

        @Override
        public final Builder alexaSkillStatus(String alexaSkillStatus) {
            this.alexaSkillStatus = alexaSkillStatus;
            return this;
        }

        @Override
        public final Builder alexaSkillStatus(AlexaSkillStatus alexaSkillStatus) {
            this.alexaSkillStatus(alexaSkillStatus == null ? null : alexaSkillStatus.toString());
            return this;
        }

        public final Collection<String> getAlexaSkillIds() {
            if (this.alexaSkillIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.alexaSkillIds;
        }

        public final void setAlexaSkillIds(Collection<String> alexaSkillIds) {
            this.alexaSkillIds = AlexaSkillIdListCopier.copy(alexaSkillIds);
        }

        @Override
        public final Builder alexaSkillIds(Collection<String> alexaSkillIds) {
            this.alexaSkillIds = AlexaSkillIdListCopier.copy(alexaSkillIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alexaSkillIds(String ... alexaSkillIds) {
            this.alexaSkillIds(Arrays.asList(alexaSkillIds));
            return this;
        }

        public SipMediaApplicationAlexaSkillConfiguration build() {
            return new SipMediaApplicationAlexaSkillConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SipMediaApplicationAlexaSkillConfiguration> {
        public Builder alexaSkillStatus(String var1);

        public Builder alexaSkillStatus(AlexaSkillStatus var1);

        public Builder alexaSkillIds(Collection<String> var1);

        public Builder alexaSkillIds(String ... var1);
    }
}

