/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a call analytics task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaInsightsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaInsightsConfiguration.Builder, MediaInsightsConfiguration> {
    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Disabled").getter(getter(MediaInsightsConfiguration::disabled)).setter(setter(Builder::disabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()).build();

    private static final SdkField<String> CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationArn").getter(getter(MediaInsightsConfiguration::configurationArn))
            .setter(setter(Builder::configurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISABLED_FIELD,
            CONFIGURATION_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean disabled;

    private final String configurationArn;

    private MediaInsightsConfiguration(BuilderImpl builder) {
        this.disabled = builder.disabled;
        this.configurationArn = builder.configurationArn;
    }

    /**
     * <p>
     * Denotes the configuration as enabled or disabled.
     * </p>
     * 
     * @return Denotes the configuration as enabled or disabled.
     */
    public final Boolean disabled() {
        return disabled;
    }

    /**
     * <p>
     * The configuration's ARN.
     * </p>
     * 
     * @return The configuration's ARN.
     */
    public final String configurationArn() {
        return configurationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(disabled());
        hashCode = 31 * hashCode + Objects.hashCode(configurationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaInsightsConfiguration)) {
            return false;
        }
        MediaInsightsConfiguration other = (MediaInsightsConfiguration) obj;
        return Objects.equals(disabled(), other.disabled()) && Objects.equals(configurationArn(), other.configurationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaInsightsConfiguration").add("Disabled", disabled())
                .add("ConfigurationArn", configurationArn() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Disabled":
            return Optional.ofNullable(clazz.cast(disabled()));
        case "ConfigurationArn":
            return Optional.ofNullable(clazz.cast(configurationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MediaInsightsConfiguration, T> g) {
        return obj -> g.apply((MediaInsightsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaInsightsConfiguration> {
        /**
         * <p>
         * Denotes the configuration as enabled or disabled.
         * </p>
         * 
         * @param disabled
         *        Denotes the configuration as enabled or disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabled(Boolean disabled);

        /**
         * <p>
         * The configuration's ARN.
         * </p>
         * 
         * @param configurationArn
         *        The configuration's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationArn(String configurationArn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean disabled;

        private String configurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaInsightsConfiguration model) {
            disabled(model.disabled);
            configurationArn(model.configurationArn);
        }

        public final Boolean getDisabled() {
            return disabled;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public final String getConfigurationArn() {
            return configurationArn;
        }

        public final void setConfigurationArn(String configurationArn) {
            this.configurationArn = configurationArn;
        }

        @Override
        public final Builder configurationArn(String configurationArn) {
            this.configurationArn = configurationArn;
            return this;
        }

        @Override
        public MediaInsightsConfiguration build() {
            return new MediaInsightsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
