/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSipMediaApplicationCallRequest extends ChimeSdkVoiceRequest implements
        ToCopyableBuilder<UpdateSipMediaApplicationCallRequest.Builder, UpdateSipMediaApplicationCallRequest> {
    private static final SdkField<String> SIP_MEDIA_APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SipMediaApplicationId").getter(getter(UpdateSipMediaApplicationCallRequest::sipMediaApplicationId))
            .setter(setter(Builder::sipMediaApplicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sipMediaApplicationId").build())
            .build();

    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransactionId").getter(getter(UpdateSipMediaApplicationCallRequest::transactionId))
            .setter(setter(Builder::transactionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("transactionId").build()).build();

    private static final SdkField<Map<String, String>> ARGUMENTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Arguments")
            .getter(getter(UpdateSipMediaApplicationCallRequest::arguments))
            .setter(setter(Builder::arguments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arguments").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SIP_MEDIA_APPLICATION_ID_FIELD, TRANSACTION_ID_FIELD, ARGUMENTS_FIELD));

    private final String sipMediaApplicationId;

    private final String transactionId;

    private final Map<String, String> arguments;

    private UpdateSipMediaApplicationCallRequest(BuilderImpl builder) {
        super(builder);
        this.sipMediaApplicationId = builder.sipMediaApplicationId;
        this.transactionId = builder.transactionId;
        this.arguments = builder.arguments;
    }

    /**
     * <p>
     * The ID of the SIP media application handling the call.
     * </p>
     * 
     * @return The ID of the SIP media application handling the call.
     */
    public final String sipMediaApplicationId() {
        return sipMediaApplicationId;
    }

    /**
     * <p>
     * The ID of the call transaction.
     * </p>
     * 
     * @return The ID of the call transaction.
     */
    public final String transactionId() {
        return transactionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Arguments property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasArguments() {
        return arguments != null && !(arguments instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Arguments made available to the Lambda function as part of the <code>CALL_UPDATE_REQUESTED</code> event. Can
     * contain 0-20 key-value pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArguments} method.
     * </p>
     * 
     * @return Arguments made available to the Lambda function as part of the <code>CALL_UPDATE_REQUESTED</code> event.
     *         Can contain 0-20 key-value pairs.
     */
    public final Map<String, String> arguments() {
        return arguments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sipMediaApplicationId());
        hashCode = 31 * hashCode + Objects.hashCode(transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasArguments() ? arguments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSipMediaApplicationCallRequest)) {
            return false;
        }
        UpdateSipMediaApplicationCallRequest other = (UpdateSipMediaApplicationCallRequest) obj;
        return Objects.equals(sipMediaApplicationId(), other.sipMediaApplicationId())
                && Objects.equals(transactionId(), other.transactionId()) && hasArguments() == other.hasArguments()
                && Objects.equals(arguments(), other.arguments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSipMediaApplicationCallRequest").add("SipMediaApplicationId", sipMediaApplicationId())
                .add("TransactionId", transactionId())
                .add("Arguments", arguments() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SipMediaApplicationId":
            return Optional.ofNullable(clazz.cast(sipMediaApplicationId()));
        case "TransactionId":
            return Optional.ofNullable(clazz.cast(transactionId()));
        case "Arguments":
            return Optional.ofNullable(clazz.cast(arguments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSipMediaApplicationCallRequest, T> g) {
        return obj -> g.apply((UpdateSipMediaApplicationCallRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSipMediaApplicationCallRequest> {
        /**
         * <p>
         * The ID of the SIP media application handling the call.
         * </p>
         * 
         * @param sipMediaApplicationId
         *        The ID of the SIP media application handling the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sipMediaApplicationId(String sipMediaApplicationId);

        /**
         * <p>
         * The ID of the call transaction.
         * </p>
         * 
         * @param transactionId
         *        The ID of the call transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionId(String transactionId);

        /**
         * <p>
         * Arguments made available to the Lambda function as part of the <code>CALL_UPDATE_REQUESTED</code> event. Can
         * contain 0-20 key-value pairs.
         * </p>
         * 
         * @param arguments
         *        Arguments made available to the Lambda function as part of the <code>CALL_UPDATE_REQUESTED</code>
         *        event. Can contain 0-20 key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arguments(Map<String, String> arguments);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkVoiceRequest.BuilderImpl implements Builder {
        private String sipMediaApplicationId;

        private String transactionId;

        private Map<String, String> arguments = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSipMediaApplicationCallRequest model) {
            super(model);
            sipMediaApplicationId(model.sipMediaApplicationId);
            transactionId(model.transactionId);
            arguments(model.arguments);
        }

        public final String getSipMediaApplicationId() {
            return sipMediaApplicationId;
        }

        public final void setSipMediaApplicationId(String sipMediaApplicationId) {
            this.sipMediaApplicationId = sipMediaApplicationId;
        }

        @Override
        public final Builder sipMediaApplicationId(String sipMediaApplicationId) {
            this.sipMediaApplicationId = sipMediaApplicationId;
            return this;
        }

        public final String getTransactionId() {
            return transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final Map<String, String> getArguments() {
            if (arguments instanceof SdkAutoConstructMap) {
                return null;
            }
            return arguments;
        }

        public final void setArguments(Map<String, String> arguments) {
            this.arguments = SMAUpdateCallArgumentsMapCopier.copy(arguments);
        }

        @Override
        public final Builder arguments(Map<String, String> arguments) {
            this.arguments = SMAUpdateCallArgumentsMapCopier.copy(arguments);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSipMediaApplicationCallRequest build() {
            return new UpdateSipMediaApplicationCallRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
