/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociatePhoneNumbersWithVoiceConnectorGroupRequest extends ChimeSdkVoiceRequest
        implements
        ToCopyableBuilder<AssociatePhoneNumbersWithVoiceConnectorGroupRequest.Builder, AssociatePhoneNumbersWithVoiceConnectorGroupRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceConnectorGroupId")
            .getter(getter(AssociatePhoneNumbersWithVoiceConnectorGroupRequest::voiceConnectorGroupId))
            .setter(setter(Builder::voiceConnectorGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("voiceConnectorGroupId").build())
            .build();

    private static final SdkField<List<String>> E164_PHONE_NUMBERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("E164PhoneNumbers")
            .getter(getter(AssociatePhoneNumbersWithVoiceConnectorGroupRequest::e164PhoneNumbers))
            .setter(setter(Builder::e164PhoneNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("E164PhoneNumbers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> FORCE_ASSOCIATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ForceAssociate").getter(getter(AssociatePhoneNumbersWithVoiceConnectorGroupRequest::forceAssociate))
            .setter(setter(Builder::forceAssociate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceAssociate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VOICE_CONNECTOR_GROUP_ID_FIELD, E164_PHONE_NUMBERS_FIELD, FORCE_ASSOCIATE_FIELD));

    private final String voiceConnectorGroupId;

    private final List<String> e164PhoneNumbers;

    private final Boolean forceAssociate;

    private AssociatePhoneNumbersWithVoiceConnectorGroupRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorGroupId = builder.voiceConnectorGroupId;
        this.e164PhoneNumbers = builder.e164PhoneNumbers;
        this.forceAssociate = builder.forceAssociate;
    }

    /**
     * <p>
     * The Amazon Chime SDK Voice Connector group ID.
     * </p>
     * 
     * @return The Amazon Chime SDK Voice Connector group ID.
     */
    public final String voiceConnectorGroupId() {
        return voiceConnectorGroupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the E164PhoneNumbers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasE164PhoneNumbers() {
        return e164PhoneNumbers != null && !(e164PhoneNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of phone numbers, in E.164 format.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasE164PhoneNumbers} method.
     * </p>
     * 
     * @return List of phone numbers, in E.164 format.
     */
    public final List<String> e164PhoneNumbers() {
        return e164PhoneNumbers;
    }

    /**
     * <p>
     * If true, associates the provided phone numbers with the provided Amazon Chime SDK Voice Connector Group and
     * removes any previously existing associations. If false, does not associate any phone numbers that have previously
     * existing associations.
     * </p>
     * 
     * @return If true, associates the provided phone numbers with the provided Amazon Chime SDK Voice Connector Group
     *         and removes any previously existing associations. If false, does not associate any phone numbers that
     *         have previously existing associations.
     */
    public final Boolean forceAssociate() {
        return forceAssociate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(voiceConnectorGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasE164PhoneNumbers() ? e164PhoneNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(forceAssociate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatePhoneNumbersWithVoiceConnectorGroupRequest)) {
            return false;
        }
        AssociatePhoneNumbersWithVoiceConnectorGroupRequest other = (AssociatePhoneNumbersWithVoiceConnectorGroupRequest) obj;
        return Objects.equals(voiceConnectorGroupId(), other.voiceConnectorGroupId())
                && hasE164PhoneNumbers() == other.hasE164PhoneNumbers()
                && Objects.equals(e164PhoneNumbers(), other.e164PhoneNumbers())
                && Objects.equals(forceAssociate(), other.forceAssociate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociatePhoneNumbersWithVoiceConnectorGroupRequest")
                .add("VoiceConnectorGroupId", voiceConnectorGroupId())
                .add("E164PhoneNumbers", e164PhoneNumbers() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ForceAssociate", forceAssociate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceConnectorGroupId":
            return Optional.ofNullable(clazz.cast(voiceConnectorGroupId()));
        case "E164PhoneNumbers":
            return Optional.ofNullable(clazz.cast(e164PhoneNumbers()));
        case "ForceAssociate":
            return Optional.ofNullable(clazz.cast(forceAssociate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociatePhoneNumbersWithVoiceConnectorGroupRequest, T> g) {
        return obj -> g.apply((AssociatePhoneNumbersWithVoiceConnectorGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociatePhoneNumbersWithVoiceConnectorGroupRequest> {
        /**
         * <p>
         * The Amazon Chime SDK Voice Connector group ID.
         * </p>
         * 
         * @param voiceConnectorGroupId
         *        The Amazon Chime SDK Voice Connector group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorGroupId(String voiceConnectorGroupId);

        /**
         * <p>
         * List of phone numbers, in E.164 format.
         * </p>
         * 
         * @param e164PhoneNumbers
         *        List of phone numbers, in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder e164PhoneNumbers(Collection<String> e164PhoneNumbers);

        /**
         * <p>
         * List of phone numbers, in E.164 format.
         * </p>
         * 
         * @param e164PhoneNumbers
         *        List of phone numbers, in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder e164PhoneNumbers(String... e164PhoneNumbers);

        /**
         * <p>
         * If true, associates the provided phone numbers with the provided Amazon Chime SDK Voice Connector Group and
         * removes any previously existing associations. If false, does not associate any phone numbers that have
         * previously existing associations.
         * </p>
         * 
         * @param forceAssociate
         *        If true, associates the provided phone numbers with the provided Amazon Chime SDK Voice Connector
         *        Group and removes any previously existing associations. If false, does not associate any phone numbers
         *        that have previously existing associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceAssociate(Boolean forceAssociate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkVoiceRequest.BuilderImpl implements Builder {
        private String voiceConnectorGroupId;

        private List<String> e164PhoneNumbers = DefaultSdkAutoConstructList.getInstance();

        private Boolean forceAssociate;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatePhoneNumbersWithVoiceConnectorGroupRequest model) {
            super(model);
            voiceConnectorGroupId(model.voiceConnectorGroupId);
            e164PhoneNumbers(model.e164PhoneNumbers);
            forceAssociate(model.forceAssociate);
        }

        public final String getVoiceConnectorGroupId() {
            return voiceConnectorGroupId;
        }

        public final void setVoiceConnectorGroupId(String voiceConnectorGroupId) {
            this.voiceConnectorGroupId = voiceConnectorGroupId;
        }

        @Override
        public final Builder voiceConnectorGroupId(String voiceConnectorGroupId) {
            this.voiceConnectorGroupId = voiceConnectorGroupId;
            return this;
        }

        public final Collection<String> getE164PhoneNumbers() {
            if (e164PhoneNumbers instanceof SdkAutoConstructList) {
                return null;
            }
            return e164PhoneNumbers;
        }

        public final void setE164PhoneNumbers(Collection<String> e164PhoneNumbers) {
            this.e164PhoneNumbers = E164PhoneNumberListCopier.copy(e164PhoneNumbers);
        }

        @Override
        public final Builder e164PhoneNumbers(Collection<String> e164PhoneNumbers) {
            this.e164PhoneNumbers = E164PhoneNumberListCopier.copy(e164PhoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder e164PhoneNumbers(String... e164PhoneNumbers) {
            e164PhoneNumbers(Arrays.asList(e164PhoneNumbers));
            return this;
        }

        public final Boolean getForceAssociate() {
            return forceAssociate;
        }

        public final void setForceAssociate(Boolean forceAssociate) {
            this.forceAssociate = forceAssociate;
        }

        @Override
        public final Builder forceAssociate(Boolean forceAssociate) {
            this.forceAssociate = forceAssociate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociatePhoneNumbersWithVoiceConnectorGroupRequest build() {
            return new AssociatePhoneNumbersWithVoiceConnectorGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
