/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVoiceProfileResponse extends ChimeSdkVoiceResponse implements
        ToCopyableBuilder<CreateVoiceProfileResponse.Builder, CreateVoiceProfileResponse> {
    private static final SdkField<VoiceProfile> VOICE_PROFILE_FIELD = SdkField.<VoiceProfile> builder(MarshallingType.SDK_POJO)
            .memberName("VoiceProfile").getter(getter(CreateVoiceProfileResponse::voiceProfile))
            .setter(setter(Builder::voiceProfile)).constructor(VoiceProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceProfile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_PROFILE_FIELD));

    private final VoiceProfile voiceProfile;

    private CreateVoiceProfileResponse(BuilderImpl builder) {
        super(builder);
        this.voiceProfile = builder.voiceProfile;
    }

    /**
     * <p>
     * The requested voice profile.
     * </p>
     * 
     * @return The requested voice profile.
     */
    public final VoiceProfile voiceProfile() {
        return voiceProfile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(voiceProfile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVoiceProfileResponse)) {
            return false;
        }
        CreateVoiceProfileResponse other = (CreateVoiceProfileResponse) obj;
        return Objects.equals(voiceProfile(), other.voiceProfile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVoiceProfileResponse").add("VoiceProfile", voiceProfile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceProfile":
            return Optional.ofNullable(clazz.cast(voiceProfile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVoiceProfileResponse, T> g) {
        return obj -> g.apply((CreateVoiceProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateVoiceProfileResponse> {
        /**
         * <p>
         * The requested voice profile.
         * </p>
         * 
         * @param voiceProfile
         *        The requested voice profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceProfile(VoiceProfile voiceProfile);

        /**
         * <p>
         * The requested voice profile.
         * </p>
         * This is a convenience method that creates an instance of the {@link VoiceProfile.Builder} avoiding the need
         * to create one manually via {@link VoiceProfile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VoiceProfile.Builder#build()} is called immediately and its
         * result is passed to {@link #voiceProfile(VoiceProfile)}.
         * 
         * @param voiceProfile
         *        a consumer that will call methods on {@link VoiceProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceProfile(VoiceProfile)
         */
        default Builder voiceProfile(Consumer<VoiceProfile.Builder> voiceProfile) {
            return voiceProfile(VoiceProfile.builder().applyMutation(voiceProfile).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkVoiceResponse.BuilderImpl implements Builder {
        private VoiceProfile voiceProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVoiceProfileResponse model) {
            super(model);
            voiceProfile(model.voiceProfile);
        }

        public final VoiceProfile.Builder getVoiceProfile() {
            return voiceProfile != null ? voiceProfile.toBuilder() : null;
        }

        public final void setVoiceProfile(VoiceProfile.BuilderImpl voiceProfile) {
            this.voiceProfile = voiceProfile != null ? voiceProfile.build() : null;
        }

        @Override
        public final Builder voiceProfile(VoiceProfile voiceProfile) {
            this.voiceProfile = voiceProfile;
            return this;
        }

        @Override
        public CreateVoiceProfileResponse build() {
            return new CreateVoiceProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
