/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVoiceToneAnalysisTaskRequest extends ChimeSdkVoiceRequest implements
        ToCopyableBuilder<GetVoiceToneAnalysisTaskRequest.Builder, GetVoiceToneAnalysisTaskRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceConnectorId").getter(getter(GetVoiceToneAnalysisTaskRequest::voiceConnectorId))
            .setter(setter(Builder::voiceConnectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("VoiceConnectorId").build()).build();

    private static final SdkField<String> VOICE_TONE_ANALYSIS_TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceToneAnalysisTaskId").getter(getter(GetVoiceToneAnalysisTaskRequest::voiceToneAnalysisTaskId))
            .setter(setter(Builder::voiceToneAnalysisTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("VoiceToneAnalysisTaskId").build())
            .build();

    private static final SdkField<Boolean> IS_CALLER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsCaller").getter(getter(GetVoiceToneAnalysisTaskRequest::isCaller)).setter(setter(Builder::isCaller))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("isCaller").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD,
            VOICE_TONE_ANALYSIS_TASK_ID_FIELD, IS_CALLER_FIELD));

    private final String voiceConnectorId;

    private final String voiceToneAnalysisTaskId;

    private final Boolean isCaller;

    private GetVoiceToneAnalysisTaskRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorId = builder.voiceConnectorId;
        this.voiceToneAnalysisTaskId = builder.voiceToneAnalysisTaskId;
        this.isCaller = builder.isCaller;
    }

    /**
     * <p>
     * The Voice Connector ID.
     * </p>
     * 
     * @return The Voice Connector ID.
     */
    public final String voiceConnectorId() {
        return voiceConnectorId;
    }

    /**
     * <p>
     * The ID of the voice tone analysis task.
     * </p>
     * 
     * @return The ID of the voice tone analysis task.
     */
    public final String voiceToneAnalysisTaskId() {
        return voiceToneAnalysisTaskId;
    }

    /**
     * <p>
     * Specifies whether the voice being analyzed is the caller (originator) or the callee (responder).
     * </p>
     * 
     * @return Specifies whether the voice being analyzed is the caller (originator) or the callee (responder).
     */
    public final Boolean isCaller() {
        return isCaller;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(voiceToneAnalysisTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(isCaller());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVoiceToneAnalysisTaskRequest)) {
            return false;
        }
        GetVoiceToneAnalysisTaskRequest other = (GetVoiceToneAnalysisTaskRequest) obj;
        return Objects.equals(voiceConnectorId(), other.voiceConnectorId())
                && Objects.equals(voiceToneAnalysisTaskId(), other.voiceToneAnalysisTaskId())
                && Objects.equals(isCaller(), other.isCaller());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetVoiceToneAnalysisTaskRequest").add("VoiceConnectorId", voiceConnectorId())
                .add("VoiceToneAnalysisTaskId", voiceToneAnalysisTaskId()).add("IsCaller", isCaller()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceConnectorId":
            return Optional.ofNullable(clazz.cast(voiceConnectorId()));
        case "VoiceToneAnalysisTaskId":
            return Optional.ofNullable(clazz.cast(voiceToneAnalysisTaskId()));
        case "IsCaller":
            return Optional.ofNullable(clazz.cast(isCaller()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetVoiceToneAnalysisTaskRequest, T> g) {
        return obj -> g.apply((GetVoiceToneAnalysisTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetVoiceToneAnalysisTaskRequest> {
        /**
         * <p>
         * The Voice Connector ID.
         * </p>
         * 
         * @param voiceConnectorId
         *        The Voice Connector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorId(String voiceConnectorId);

        /**
         * <p>
         * The ID of the voice tone analysis task.
         * </p>
         * 
         * @param voiceToneAnalysisTaskId
         *        The ID of the voice tone analysis task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceToneAnalysisTaskId(String voiceToneAnalysisTaskId);

        /**
         * <p>
         * Specifies whether the voice being analyzed is the caller (originator) or the callee (responder).
         * </p>
         * 
         * @param isCaller
         *        Specifies whether the voice being analyzed is the caller (originator) or the callee (responder).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isCaller(Boolean isCaller);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkVoiceRequest.BuilderImpl implements Builder {
        private String voiceConnectorId;

        private String voiceToneAnalysisTaskId;

        private Boolean isCaller;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVoiceToneAnalysisTaskRequest model) {
            super(model);
            voiceConnectorId(model.voiceConnectorId);
            voiceToneAnalysisTaskId(model.voiceToneAnalysisTaskId);
            isCaller(model.isCaller);
        }

        public final String getVoiceConnectorId() {
            return voiceConnectorId;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final String getVoiceToneAnalysisTaskId() {
            return voiceToneAnalysisTaskId;
        }

        public final void setVoiceToneAnalysisTaskId(String voiceToneAnalysisTaskId) {
            this.voiceToneAnalysisTaskId = voiceToneAnalysisTaskId;
        }

        @Override
        public final Builder voiceToneAnalysisTaskId(String voiceToneAnalysisTaskId) {
            this.voiceToneAnalysisTaskId = voiceToneAnalysisTaskId;
            return this;
        }

        public final Boolean getIsCaller() {
            return isCaller;
        }

        public final void setIsCaller(Boolean isCaller) {
            this.isCaller = isCaller;
        }

        @Override
        public final Builder isCaller(Boolean isCaller) {
            this.isCaller = isCaller;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetVoiceToneAnalysisTaskRequest build() {
            return new GetVoiceToneAnalysisTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
