/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The phone number capabilities for Amazon Chime SDK phone numbers, such as enabled inbound and outbound calling, and
 * text messaging.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PhoneNumberCapabilities implements SdkPojo, Serializable,
        ToCopyableBuilder<PhoneNumberCapabilities.Builder, PhoneNumberCapabilities> {
    private static final SdkField<Boolean> INBOUND_CALL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("InboundCall").getter(getter(PhoneNumberCapabilities::inboundCall)).setter(setter(Builder::inboundCall))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundCall").build()).build();

    private static final SdkField<Boolean> OUTBOUND_CALL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OutboundCall").getter(getter(PhoneNumberCapabilities::outboundCall))
            .setter(setter(Builder::outboundCall))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundCall").build()).build();

    private static final SdkField<Boolean> INBOUND_SMS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("InboundSMS").getter(getter(PhoneNumberCapabilities::inboundSMS)).setter(setter(Builder::inboundSMS))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundSMS").build()).build();

    private static final SdkField<Boolean> OUTBOUND_SMS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OutboundSMS").getter(getter(PhoneNumberCapabilities::outboundSMS)).setter(setter(Builder::outboundSMS))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundSMS").build()).build();

    private static final SdkField<Boolean> INBOUND_MMS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("InboundMMS").getter(getter(PhoneNumberCapabilities::inboundMMS)).setter(setter(Builder::inboundMMS))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundMMS").build()).build();

    private static final SdkField<Boolean> OUTBOUND_MMS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OutboundMMS").getter(getter(PhoneNumberCapabilities::outboundMMS)).setter(setter(Builder::outboundMMS))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundMMS").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INBOUND_CALL_FIELD,
            OUTBOUND_CALL_FIELD, INBOUND_SMS_FIELD, OUTBOUND_SMS_FIELD, INBOUND_MMS_FIELD, OUTBOUND_MMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean inboundCall;

    private final Boolean outboundCall;

    private final Boolean inboundSMS;

    private final Boolean outboundSMS;

    private final Boolean inboundMMS;

    private final Boolean outboundMMS;

    private PhoneNumberCapabilities(BuilderImpl builder) {
        this.inboundCall = builder.inboundCall;
        this.outboundCall = builder.outboundCall;
        this.inboundSMS = builder.inboundSMS;
        this.outboundSMS = builder.outboundSMS;
        this.inboundMMS = builder.inboundMMS;
        this.outboundMMS = builder.outboundMMS;
    }

    /**
     * <p>
     * Allows or denies inbound calling for the specified phone number.
     * </p>
     * 
     * @return Allows or denies inbound calling for the specified phone number.
     */
    public final Boolean inboundCall() {
        return inboundCall;
    }

    /**
     * <p>
     * Allows or denies outbound calling for the specified phone number.
     * </p>
     * 
     * @return Allows or denies outbound calling for the specified phone number.
     */
    public final Boolean outboundCall() {
        return outboundCall;
    }

    /**
     * <p>
     * Allows or denies inbound SMS messaging for the specified phone number.
     * </p>
     * 
     * @return Allows or denies inbound SMS messaging for the specified phone number.
     */
    public final Boolean inboundSMS() {
        return inboundSMS;
    }

    /**
     * <p>
     * Allows or denies outbound SMS messaging for the specified phone number.
     * </p>
     * 
     * @return Allows or denies outbound SMS messaging for the specified phone number.
     */
    public final Boolean outboundSMS() {
        return outboundSMS;
    }

    /**
     * <p>
     * Allows or denies inbound MMS messaging for the specified phone number.
     * </p>
     * 
     * @return Allows or denies inbound MMS messaging for the specified phone number.
     */
    public final Boolean inboundMMS() {
        return inboundMMS;
    }

    /**
     * <p>
     * Allows or denies inbound MMS messaging for the specified phone number.
     * </p>
     * 
     * @return Allows or denies inbound MMS messaging for the specified phone number.
     */
    public final Boolean outboundMMS() {
        return outboundMMS;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inboundCall());
        hashCode = 31 * hashCode + Objects.hashCode(outboundCall());
        hashCode = 31 * hashCode + Objects.hashCode(inboundSMS());
        hashCode = 31 * hashCode + Objects.hashCode(outboundSMS());
        hashCode = 31 * hashCode + Objects.hashCode(inboundMMS());
        hashCode = 31 * hashCode + Objects.hashCode(outboundMMS());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoneNumberCapabilities)) {
            return false;
        }
        PhoneNumberCapabilities other = (PhoneNumberCapabilities) obj;
        return Objects.equals(inboundCall(), other.inboundCall()) && Objects.equals(outboundCall(), other.outboundCall())
                && Objects.equals(inboundSMS(), other.inboundSMS()) && Objects.equals(outboundSMS(), other.outboundSMS())
                && Objects.equals(inboundMMS(), other.inboundMMS()) && Objects.equals(outboundMMS(), other.outboundMMS());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PhoneNumberCapabilities").add("InboundCall", inboundCall()).add("OutboundCall", outboundCall())
                .add("InboundSMS", inboundSMS()).add("OutboundSMS", outboundSMS()).add("InboundMMS", inboundMMS())
                .add("OutboundMMS", outboundMMS()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InboundCall":
            return Optional.ofNullable(clazz.cast(inboundCall()));
        case "OutboundCall":
            return Optional.ofNullable(clazz.cast(outboundCall()));
        case "InboundSMS":
            return Optional.ofNullable(clazz.cast(inboundSMS()));
        case "OutboundSMS":
            return Optional.ofNullable(clazz.cast(outboundSMS()));
        case "InboundMMS":
            return Optional.ofNullable(clazz.cast(inboundMMS()));
        case "OutboundMMS":
            return Optional.ofNullable(clazz.cast(outboundMMS()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PhoneNumberCapabilities, T> g) {
        return obj -> g.apply((PhoneNumberCapabilities) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PhoneNumberCapabilities> {
        /**
         * <p>
         * Allows or denies inbound calling for the specified phone number.
         * </p>
         * 
         * @param inboundCall
         *        Allows or denies inbound calling for the specified phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundCall(Boolean inboundCall);

        /**
         * <p>
         * Allows or denies outbound calling for the specified phone number.
         * </p>
         * 
         * @param outboundCall
         *        Allows or denies outbound calling for the specified phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundCall(Boolean outboundCall);

        /**
         * <p>
         * Allows or denies inbound SMS messaging for the specified phone number.
         * </p>
         * 
         * @param inboundSMS
         *        Allows or denies inbound SMS messaging for the specified phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundSMS(Boolean inboundSMS);

        /**
         * <p>
         * Allows or denies outbound SMS messaging for the specified phone number.
         * </p>
         * 
         * @param outboundSMS
         *        Allows or denies outbound SMS messaging for the specified phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundSMS(Boolean outboundSMS);

        /**
         * <p>
         * Allows or denies inbound MMS messaging for the specified phone number.
         * </p>
         * 
         * @param inboundMMS
         *        Allows or denies inbound MMS messaging for the specified phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundMMS(Boolean inboundMMS);

        /**
         * <p>
         * Allows or denies inbound MMS messaging for the specified phone number.
         * </p>
         * 
         * @param outboundMMS
         *        Allows or denies inbound MMS messaging for the specified phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundMMS(Boolean outboundMMS);
    }

    static final class BuilderImpl implements Builder {
        private Boolean inboundCall;

        private Boolean outboundCall;

        private Boolean inboundSMS;

        private Boolean outboundSMS;

        private Boolean inboundMMS;

        private Boolean outboundMMS;

        private BuilderImpl() {
        }

        private BuilderImpl(PhoneNumberCapabilities model) {
            inboundCall(model.inboundCall);
            outboundCall(model.outboundCall);
            inboundSMS(model.inboundSMS);
            outboundSMS(model.outboundSMS);
            inboundMMS(model.inboundMMS);
            outboundMMS(model.outboundMMS);
        }

        public final Boolean getInboundCall() {
            return inboundCall;
        }

        public final void setInboundCall(Boolean inboundCall) {
            this.inboundCall = inboundCall;
        }

        @Override
        public final Builder inboundCall(Boolean inboundCall) {
            this.inboundCall = inboundCall;
            return this;
        }

        public final Boolean getOutboundCall() {
            return outboundCall;
        }

        public final void setOutboundCall(Boolean outboundCall) {
            this.outboundCall = outboundCall;
        }

        @Override
        public final Builder outboundCall(Boolean outboundCall) {
            this.outboundCall = outboundCall;
            return this;
        }

        public final Boolean getInboundSMS() {
            return inboundSMS;
        }

        public final void setInboundSMS(Boolean inboundSMS) {
            this.inboundSMS = inboundSMS;
        }

        @Override
        public final Builder inboundSMS(Boolean inboundSMS) {
            this.inboundSMS = inboundSMS;
            return this;
        }

        public final Boolean getOutboundSMS() {
            return outboundSMS;
        }

        public final void setOutboundSMS(Boolean outboundSMS) {
            this.outboundSMS = outboundSMS;
        }

        @Override
        public final Builder outboundSMS(Boolean outboundSMS) {
            this.outboundSMS = outboundSMS;
            return this;
        }

        public final Boolean getInboundMMS() {
            return inboundMMS;
        }

        public final void setInboundMMS(Boolean inboundMMS) {
            this.inboundMMS = inboundMMS;
        }

        @Override
        public final Builder inboundMMS(Boolean inboundMMS) {
            this.inboundMMS = inboundMMS;
            return this;
        }

        public final Boolean getOutboundMMS() {
            return outboundMMS;
        }

        public final void setOutboundMMS(Boolean outboundMMS) {
            this.outboundMMS = outboundMMS;
        }

        @Override
        public final Builder outboundMMS(Boolean outboundMMS) {
            this.outboundMMS = outboundMMS;
            return this;
        }

        @Override
        public PhoneNumberCapabilities build() {
            return new PhoneNumberCapabilities(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
