/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a speaker search task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpeakerSearchDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<SpeakerSearchDetails.Builder, SpeakerSearchDetails> {
    private static final SdkField<List<SpeakerSearchResult>> RESULTS_FIELD = SdkField
            .<List<SpeakerSearchResult>> builder(MarshallingType.LIST)
            .memberName("Results")
            .getter(getter(SpeakerSearchDetails::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SpeakerSearchResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(SpeakerSearchResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VOICEPRINT_GENERATION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VoiceprintGenerationStatus")
            .getter(getter(SpeakerSearchDetails::voiceprintGenerationStatus))
            .setter(setter(Builder::voiceprintGenerationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceprintGenerationStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD,
            VOICEPRINT_GENERATION_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<SpeakerSearchResult> results;

    private final String voiceprintGenerationStatus;

    private SpeakerSearchDetails(BuilderImpl builder) {
        this.results = builder.results;
        this.voiceprintGenerationStatus = builder.voiceprintGenerationStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Results property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResults() {
        return results != null && !(results instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The result value in the speaker search details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResults} method.
     * </p>
     * 
     * @return The result value in the speaker search details.
     */
    public final List<SpeakerSearchResult> results() {
        return results;
    }

    /**
     * <p>
     * The status of a voice print generation operation, <code>VoiceprintGenerationSuccess</code> or
     * <code>VoiceprintGenerationFailure</code>..
     * </p>
     * 
     * @return The status of a voice print generation operation, <code>VoiceprintGenerationSuccess</code> or
     *         <code>VoiceprintGenerationFailure</code>..
     */
    public final String voiceprintGenerationStatus() {
        return voiceprintGenerationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasResults() ? results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(voiceprintGenerationStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpeakerSearchDetails)) {
            return false;
        }
        SpeakerSearchDetails other = (SpeakerSearchDetails) obj;
        return hasResults() == other.hasResults() && Objects.equals(results(), other.results())
                && Objects.equals(voiceprintGenerationStatus(), other.voiceprintGenerationStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpeakerSearchDetails").add("Results", hasResults() ? results() : null)
                .add("VoiceprintGenerationStatus", voiceprintGenerationStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Results":
            return Optional.ofNullable(clazz.cast(results()));
        case "VoiceprintGenerationStatus":
            return Optional.ofNullable(clazz.cast(voiceprintGenerationStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpeakerSearchDetails, T> g) {
        return obj -> g.apply((SpeakerSearchDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpeakerSearchDetails> {
        /**
         * <p>
         * The result value in the speaker search details.
         * </p>
         * 
         * @param results
         *        The result value in the speaker search details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<SpeakerSearchResult> results);

        /**
         * <p>
         * The result value in the speaker search details.
         * </p>
         * 
         * @param results
         *        The result value in the speaker search details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(SpeakerSearchResult... results);

        /**
         * <p>
         * The result value in the speaker search details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.SpeakerSearchResult.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.SpeakerSearchResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.SpeakerSearchResult.Builder#build()} is called
         * immediately and its result is passed to {@link #results(List<SpeakerSearchResult>)}.
         * 
         * @param results
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkvoice.model.SpeakerSearchResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #results(java.util.Collection<SpeakerSearchResult>)
         */
        Builder results(Consumer<SpeakerSearchResult.Builder>... results);

        /**
         * <p>
         * The status of a voice print generation operation, <code>VoiceprintGenerationSuccess</code> or
         * <code>VoiceprintGenerationFailure</code>..
         * </p>
         * 
         * @param voiceprintGenerationStatus
         *        The status of a voice print generation operation, <code>VoiceprintGenerationSuccess</code> or
         *        <code>VoiceprintGenerationFailure</code>..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceprintGenerationStatus(String voiceprintGenerationStatus);
    }

    static final class BuilderImpl implements Builder {
        private List<SpeakerSearchResult> results = DefaultSdkAutoConstructList.getInstance();

        private String voiceprintGenerationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(SpeakerSearchDetails model) {
            results(model.results);
            voiceprintGenerationStatus(model.voiceprintGenerationStatus);
        }

        public final List<SpeakerSearchResult.Builder> getResults() {
            List<SpeakerSearchResult.Builder> result = SpeakerSearchResultListCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<SpeakerSearchResult.BuilderImpl> results) {
            this.results = SpeakerSearchResultListCopier.copyFromBuilder(results);
        }

        @Override
        public final Builder results(Collection<SpeakerSearchResult> results) {
            this.results = SpeakerSearchResultListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(SpeakerSearchResult... results) {
            results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<SpeakerSearchResult.Builder>... results) {
            results(Stream.of(results).map(c -> SpeakerSearchResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getVoiceprintGenerationStatus() {
            return voiceprintGenerationStatus;
        }

        public final void setVoiceprintGenerationStatus(String voiceprintGenerationStatus) {
            this.voiceprintGenerationStatus = voiceprintGenerationStatus;
        }

        @Override
        public final Builder voiceprintGenerationStatus(String voiceprintGenerationStatus) {
            this.voiceprintGenerationStatus = voiceprintGenerationStatus;
            return this;
        }

        @Override
        public SpeakerSearchDetails build() {
            return new SpeakerSearchDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
