/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkvoice.model.ChimeSdkVoiceRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.E164PhoneNumberListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociatePhoneNumbersWithVoiceConnectorGroupRequest
extends ChimeSdkVoiceRequest
implements ToCopyableBuilder<Builder, AssociatePhoneNumbersWithVoiceConnectorGroupRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceConnectorGroupId").getter(AssociatePhoneNumbersWithVoiceConnectorGroupRequest.getter(AssociatePhoneNumbersWithVoiceConnectorGroupRequest::voiceConnectorGroupId)).setter(AssociatePhoneNumbersWithVoiceConnectorGroupRequest.setter(Builder::voiceConnectorGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("voiceConnectorGroupId").build()}).build();
    private static final SdkField<List<String>> E164_PHONE_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("E164PhoneNumbers").getter(AssociatePhoneNumbersWithVoiceConnectorGroupRequest.getter(AssociatePhoneNumbersWithVoiceConnectorGroupRequest::e164PhoneNumbers)).setter(AssociatePhoneNumbersWithVoiceConnectorGroupRequest.setter(Builder::e164PhoneNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("E164PhoneNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> FORCE_ASSOCIATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ForceAssociate").getter(AssociatePhoneNumbersWithVoiceConnectorGroupRequest.getter(AssociatePhoneNumbersWithVoiceConnectorGroupRequest::forceAssociate)).setter(AssociatePhoneNumbersWithVoiceConnectorGroupRequest.setter(Builder::forceAssociate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceAssociate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_GROUP_ID_FIELD, E164_PHONE_NUMBERS_FIELD, FORCE_ASSOCIATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("voiceConnectorGroupId", VOICE_CONNECTOR_GROUP_ID_FIELD);
            this.put("E164PhoneNumbers", E164_PHONE_NUMBERS_FIELD);
            this.put("ForceAssociate", FORCE_ASSOCIATE_FIELD);
        }
    });
    private final String voiceConnectorGroupId;
    private final List<String> e164PhoneNumbers;
    private final Boolean forceAssociate;

    private AssociatePhoneNumbersWithVoiceConnectorGroupRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorGroupId = builder.voiceConnectorGroupId;
        this.e164PhoneNumbers = builder.e164PhoneNumbers;
        this.forceAssociate = builder.forceAssociate;
    }

    public final String voiceConnectorGroupId() {
        return this.voiceConnectorGroupId;
    }

    public final boolean hasE164PhoneNumbers() {
        return this.e164PhoneNumbers != null && !(this.e164PhoneNumbers instanceof SdkAutoConstructList);
    }

    public final List<String> e164PhoneNumbers() {
        return this.e164PhoneNumbers;
    }

    public final Boolean forceAssociate() {
        return this.forceAssociate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceConnectorGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasE164PhoneNumbers() ? this.e164PhoneNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.forceAssociate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatePhoneNumbersWithVoiceConnectorGroupRequest)) {
            return false;
        }
        AssociatePhoneNumbersWithVoiceConnectorGroupRequest other = (AssociatePhoneNumbersWithVoiceConnectorGroupRequest)((Object)obj);
        return Objects.equals(this.voiceConnectorGroupId(), other.voiceConnectorGroupId()) && this.hasE164PhoneNumbers() == other.hasE164PhoneNumbers() && Objects.equals(this.e164PhoneNumbers(), other.e164PhoneNumbers()) && Objects.equals(this.forceAssociate(), other.forceAssociate());
    }

    public final String toString() {
        return ToString.builder((String)"AssociatePhoneNumbersWithVoiceConnectorGroupRequest").add("VoiceConnectorGroupId", (Object)this.voiceConnectorGroupId()).add("E164PhoneNumbers", (Object)(this.e164PhoneNumbers() == null ? null : "*** Sensitive Data Redacted ***")).add("ForceAssociate", (Object)this.forceAssociate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VoiceConnectorGroupId": {
                return Optional.ofNullable(clazz.cast(this.voiceConnectorGroupId()));
            }
            case "E164PhoneNumbers": {
                return Optional.ofNullable(clazz.cast(this.e164PhoneNumbers()));
            }
            case "ForceAssociate": {
                return Optional.ofNullable(clazz.cast(this.forceAssociate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssociatePhoneNumbersWithVoiceConnectorGroupRequest, T> g) {
        return obj -> g.apply((AssociatePhoneNumbersWithVoiceConnectorGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkVoiceRequest.BuilderImpl
    implements Builder {
        private String voiceConnectorGroupId;
        private List<String> e164PhoneNumbers = DefaultSdkAutoConstructList.getInstance();
        private Boolean forceAssociate;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatePhoneNumbersWithVoiceConnectorGroupRequest model) {
            super(model);
            this.voiceConnectorGroupId(model.voiceConnectorGroupId);
            this.e164PhoneNumbers(model.e164PhoneNumbers);
            this.forceAssociate(model.forceAssociate);
        }

        public final String getVoiceConnectorGroupId() {
            return this.voiceConnectorGroupId;
        }

        public final void setVoiceConnectorGroupId(String voiceConnectorGroupId) {
            this.voiceConnectorGroupId = voiceConnectorGroupId;
        }

        @Override
        public final Builder voiceConnectorGroupId(String voiceConnectorGroupId) {
            this.voiceConnectorGroupId = voiceConnectorGroupId;
            return this;
        }

        public final Collection<String> getE164PhoneNumbers() {
            if (this.e164PhoneNumbers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.e164PhoneNumbers;
        }

        public final void setE164PhoneNumbers(Collection<String> e164PhoneNumbers) {
            this.e164PhoneNumbers = E164PhoneNumberListCopier.copy(e164PhoneNumbers);
        }

        @Override
        public final Builder e164PhoneNumbers(Collection<String> e164PhoneNumbers) {
            this.e164PhoneNumbers = E164PhoneNumberListCopier.copy(e164PhoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder e164PhoneNumbers(String ... e164PhoneNumbers) {
            this.e164PhoneNumbers(Arrays.asList(e164PhoneNumbers));
            return this;
        }

        public final Boolean getForceAssociate() {
            return this.forceAssociate;
        }

        public final void setForceAssociate(Boolean forceAssociate) {
            this.forceAssociate = forceAssociate;
        }

        @Override
        public final Builder forceAssociate(Boolean forceAssociate) {
            this.forceAssociate = forceAssociate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociatePhoneNumbersWithVoiceConnectorGroupRequest build() {
            return new AssociatePhoneNumbersWithVoiceConnectorGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkVoiceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociatePhoneNumbersWithVoiceConnectorGroupRequest> {
        public Builder voiceConnectorGroupId(String var1);

        public Builder e164PhoneNumbers(Collection<String> var1);

        public Builder e164PhoneNumbers(String ... var1);

        public Builder forceAssociate(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

