/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkvoice.model.ChimeSdkVoiceRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ContactCenterSystemType;
import software.amazon.awssdk.services.chimesdkvoice.model.ContactCenterSystemTypeListCopier;
import software.amazon.awssdk.services.chimesdkvoice.model.SessionBorderControllerType;
import software.amazon.awssdk.services.chimesdkvoice.model.SessionBorderControllerTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutVoiceConnectorExternalSystemsConfigurationRequest
extends ChimeSdkVoiceRequest
implements ToCopyableBuilder<Builder, PutVoiceConnectorExternalSystemsConfigurationRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceConnectorId").getter(PutVoiceConnectorExternalSystemsConfigurationRequest.getter(PutVoiceConnectorExternalSystemsConfigurationRequest::voiceConnectorId)).setter(PutVoiceConnectorExternalSystemsConfigurationRequest.setter(Builder::voiceConnectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("voiceConnectorId").build()}).build();
    private static final SdkField<List<String>> SESSION_BORDER_CONTROLLER_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SessionBorderControllerTypes").getter(PutVoiceConnectorExternalSystemsConfigurationRequest.getter(PutVoiceConnectorExternalSystemsConfigurationRequest::sessionBorderControllerTypesAsStrings)).setter(PutVoiceConnectorExternalSystemsConfigurationRequest.setter(Builder::sessionBorderControllerTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionBorderControllerTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CONTACT_CENTER_SYSTEM_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContactCenterSystemTypes").getter(PutVoiceConnectorExternalSystemsConfigurationRequest.getter(PutVoiceConnectorExternalSystemsConfigurationRequest::contactCenterSystemTypesAsStrings)).setter(PutVoiceConnectorExternalSystemsConfigurationRequest.setter(Builder::contactCenterSystemTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactCenterSystemTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD, SESSION_BORDER_CONTROLLER_TYPES_FIELD, CONTACT_CENTER_SYSTEM_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("voiceConnectorId", VOICE_CONNECTOR_ID_FIELD);
            this.put("SessionBorderControllerTypes", SESSION_BORDER_CONTROLLER_TYPES_FIELD);
            this.put("ContactCenterSystemTypes", CONTACT_CENTER_SYSTEM_TYPES_FIELD);
        }
    });
    private final String voiceConnectorId;
    private final List<String> sessionBorderControllerTypes;
    private final List<String> contactCenterSystemTypes;

    private PutVoiceConnectorExternalSystemsConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorId = builder.voiceConnectorId;
        this.sessionBorderControllerTypes = builder.sessionBorderControllerTypes;
        this.contactCenterSystemTypes = builder.contactCenterSystemTypes;
    }

    public final String voiceConnectorId() {
        return this.voiceConnectorId;
    }

    public final List<SessionBorderControllerType> sessionBorderControllerTypes() {
        return SessionBorderControllerTypeListCopier.copyStringToEnum(this.sessionBorderControllerTypes);
    }

    public final boolean hasSessionBorderControllerTypes() {
        return this.sessionBorderControllerTypes != null && !(this.sessionBorderControllerTypes instanceof SdkAutoConstructList);
    }

    public final List<String> sessionBorderControllerTypesAsStrings() {
        return this.sessionBorderControllerTypes;
    }

    public final List<ContactCenterSystemType> contactCenterSystemTypes() {
        return ContactCenterSystemTypeListCopier.copyStringToEnum(this.contactCenterSystemTypes);
    }

    public final boolean hasContactCenterSystemTypes() {
        return this.contactCenterSystemTypes != null && !(this.contactCenterSystemTypes instanceof SdkAutoConstructList);
    }

    public final List<String> contactCenterSystemTypesAsStrings() {
        return this.contactCenterSystemTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessionBorderControllerTypes() ? this.sessionBorderControllerTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContactCenterSystemTypes() ? this.contactCenterSystemTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutVoiceConnectorExternalSystemsConfigurationRequest)) {
            return false;
        }
        PutVoiceConnectorExternalSystemsConfigurationRequest other = (PutVoiceConnectorExternalSystemsConfigurationRequest)((Object)obj);
        return Objects.equals(this.voiceConnectorId(), other.voiceConnectorId()) && this.hasSessionBorderControllerTypes() == other.hasSessionBorderControllerTypes() && Objects.equals(this.sessionBorderControllerTypesAsStrings(), other.sessionBorderControllerTypesAsStrings()) && this.hasContactCenterSystemTypes() == other.hasContactCenterSystemTypes() && Objects.equals(this.contactCenterSystemTypesAsStrings(), other.contactCenterSystemTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"PutVoiceConnectorExternalSystemsConfigurationRequest").add("VoiceConnectorId", (Object)this.voiceConnectorId()).add("SessionBorderControllerTypes", this.hasSessionBorderControllerTypes() ? this.sessionBorderControllerTypesAsStrings() : null).add("ContactCenterSystemTypes", this.hasContactCenterSystemTypes() ? this.contactCenterSystemTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VoiceConnectorId": {
                return Optional.ofNullable(clazz.cast(this.voiceConnectorId()));
            }
            case "SessionBorderControllerTypes": {
                return Optional.ofNullable(clazz.cast(this.sessionBorderControllerTypesAsStrings()));
            }
            case "ContactCenterSystemTypes": {
                return Optional.ofNullable(clazz.cast(this.contactCenterSystemTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutVoiceConnectorExternalSystemsConfigurationRequest, T> g) {
        return obj -> g.apply((PutVoiceConnectorExternalSystemsConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkVoiceRequest.BuilderImpl
    implements Builder {
        private String voiceConnectorId;
        private List<String> sessionBorderControllerTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> contactCenterSystemTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutVoiceConnectorExternalSystemsConfigurationRequest model) {
            super(model);
            this.voiceConnectorId(model.voiceConnectorId);
            this.sessionBorderControllerTypesWithStrings(model.sessionBorderControllerTypes);
            this.contactCenterSystemTypesWithStrings(model.contactCenterSystemTypes);
        }

        public final String getVoiceConnectorId() {
            return this.voiceConnectorId;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final Collection<String> getSessionBorderControllerTypes() {
            if (this.sessionBorderControllerTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sessionBorderControllerTypes;
        }

        public final void setSessionBorderControllerTypes(Collection<String> sessionBorderControllerTypes) {
            this.sessionBorderControllerTypes = SessionBorderControllerTypeListCopier.copy(sessionBorderControllerTypes);
        }

        @Override
        public final Builder sessionBorderControllerTypesWithStrings(Collection<String> sessionBorderControllerTypes) {
            this.sessionBorderControllerTypes = SessionBorderControllerTypeListCopier.copy(sessionBorderControllerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionBorderControllerTypesWithStrings(String ... sessionBorderControllerTypes) {
            this.sessionBorderControllerTypesWithStrings(Arrays.asList(sessionBorderControllerTypes));
            return this;
        }

        @Override
        public final Builder sessionBorderControllerTypes(Collection<SessionBorderControllerType> sessionBorderControllerTypes) {
            this.sessionBorderControllerTypes = SessionBorderControllerTypeListCopier.copyEnumToString(sessionBorderControllerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionBorderControllerTypes(SessionBorderControllerType ... sessionBorderControllerTypes) {
            this.sessionBorderControllerTypes(Arrays.asList(sessionBorderControllerTypes));
            return this;
        }

        public final Collection<String> getContactCenterSystemTypes() {
            if (this.contactCenterSystemTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.contactCenterSystemTypes;
        }

        public final void setContactCenterSystemTypes(Collection<String> contactCenterSystemTypes) {
            this.contactCenterSystemTypes = ContactCenterSystemTypeListCopier.copy(contactCenterSystemTypes);
        }

        @Override
        public final Builder contactCenterSystemTypesWithStrings(Collection<String> contactCenterSystemTypes) {
            this.contactCenterSystemTypes = ContactCenterSystemTypeListCopier.copy(contactCenterSystemTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactCenterSystemTypesWithStrings(String ... contactCenterSystemTypes) {
            this.contactCenterSystemTypesWithStrings(Arrays.asList(contactCenterSystemTypes));
            return this;
        }

        @Override
        public final Builder contactCenterSystemTypes(Collection<ContactCenterSystemType> contactCenterSystemTypes) {
            this.contactCenterSystemTypes = ContactCenterSystemTypeListCopier.copyEnumToString(contactCenterSystemTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactCenterSystemTypes(ContactCenterSystemType ... contactCenterSystemTypes) {
            this.contactCenterSystemTypes(Arrays.asList(contactCenterSystemTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutVoiceConnectorExternalSystemsConfigurationRequest build() {
            return new PutVoiceConnectorExternalSystemsConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkVoiceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutVoiceConnectorExternalSystemsConfigurationRequest> {
        public Builder voiceConnectorId(String var1);

        public Builder sessionBorderControllerTypesWithStrings(Collection<String> var1);

        public Builder sessionBorderControllerTypesWithStrings(String ... var1);

        public Builder sessionBorderControllerTypes(Collection<SessionBorderControllerType> var1);

        public Builder sessionBorderControllerTypes(SessionBorderControllerType ... var1);

        public Builder contactCenterSystemTypesWithStrings(Collection<String> var1);

        public Builder contactCenterSystemTypesWithStrings(String ... var1);

        public Builder contactCenterSystemTypes(Collection<ContactCenterSystemType> var1);

        public Builder contactCenterSystemTypes(ContactCenterSystemType ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

