/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPhoneNumberSettingsResponse extends ChimeSdkVoiceResponse implements
        ToCopyableBuilder<GetPhoneNumberSettingsResponse.Builder, GetPhoneNumberSettingsResponse> {
    private static final SdkField<String> CALLING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CallingName").getter(getter(GetPhoneNumberSettingsResponse::callingName))
            .setter(setter(Builder::callingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallingName").build()).build();

    private static final SdkField<Instant> CALLING_NAME_UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CallingNameUpdatedTimestamp")
            .getter(getter(GetPhoneNumberSettingsResponse::callingNameUpdatedTimestamp))
            .setter(setter(Builder::callingNameUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallingNameUpdatedTimestamp")
                    .build(), TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLING_NAME_FIELD,
            CALLING_NAME_UPDATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String callingName;

    private final Instant callingNameUpdatedTimestamp;

    private GetPhoneNumberSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.callingName = builder.callingName;
        this.callingNameUpdatedTimestamp = builder.callingNameUpdatedTimestamp;
    }

    /**
     * <p>
     * The default outbound calling name for the account.
     * </p>
     * 
     * @return The default outbound calling name for the account.
     */
    public final String callingName() {
        return callingName;
    }

    /**
     * <p>
     * The updated outbound calling name timestamp, in ISO 8601 format.
     * </p>
     * 
     * @return The updated outbound calling name timestamp, in ISO 8601 format.
     */
    public final Instant callingNameUpdatedTimestamp() {
        return callingNameUpdatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(callingName());
        hashCode = 31 * hashCode + Objects.hashCode(callingNameUpdatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPhoneNumberSettingsResponse)) {
            return false;
        }
        GetPhoneNumberSettingsResponse other = (GetPhoneNumberSettingsResponse) obj;
        return Objects.equals(callingName(), other.callingName())
                && Objects.equals(callingNameUpdatedTimestamp(), other.callingNameUpdatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPhoneNumberSettingsResponse")
                .add("CallingName", callingName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CallingNameUpdatedTimestamp", callingNameUpdatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallingName":
            return Optional.ofNullable(clazz.cast(callingName()));
        case "CallingNameUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(callingNameUpdatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CallingName", CALLING_NAME_FIELD);
        map.put("CallingNameUpdatedTimestamp", CALLING_NAME_UPDATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPhoneNumberSettingsResponse, T> g) {
        return obj -> g.apply((GetPhoneNumberSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPhoneNumberSettingsResponse> {
        /**
         * <p>
         * The default outbound calling name for the account.
         * </p>
         * 
         * @param callingName
         *        The default outbound calling name for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callingName(String callingName);

        /**
         * <p>
         * The updated outbound calling name timestamp, in ISO 8601 format.
         * </p>
         * 
         * @param callingNameUpdatedTimestamp
         *        The updated outbound calling name timestamp, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callingNameUpdatedTimestamp(Instant callingNameUpdatedTimestamp);
    }

    static final class BuilderImpl extends ChimeSdkVoiceResponse.BuilderImpl implements Builder {
        private String callingName;

        private Instant callingNameUpdatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPhoneNumberSettingsResponse model) {
            super(model);
            callingName(model.callingName);
            callingNameUpdatedTimestamp(model.callingNameUpdatedTimestamp);
        }

        public final String getCallingName() {
            return callingName;
        }

        public final void setCallingName(String callingName) {
            this.callingName = callingName;
        }

        @Override
        public final Builder callingName(String callingName) {
            this.callingName = callingName;
            return this;
        }

        public final Instant getCallingNameUpdatedTimestamp() {
            return callingNameUpdatedTimestamp;
        }

        public final void setCallingNameUpdatedTimestamp(Instant callingNameUpdatedTimestamp) {
            this.callingNameUpdatedTimestamp = callingNameUpdatedTimestamp;
        }

        @Override
        public final Builder callingNameUpdatedTimestamp(Instant callingNameUpdatedTimestamp) {
            this.callingNameUpdatedTimestamp = callingNameUpdatedTimestamp;
            return this;
        }

        @Override
        public GetPhoneNumberSettingsResponse build() {
            return new GetPhoneNumberSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
