/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVoiceConnectorExternalSystemsConfigurationResponse extends ChimeSdkVoiceResponse
        implements
        ToCopyableBuilder<GetVoiceConnectorExternalSystemsConfigurationResponse.Builder, GetVoiceConnectorExternalSystemsConfigurationResponse> {
    private static final SdkField<ExternalSystemsConfiguration> EXTERNAL_SYSTEMS_CONFIGURATION_FIELD = SdkField
            .<ExternalSystemsConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ExternalSystemsConfiguration")
            .getter(getter(GetVoiceConnectorExternalSystemsConfigurationResponse::externalSystemsConfiguration))
            .setter(setter(Builder::externalSystemsConfiguration))
            .constructor(ExternalSystemsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalSystemsConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EXTERNAL_SYSTEMS_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ExternalSystemsConfiguration externalSystemsConfiguration;

    private GetVoiceConnectorExternalSystemsConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.externalSystemsConfiguration = builder.externalSystemsConfiguration;
    }

    /**
     * <p>
     * An object that contains information about an external systems configuration for a Voice Connector.
     * </p>
     * 
     * @return An object that contains information about an external systems configuration for a Voice Connector.
     */
    public final ExternalSystemsConfiguration externalSystemsConfiguration() {
        return externalSystemsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(externalSystemsConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVoiceConnectorExternalSystemsConfigurationResponse)) {
            return false;
        }
        GetVoiceConnectorExternalSystemsConfigurationResponse other = (GetVoiceConnectorExternalSystemsConfigurationResponse) obj;
        return Objects.equals(externalSystemsConfiguration(), other.externalSystemsConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetVoiceConnectorExternalSystemsConfigurationResponse")
                .add("ExternalSystemsConfiguration", externalSystemsConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExternalSystemsConfiguration":
            return Optional.ofNullable(clazz.cast(externalSystemsConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExternalSystemsConfiguration", EXTERNAL_SYSTEMS_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetVoiceConnectorExternalSystemsConfigurationResponse, T> g) {
        return obj -> g.apply((GetVoiceConnectorExternalSystemsConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetVoiceConnectorExternalSystemsConfigurationResponse> {
        /**
         * <p>
         * An object that contains information about an external systems configuration for a Voice Connector.
         * </p>
         * 
         * @param externalSystemsConfiguration
         *        An object that contains information about an external systems configuration for a Voice Connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalSystemsConfiguration(ExternalSystemsConfiguration externalSystemsConfiguration);

        /**
         * <p>
         * An object that contains information about an external systems configuration for a Voice Connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExternalSystemsConfiguration.Builder}
         * avoiding the need to create one manually via {@link ExternalSystemsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExternalSystemsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #externalSystemsConfiguration(ExternalSystemsConfiguration)}.
         * 
         * @param externalSystemsConfiguration
         *        a consumer that will call methods on {@link ExternalSystemsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalSystemsConfiguration(ExternalSystemsConfiguration)
         */
        default Builder externalSystemsConfiguration(Consumer<ExternalSystemsConfiguration.Builder> externalSystemsConfiguration) {
            return externalSystemsConfiguration(ExternalSystemsConfiguration.builder()
                    .applyMutation(externalSystemsConfiguration).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkVoiceResponse.BuilderImpl implements Builder {
        private ExternalSystemsConfiguration externalSystemsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVoiceConnectorExternalSystemsConfigurationResponse model) {
            super(model);
            externalSystemsConfiguration(model.externalSystemsConfiguration);
        }

        public final ExternalSystemsConfiguration.Builder getExternalSystemsConfiguration() {
            return externalSystemsConfiguration != null ? externalSystemsConfiguration.toBuilder() : null;
        }

        public final void setExternalSystemsConfiguration(ExternalSystemsConfiguration.BuilderImpl externalSystemsConfiguration) {
            this.externalSystemsConfiguration = externalSystemsConfiguration != null ? externalSystemsConfiguration.build()
                    : null;
        }

        @Override
        public final Builder externalSystemsConfiguration(ExternalSystemsConfiguration externalSystemsConfiguration) {
            this.externalSystemsConfiguration = externalSystemsConfiguration;
            return this;
        }

        @Override
        public GetVoiceConnectorExternalSystemsConfigurationResponse build() {
            return new GetVoiceConnectorExternalSystemsConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
