/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of an Amazon Chime SDK phone number order.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PhoneNumberOrder implements SdkPojo, Serializable,
        ToCopyableBuilder<PhoneNumberOrder.Builder, PhoneNumberOrder> {
    private static final SdkField<String> PHONE_NUMBER_ORDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumberOrderId").getter(getter(PhoneNumberOrder::phoneNumberOrderId))
            .setter(setter(Builder::phoneNumberOrderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberOrderId").build())
            .build();

    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductType").getter(getter(PhoneNumberOrder::productTypeAsString)).setter(setter(Builder::productType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(PhoneNumberOrder::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ORDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrderType").getter(getter(PhoneNumberOrder::orderTypeAsString)).setter(setter(Builder::orderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderType").build()).build();

    private static final SdkField<List<OrderedPhoneNumber>> ORDERED_PHONE_NUMBERS_FIELD = SdkField
            .<List<OrderedPhoneNumber>> builder(MarshallingType.LIST)
            .memberName("OrderedPhoneNumbers")
            .getter(getter(PhoneNumberOrder::orderedPhoneNumbers))
            .setter(setter(Builder::orderedPhoneNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderedPhoneNumbers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrderedPhoneNumber> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrderedPhoneNumber::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp")
            .getter(getter(PhoneNumberOrder::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp")
            .getter(getter(PhoneNumberOrder::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ORDER_ID_FIELD,
            PRODUCT_TYPE_FIELD, STATUS_FIELD, ORDER_TYPE_FIELD, ORDERED_PHONE_NUMBERS_FIELD, CREATED_TIMESTAMP_FIELD,
            UPDATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String phoneNumberOrderId;

    private final String productType;

    private final String status;

    private final String orderType;

    private final List<OrderedPhoneNumber> orderedPhoneNumbers;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private PhoneNumberOrder(BuilderImpl builder) {
        this.phoneNumberOrderId = builder.phoneNumberOrderId;
        this.productType = builder.productType;
        this.status = builder.status;
        this.orderType = builder.orderType;
        this.orderedPhoneNumbers = builder.orderedPhoneNumbers;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    /**
     * <p>
     * The ID of the phone order.
     * </p>
     * 
     * @return The ID of the phone order.
     */
    public final String phoneNumberOrderId() {
        return phoneNumberOrderId;
    }

    /**
     * <p>
     * The phone number order product type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link PhoneNumberProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The phone number order product type.
     * @see PhoneNumberProductType
     */
    public final PhoneNumberProductType productType() {
        return PhoneNumberProductType.fromValue(productType);
    }

    /**
     * <p>
     * The phone number order product type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link PhoneNumberProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The phone number order product type.
     * @see PhoneNumberProductType
     */
    public final String productTypeAsString() {
        return productType;
    }

    /**
     * <p>
     * The status of the phone number order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PhoneNumberOrderStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the phone number order.
     * @see PhoneNumberOrderStatus
     */
    public final PhoneNumberOrderStatus status() {
        return PhoneNumberOrderStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the phone number order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PhoneNumberOrderStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the phone number order.
     * @see PhoneNumberOrderStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The type of phone number being ordered, local or toll-free.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orderType} will
     * return {@link PhoneNumberOrderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #orderTypeAsString}.
     * </p>
     * 
     * @return The type of phone number being ordered, local or toll-free.
     * @see PhoneNumberOrderType
     */
    public final PhoneNumberOrderType orderType() {
        return PhoneNumberOrderType.fromValue(orderType);
    }

    /**
     * <p>
     * The type of phone number being ordered, local or toll-free.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orderType} will
     * return {@link PhoneNumberOrderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #orderTypeAsString}.
     * </p>
     * 
     * @return The type of phone number being ordered, local or toll-free.
     * @see PhoneNumberOrderType
     */
    public final String orderTypeAsString() {
        return orderType;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrderedPhoneNumbers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOrderedPhoneNumbers() {
        return orderedPhoneNumbers != null && !(orderedPhoneNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ordered phone number details, such as the phone number in E.164 format and the phone number status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrderedPhoneNumbers} method.
     * </p>
     * 
     * @return The ordered phone number details, such as the phone number in E.164 format and the phone number status.
     */
    public final List<OrderedPhoneNumber> orderedPhoneNumbers() {
        return orderedPhoneNumbers;
    }

    /**
     * <p>
     * The phone number order creation time stamp, in ISO 8601 format.
     * </p>
     * 
     * @return The phone number order creation time stamp, in ISO 8601 format.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The updated phone number order time stamp, in ISO 8601 format.
     * </p>
     * 
     * @return The updated phone number order time stamp, in ISO 8601 format.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberOrderId());
        hashCode = 31 * hashCode + Objects.hashCode(productTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(orderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrderedPhoneNumbers() ? orderedPhoneNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoneNumberOrder)) {
            return false;
        }
        PhoneNumberOrder other = (PhoneNumberOrder) obj;
        return Objects.equals(phoneNumberOrderId(), other.phoneNumberOrderId())
                && Objects.equals(productTypeAsString(), other.productTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(orderTypeAsString(), other.orderTypeAsString())
                && hasOrderedPhoneNumbers() == other.hasOrderedPhoneNumbers()
                && Objects.equals(orderedPhoneNumbers(), other.orderedPhoneNumbers())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PhoneNumberOrder").add("PhoneNumberOrderId", phoneNumberOrderId())
                .add("ProductType", productTypeAsString()).add("Status", statusAsString()).add("OrderType", orderTypeAsString())
                .add("OrderedPhoneNumbers", hasOrderedPhoneNumbers() ? orderedPhoneNumbers() : null)
                .add("CreatedTimestamp", createdTimestamp()).add("UpdatedTimestamp", updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneNumberOrderId":
            return Optional.ofNullable(clazz.cast(phoneNumberOrderId()));
        case "ProductType":
            return Optional.ofNullable(clazz.cast(productTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "OrderType":
            return Optional.ofNullable(clazz.cast(orderTypeAsString()));
        case "OrderedPhoneNumbers":
            return Optional.ofNullable(clazz.cast(orderedPhoneNumbers()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PhoneNumberOrderId", PHONE_NUMBER_ORDER_ID_FIELD);
        map.put("ProductType", PRODUCT_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("OrderType", ORDER_TYPE_FIELD);
        map.put("OrderedPhoneNumbers", ORDERED_PHONE_NUMBERS_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PhoneNumberOrder, T> g) {
        return obj -> g.apply((PhoneNumberOrder) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PhoneNumberOrder> {
        /**
         * <p>
         * The ID of the phone order.
         * </p>
         * 
         * @param phoneNumberOrderId
         *        The ID of the phone order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberOrderId(String phoneNumberOrderId);

        /**
         * <p>
         * The phone number order product type.
         * </p>
         * 
         * @param productType
         *        The phone number order product type.
         * @see PhoneNumberProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberProductType
         */
        Builder productType(String productType);

        /**
         * <p>
         * The phone number order product type.
         * </p>
         * 
         * @param productType
         *        The phone number order product type.
         * @see PhoneNumberProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberProductType
         */
        Builder productType(PhoneNumberProductType productType);

        /**
         * <p>
         * The status of the phone number order.
         * </p>
         * 
         * @param status
         *        The status of the phone number order.
         * @see PhoneNumberOrderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberOrderStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the phone number order.
         * </p>
         * 
         * @param status
         *        The status of the phone number order.
         * @see PhoneNumberOrderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberOrderStatus
         */
        Builder status(PhoneNumberOrderStatus status);

        /**
         * <p>
         * The type of phone number being ordered, local or toll-free.
         * </p>
         * 
         * @param orderType
         *        The type of phone number being ordered, local or toll-free.
         * @see PhoneNumberOrderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberOrderType
         */
        Builder orderType(String orderType);

        /**
         * <p>
         * The type of phone number being ordered, local or toll-free.
         * </p>
         * 
         * @param orderType
         *        The type of phone number being ordered, local or toll-free.
         * @see PhoneNumberOrderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberOrderType
         */
        Builder orderType(PhoneNumberOrderType orderType);

        /**
         * <p>
         * The ordered phone number details, such as the phone number in E.164 format and the phone number status.
         * </p>
         * 
         * @param orderedPhoneNumbers
         *        The ordered phone number details, such as the phone number in E.164 format and the phone number
         *        status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderedPhoneNumbers(Collection<OrderedPhoneNumber> orderedPhoneNumbers);

        /**
         * <p>
         * The ordered phone number details, such as the phone number in E.164 format and the phone number status.
         * </p>
         * 
         * @param orderedPhoneNumbers
         *        The ordered phone number details, such as the phone number in E.164 format and the phone number
         *        status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderedPhoneNumbers(OrderedPhoneNumber... orderedPhoneNumbers);

        /**
         * <p>
         * The ordered phone number details, such as the phone number in E.164 format and the phone number status.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.OrderedPhoneNumber.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.OrderedPhoneNumber#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.OrderedPhoneNumber.Builder#build()} is called
         * immediately and its result is passed to {@link #orderedPhoneNumbers(List<OrderedPhoneNumber>)}.
         * 
         * @param orderedPhoneNumbers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkvoice.model.OrderedPhoneNumber.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orderedPhoneNumbers(java.util.Collection<OrderedPhoneNumber>)
         */
        Builder orderedPhoneNumbers(Consumer<OrderedPhoneNumber.Builder>... orderedPhoneNumbers);

        /**
         * <p>
         * The phone number order creation time stamp, in ISO 8601 format.
         * </p>
         * 
         * @param createdTimestamp
         *        The phone number order creation time stamp, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The updated phone number order time stamp, in ISO 8601 format.
         * </p>
         * 
         * @param updatedTimestamp
         *        The updated phone number order time stamp, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String phoneNumberOrderId;

        private String productType;

        private String status;

        private String orderType;

        private List<OrderedPhoneNumber> orderedPhoneNumbers = DefaultSdkAutoConstructList.getInstance();

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(PhoneNumberOrder model) {
            phoneNumberOrderId(model.phoneNumberOrderId);
            productType(model.productType);
            status(model.status);
            orderType(model.orderType);
            orderedPhoneNumbers(model.orderedPhoneNumbers);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
        }

        public final String getPhoneNumberOrderId() {
            return phoneNumberOrderId;
        }

        public final void setPhoneNumberOrderId(String phoneNumberOrderId) {
            this.phoneNumberOrderId = phoneNumberOrderId;
        }

        @Override
        public final Builder phoneNumberOrderId(String phoneNumberOrderId) {
            this.phoneNumberOrderId = phoneNumberOrderId;
            return this;
        }

        public final String getProductType() {
            return productType;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(PhoneNumberProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PhoneNumberOrderStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getOrderType() {
            return orderType;
        }

        public final void setOrderType(String orderType) {
            this.orderType = orderType;
        }

        @Override
        public final Builder orderType(String orderType) {
            this.orderType = orderType;
            return this;
        }

        @Override
        public final Builder orderType(PhoneNumberOrderType orderType) {
            this.orderType(orderType == null ? null : orderType.toString());
            return this;
        }

        public final List<OrderedPhoneNumber.Builder> getOrderedPhoneNumbers() {
            List<OrderedPhoneNumber.Builder> result = OrderedPhoneNumberListCopier.copyToBuilder(this.orderedPhoneNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrderedPhoneNumbers(Collection<OrderedPhoneNumber.BuilderImpl> orderedPhoneNumbers) {
            this.orderedPhoneNumbers = OrderedPhoneNumberListCopier.copyFromBuilder(orderedPhoneNumbers);
        }

        @Override
        public final Builder orderedPhoneNumbers(Collection<OrderedPhoneNumber> orderedPhoneNumbers) {
            this.orderedPhoneNumbers = OrderedPhoneNumberListCopier.copy(orderedPhoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedPhoneNumbers(OrderedPhoneNumber... orderedPhoneNumbers) {
            orderedPhoneNumbers(Arrays.asList(orderedPhoneNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedPhoneNumbers(Consumer<OrderedPhoneNumber.Builder>... orderedPhoneNumbers) {
            orderedPhoneNumbers(Stream.of(orderedPhoneNumbers).map(c -> OrderedPhoneNumber.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        @Override
        public PhoneNumberOrder build() {
            return new PhoneNumberOrder(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
