/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSipMediaApplicationLoggingConfigurationRequest extends ChimeSdkVoiceRequest
        implements
        ToCopyableBuilder<PutSipMediaApplicationLoggingConfigurationRequest.Builder, PutSipMediaApplicationLoggingConfigurationRequest> {
    private static final SdkField<String> SIP_MEDIA_APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SipMediaApplicationId")
            .getter(getter(PutSipMediaApplicationLoggingConfigurationRequest::sipMediaApplicationId))
            .setter(setter(Builder::sipMediaApplicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sipMediaApplicationId").build())
            .build();

    private static final SdkField<SipMediaApplicationLoggingConfiguration> SIP_MEDIA_APPLICATION_LOGGING_CONFIGURATION_FIELD = SdkField
            .<SipMediaApplicationLoggingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("SipMediaApplicationLoggingConfiguration")
            .getter(getter(PutSipMediaApplicationLoggingConfigurationRequest::sipMediaApplicationLoggingConfiguration))
            .setter(setter(Builder::sipMediaApplicationLoggingConfiguration))
            .constructor(SipMediaApplicationLoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SipMediaApplicationLoggingConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SIP_MEDIA_APPLICATION_ID_FIELD, SIP_MEDIA_APPLICATION_LOGGING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sipMediaApplicationId;

    private final SipMediaApplicationLoggingConfiguration sipMediaApplicationLoggingConfiguration;

    private PutSipMediaApplicationLoggingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.sipMediaApplicationId = builder.sipMediaApplicationId;
        this.sipMediaApplicationLoggingConfiguration = builder.sipMediaApplicationLoggingConfiguration;
    }

    /**
     * <p>
     * The SIP media application ID.
     * </p>
     * 
     * @return The SIP media application ID.
     */
    public final String sipMediaApplicationId() {
        return sipMediaApplicationId;
    }

    /**
     * <p>
     * The logging configuration for the specified SIP media application.
     * </p>
     * 
     * @return The logging configuration for the specified SIP media application.
     */
    public final SipMediaApplicationLoggingConfiguration sipMediaApplicationLoggingConfiguration() {
        return sipMediaApplicationLoggingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sipMediaApplicationId());
        hashCode = 31 * hashCode + Objects.hashCode(sipMediaApplicationLoggingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSipMediaApplicationLoggingConfigurationRequest)) {
            return false;
        }
        PutSipMediaApplicationLoggingConfigurationRequest other = (PutSipMediaApplicationLoggingConfigurationRequest) obj;
        return Objects.equals(sipMediaApplicationId(), other.sipMediaApplicationId())
                && Objects.equals(sipMediaApplicationLoggingConfiguration(), other.sipMediaApplicationLoggingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSipMediaApplicationLoggingConfigurationRequest")
                .add("SipMediaApplicationId", sipMediaApplicationId())
                .add("SipMediaApplicationLoggingConfiguration", sipMediaApplicationLoggingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SipMediaApplicationId":
            return Optional.ofNullable(clazz.cast(sipMediaApplicationId()));
        case "SipMediaApplicationLoggingConfiguration":
            return Optional.ofNullable(clazz.cast(sipMediaApplicationLoggingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sipMediaApplicationId", SIP_MEDIA_APPLICATION_ID_FIELD);
        map.put("SipMediaApplicationLoggingConfiguration", SIP_MEDIA_APPLICATION_LOGGING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutSipMediaApplicationLoggingConfigurationRequest, T> g) {
        return obj -> g.apply((PutSipMediaApplicationLoggingConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutSipMediaApplicationLoggingConfigurationRequest> {
        /**
         * <p>
         * The SIP media application ID.
         * </p>
         * 
         * @param sipMediaApplicationId
         *        The SIP media application ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sipMediaApplicationId(String sipMediaApplicationId);

        /**
         * <p>
         * The logging configuration for the specified SIP media application.
         * </p>
         * 
         * @param sipMediaApplicationLoggingConfiguration
         *        The logging configuration for the specified SIP media application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sipMediaApplicationLoggingConfiguration(
                SipMediaApplicationLoggingConfiguration sipMediaApplicationLoggingConfiguration);

        /**
         * <p>
         * The logging configuration for the specified SIP media application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SipMediaApplicationLoggingConfiguration.Builder} avoiding the need to create one manually via
         * {@link SipMediaApplicationLoggingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SipMediaApplicationLoggingConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #sipMediaApplicationLoggingConfiguration(SipMediaApplicationLoggingConfiguration)}.
         * 
         * @param sipMediaApplicationLoggingConfiguration
         *        a consumer that will call methods on {@link SipMediaApplicationLoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sipMediaApplicationLoggingConfiguration(SipMediaApplicationLoggingConfiguration)
         */
        default Builder sipMediaApplicationLoggingConfiguration(
                Consumer<SipMediaApplicationLoggingConfiguration.Builder> sipMediaApplicationLoggingConfiguration) {
            return sipMediaApplicationLoggingConfiguration(SipMediaApplicationLoggingConfiguration.builder()
                    .applyMutation(sipMediaApplicationLoggingConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkVoiceRequest.BuilderImpl implements Builder {
        private String sipMediaApplicationId;

        private SipMediaApplicationLoggingConfiguration sipMediaApplicationLoggingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSipMediaApplicationLoggingConfigurationRequest model) {
            super(model);
            sipMediaApplicationId(model.sipMediaApplicationId);
            sipMediaApplicationLoggingConfiguration(model.sipMediaApplicationLoggingConfiguration);
        }

        public final String getSipMediaApplicationId() {
            return sipMediaApplicationId;
        }

        public final void setSipMediaApplicationId(String sipMediaApplicationId) {
            this.sipMediaApplicationId = sipMediaApplicationId;
        }

        @Override
        public final Builder sipMediaApplicationId(String sipMediaApplicationId) {
            this.sipMediaApplicationId = sipMediaApplicationId;
            return this;
        }

        public final SipMediaApplicationLoggingConfiguration.Builder getSipMediaApplicationLoggingConfiguration() {
            return sipMediaApplicationLoggingConfiguration != null ? sipMediaApplicationLoggingConfiguration.toBuilder() : null;
        }

        public final void setSipMediaApplicationLoggingConfiguration(
                SipMediaApplicationLoggingConfiguration.BuilderImpl sipMediaApplicationLoggingConfiguration) {
            this.sipMediaApplicationLoggingConfiguration = sipMediaApplicationLoggingConfiguration != null ? sipMediaApplicationLoggingConfiguration
                    .build() : null;
        }

        @Override
        public final Builder sipMediaApplicationLoggingConfiguration(
                SipMediaApplicationLoggingConfiguration sipMediaApplicationLoggingConfiguration) {
            this.sipMediaApplicationLoggingConfiguration = sipMediaApplicationLoggingConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSipMediaApplicationLoggingConfigurationRequest build() {
            return new PutSipMediaApplicationLoggingConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
