/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutVoiceConnectorExternalSystemsConfigurationRequest extends ChimeSdkVoiceRequest
        implements
        ToCopyableBuilder<PutVoiceConnectorExternalSystemsConfigurationRequest.Builder, PutVoiceConnectorExternalSystemsConfigurationRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceConnectorId")
            .getter(getter(PutVoiceConnectorExternalSystemsConfigurationRequest::voiceConnectorId))
            .setter(setter(Builder::voiceConnectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("voiceConnectorId").build()).build();

    private static final SdkField<List<String>> SESSION_BORDER_CONTROLLER_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SessionBorderControllerTypes")
            .getter(getter(PutVoiceConnectorExternalSystemsConfigurationRequest::sessionBorderControllerTypesAsStrings))
            .setter(setter(Builder::sessionBorderControllerTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionBorderControllerTypes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CONTACT_CENTER_SYSTEM_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ContactCenterSystemTypes")
            .getter(getter(PutVoiceConnectorExternalSystemsConfigurationRequest::contactCenterSystemTypesAsStrings))
            .setter(setter(Builder::contactCenterSystemTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactCenterSystemTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD,
            SESSION_BORDER_CONTROLLER_TYPES_FIELD, CONTACT_CENTER_SYSTEM_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String voiceConnectorId;

    private final List<String> sessionBorderControllerTypes;

    private final List<String> contactCenterSystemTypes;

    private PutVoiceConnectorExternalSystemsConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorId = builder.voiceConnectorId;
        this.sessionBorderControllerTypes = builder.sessionBorderControllerTypes;
        this.contactCenterSystemTypes = builder.contactCenterSystemTypes;
    }

    /**
     * <p>
     * The ID of the Voice Connector for which to add the external system configuration.
     * </p>
     * 
     * @return The ID of the Voice Connector for which to add the external system configuration.
     */
    public final String voiceConnectorId() {
        return voiceConnectorId;
    }

    /**
     * <p>
     * The session border controllers to use.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSessionBorderControllerTypes} method.
     * </p>
     * 
     * @return The session border controllers to use.
     */
    public final List<SessionBorderControllerType> sessionBorderControllerTypes() {
        return SessionBorderControllerTypeListCopier.copyStringToEnum(sessionBorderControllerTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the SessionBorderControllerTypes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSessionBorderControllerTypes() {
        return sessionBorderControllerTypes != null && !(sessionBorderControllerTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The session border controllers to use.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSessionBorderControllerTypes} method.
     * </p>
     * 
     * @return The session border controllers to use.
     */
    public final List<String> sessionBorderControllerTypesAsStrings() {
        return sessionBorderControllerTypes;
    }

    /**
     * <p>
     * The contact center system to use.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContactCenterSystemTypes} method.
     * </p>
     * 
     * @return The contact center system to use.
     */
    public final List<ContactCenterSystemType> contactCenterSystemTypes() {
        return ContactCenterSystemTypeListCopier.copyStringToEnum(contactCenterSystemTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the ContactCenterSystemTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasContactCenterSystemTypes() {
        return contactCenterSystemTypes != null && !(contactCenterSystemTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The contact center system to use.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContactCenterSystemTypes} method.
     * </p>
     * 
     * @return The contact center system to use.
     */
    public final List<String> contactCenterSystemTypesAsStrings() {
        return contactCenterSystemTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(voiceConnectorId());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSessionBorderControllerTypes() ? sessionBorderControllerTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasContactCenterSystemTypes() ? contactCenterSystemTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutVoiceConnectorExternalSystemsConfigurationRequest)) {
            return false;
        }
        PutVoiceConnectorExternalSystemsConfigurationRequest other = (PutVoiceConnectorExternalSystemsConfigurationRequest) obj;
        return Objects.equals(voiceConnectorId(), other.voiceConnectorId())
                && hasSessionBorderControllerTypes() == other.hasSessionBorderControllerTypes()
                && Objects.equals(sessionBorderControllerTypesAsStrings(), other.sessionBorderControllerTypesAsStrings())
                && hasContactCenterSystemTypes() == other.hasContactCenterSystemTypes()
                && Objects.equals(contactCenterSystemTypesAsStrings(), other.contactCenterSystemTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("PutVoiceConnectorExternalSystemsConfigurationRequest")
                .add("VoiceConnectorId", voiceConnectorId())
                .add("SessionBorderControllerTypes",
                        hasSessionBorderControllerTypes() ? sessionBorderControllerTypesAsStrings() : null)
                .add("ContactCenterSystemTypes", hasContactCenterSystemTypes() ? contactCenterSystemTypesAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceConnectorId":
            return Optional.ofNullable(clazz.cast(voiceConnectorId()));
        case "SessionBorderControllerTypes":
            return Optional.ofNullable(clazz.cast(sessionBorderControllerTypesAsStrings()));
        case "ContactCenterSystemTypes":
            return Optional.ofNullable(clazz.cast(contactCenterSystemTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("voiceConnectorId", VOICE_CONNECTOR_ID_FIELD);
        map.put("SessionBorderControllerTypes", SESSION_BORDER_CONTROLLER_TYPES_FIELD);
        map.put("ContactCenterSystemTypes", CONTACT_CENTER_SYSTEM_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutVoiceConnectorExternalSystemsConfigurationRequest, T> g) {
        return obj -> g.apply((PutVoiceConnectorExternalSystemsConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutVoiceConnectorExternalSystemsConfigurationRequest> {
        /**
         * <p>
         * The ID of the Voice Connector for which to add the external system configuration.
         * </p>
         * 
         * @param voiceConnectorId
         *        The ID of the Voice Connector for which to add the external system configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorId(String voiceConnectorId);

        /**
         * <p>
         * The session border controllers to use.
         * </p>
         * 
         * @param sessionBorderControllerTypes
         *        The session border controllers to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionBorderControllerTypesWithStrings(Collection<String> sessionBorderControllerTypes);

        /**
         * <p>
         * The session border controllers to use.
         * </p>
         * 
         * @param sessionBorderControllerTypes
         *        The session border controllers to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionBorderControllerTypesWithStrings(String... sessionBorderControllerTypes);

        /**
         * <p>
         * The session border controllers to use.
         * </p>
         * 
         * @param sessionBorderControllerTypes
         *        The session border controllers to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionBorderControllerTypes(Collection<SessionBorderControllerType> sessionBorderControllerTypes);

        /**
         * <p>
         * The session border controllers to use.
         * </p>
         * 
         * @param sessionBorderControllerTypes
         *        The session border controllers to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionBorderControllerTypes(SessionBorderControllerType... sessionBorderControllerTypes);

        /**
         * <p>
         * The contact center system to use.
         * </p>
         * 
         * @param contactCenterSystemTypes
         *        The contact center system to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactCenterSystemTypesWithStrings(Collection<String> contactCenterSystemTypes);

        /**
         * <p>
         * The contact center system to use.
         * </p>
         * 
         * @param contactCenterSystemTypes
         *        The contact center system to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactCenterSystemTypesWithStrings(String... contactCenterSystemTypes);

        /**
         * <p>
         * The contact center system to use.
         * </p>
         * 
         * @param contactCenterSystemTypes
         *        The contact center system to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactCenterSystemTypes(Collection<ContactCenterSystemType> contactCenterSystemTypes);

        /**
         * <p>
         * The contact center system to use.
         * </p>
         * 
         * @param contactCenterSystemTypes
         *        The contact center system to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactCenterSystemTypes(ContactCenterSystemType... contactCenterSystemTypes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkVoiceRequest.BuilderImpl implements Builder {
        private String voiceConnectorId;

        private List<String> sessionBorderControllerTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> contactCenterSystemTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutVoiceConnectorExternalSystemsConfigurationRequest model) {
            super(model);
            voiceConnectorId(model.voiceConnectorId);
            sessionBorderControllerTypesWithStrings(model.sessionBorderControllerTypes);
            contactCenterSystemTypesWithStrings(model.contactCenterSystemTypes);
        }

        public final String getVoiceConnectorId() {
            return voiceConnectorId;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final Collection<String> getSessionBorderControllerTypes() {
            if (sessionBorderControllerTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return sessionBorderControllerTypes;
        }

        public final void setSessionBorderControllerTypes(Collection<String> sessionBorderControllerTypes) {
            this.sessionBorderControllerTypes = SessionBorderControllerTypeListCopier.copy(sessionBorderControllerTypes);
        }

        @Override
        public final Builder sessionBorderControllerTypesWithStrings(Collection<String> sessionBorderControllerTypes) {
            this.sessionBorderControllerTypes = SessionBorderControllerTypeListCopier.copy(sessionBorderControllerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionBorderControllerTypesWithStrings(String... sessionBorderControllerTypes) {
            sessionBorderControllerTypesWithStrings(Arrays.asList(sessionBorderControllerTypes));
            return this;
        }

        @Override
        public final Builder sessionBorderControllerTypes(Collection<SessionBorderControllerType> sessionBorderControllerTypes) {
            this.sessionBorderControllerTypes = SessionBorderControllerTypeListCopier
                    .copyEnumToString(sessionBorderControllerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionBorderControllerTypes(SessionBorderControllerType... sessionBorderControllerTypes) {
            sessionBorderControllerTypes(Arrays.asList(sessionBorderControllerTypes));
            return this;
        }

        public final Collection<String> getContactCenterSystemTypes() {
            if (contactCenterSystemTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return contactCenterSystemTypes;
        }

        public final void setContactCenterSystemTypes(Collection<String> contactCenterSystemTypes) {
            this.contactCenterSystemTypes = ContactCenterSystemTypeListCopier.copy(contactCenterSystemTypes);
        }

        @Override
        public final Builder contactCenterSystemTypesWithStrings(Collection<String> contactCenterSystemTypes) {
            this.contactCenterSystemTypes = ContactCenterSystemTypeListCopier.copy(contactCenterSystemTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactCenterSystemTypesWithStrings(String... contactCenterSystemTypes) {
            contactCenterSystemTypesWithStrings(Arrays.asList(contactCenterSystemTypes));
            return this;
        }

        @Override
        public final Builder contactCenterSystemTypes(Collection<ContactCenterSystemType> contactCenterSystemTypes) {
            this.contactCenterSystemTypes = ContactCenterSystemTypeListCopier.copyEnumToString(contactCenterSystemTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactCenterSystemTypes(ContactCenterSystemType... contactCenterSystemTypes) {
            contactCenterSystemTypes(Arrays.asList(contactCenterSystemTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutVoiceConnectorExternalSystemsConfigurationRequest build() {
            return new PutVoiceConnectorExternalSystemsConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
