/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutVoiceConnectorTerminationResponse extends ChimeSdkVoiceResponse implements
        ToCopyableBuilder<PutVoiceConnectorTerminationResponse.Builder, PutVoiceConnectorTerminationResponse> {
    private static final SdkField<Termination> TERMINATION_FIELD = SdkField.<Termination> builder(MarshallingType.SDK_POJO)
            .memberName("Termination").getter(getter(PutVoiceConnectorTerminationResponse::termination))
            .setter(setter(Builder::termination)).constructor(Termination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Termination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMINATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Termination termination;

    private PutVoiceConnectorTerminationResponse(BuilderImpl builder) {
        super(builder);
        this.termination = builder.termination;
    }

    /**
     * <p>
     * The updated termination settings.
     * </p>
     * 
     * @return The updated termination settings.
     */
    public final Termination termination() {
        return termination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(termination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutVoiceConnectorTerminationResponse)) {
            return false;
        }
        PutVoiceConnectorTerminationResponse other = (PutVoiceConnectorTerminationResponse) obj;
        return Objects.equals(termination(), other.termination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutVoiceConnectorTerminationResponse").add("Termination", termination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Termination":
            return Optional.ofNullable(clazz.cast(termination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Termination", TERMINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutVoiceConnectorTerminationResponse, T> g) {
        return obj -> g.apply((PutVoiceConnectorTerminationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutVoiceConnectorTerminationResponse> {
        /**
         * <p>
         * The updated termination settings.
         * </p>
         * 
         * @param termination
         *        The updated termination settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder termination(Termination termination);

        /**
         * <p>
         * The updated termination settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link Termination.Builder} avoiding the need to
         * create one manually via {@link Termination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Termination.Builder#build()} is called immediately and its result
         * is passed to {@link #termination(Termination)}.
         * 
         * @param termination
         *        a consumer that will call methods on {@link Termination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #termination(Termination)
         */
        default Builder termination(Consumer<Termination.Builder> termination) {
            return termination(Termination.builder().applyMutation(termination).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkVoiceResponse.BuilderImpl implements Builder {
        private Termination termination;

        private BuilderImpl() {
        }

        private BuilderImpl(PutVoiceConnectorTerminationResponse model) {
            super(model);
            termination(model.termination);
        }

        public final Termination.Builder getTermination() {
            return termination != null ? termination.toBuilder() : null;
        }

        public final void setTermination(Termination.BuilderImpl termination) {
            this.termination = termination != null ? termination.build() : null;
        }

        @Override
        public final Builder termination(Termination termination) {
            this.termination = termination;
            return this;
        }

        @Override
        public PutVoiceConnectorTerminationResponse build() {
            return new PutVoiceConnectorTerminationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
