/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A representation of an asynchronous request to perform speaker search analysis on a Voice Connector call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpeakerSearchTask implements SdkPojo, Serializable,
        ToCopyableBuilder<SpeakerSearchTask.Builder, SpeakerSearchTask> {
    private static final SdkField<String> SPEAKER_SEARCH_TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpeakerSearchTaskId").getter(getter(SpeakerSearchTask::speakerSearchTaskId))
            .setter(setter(Builder::speakerSearchTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpeakerSearchTaskId").build())
            .build();

    private static final SdkField<String> SPEAKER_SEARCH_TASK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpeakerSearchTaskStatus").getter(getter(SpeakerSearchTask::speakerSearchTaskStatus))
            .setter(setter(Builder::speakerSearchTaskStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpeakerSearchTaskStatus").build())
            .build();

    private static final SdkField<CallDetails> CALL_DETAILS_FIELD = SdkField.<CallDetails> builder(MarshallingType.SDK_POJO)
            .memberName("CallDetails").getter(getter(SpeakerSearchTask::callDetails)).setter(setter(Builder::callDetails))
            .constructor(CallDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallDetails").build()).build();

    private static final SdkField<SpeakerSearchDetails> SPEAKER_SEARCH_DETAILS_FIELD = SdkField
            .<SpeakerSearchDetails> builder(MarshallingType.SDK_POJO).memberName("SpeakerSearchDetails")
            .getter(getter(SpeakerSearchTask::speakerSearchDetails)).setter(setter(Builder::speakerSearchDetails))
            .constructor(SpeakerSearchDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpeakerSearchDetails").build())
            .build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp")
            .getter(getter(SpeakerSearchTask::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp")
            .getter(getter(SpeakerSearchTask::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> STARTED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedTimestamp")
            .getter(getter(SpeakerSearchTask::startedTimestamp))
            .setter(setter(Builder::startedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(SpeakerSearchTask::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPEAKER_SEARCH_TASK_ID_FIELD,
            SPEAKER_SEARCH_TASK_STATUS_FIELD, CALL_DETAILS_FIELD, SPEAKER_SEARCH_DETAILS_FIELD, CREATED_TIMESTAMP_FIELD,
            UPDATED_TIMESTAMP_FIELD, STARTED_TIMESTAMP_FIELD, STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String speakerSearchTaskId;

    private final String speakerSearchTaskStatus;

    private final CallDetails callDetails;

    private final SpeakerSearchDetails speakerSearchDetails;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private final Instant startedTimestamp;

    private final String statusMessage;

    private SpeakerSearchTask(BuilderImpl builder) {
        this.speakerSearchTaskId = builder.speakerSearchTaskId;
        this.speakerSearchTaskStatus = builder.speakerSearchTaskStatus;
        this.callDetails = builder.callDetails;
        this.speakerSearchDetails = builder.speakerSearchDetails;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
        this.startedTimestamp = builder.startedTimestamp;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The speaker search task ID.
     * </p>
     * 
     * @return The speaker search task ID.
     */
    public final String speakerSearchTaskId() {
        return speakerSearchTaskId;
    }

    /**
     * <p>
     * The status of the speaker search task, <code>IN_QUEUE</code>, <code>IN_PROGRESS</code>,
     * <code>PARTIAL_SUCCESS</code>, <code>SUCCEEDED</code>, <code>FAILED</code>, or <code>STOPPED</code>.
     * </p>
     * 
     * @return The status of the speaker search task, <code>IN_QUEUE</code>, <code>IN_PROGRESS</code>,
     *         <code>PARTIAL_SUCCESS</code>, <code>SUCCEEDED</code>, <code>FAILED</code>, or <code>STOPPED</code>.
     */
    public final String speakerSearchTaskStatus() {
        return speakerSearchTaskStatus;
    }

    /**
     * <p>
     * The call details of a speaker search task.
     * </p>
     * 
     * @return The call details of a speaker search task.
     */
    public final CallDetails callDetails() {
        return callDetails;
    }

    /**
     * <p>
     * The details of a speaker search task.
     * </p>
     * 
     * @return The details of a speaker search task.
     */
    public final SpeakerSearchDetails speakerSearchDetails() {
        return speakerSearchDetails;
    }

    /**
     * <p>
     * The time at which a speaker search task was created.
     * </p>
     * 
     * @return The time at which a speaker search task was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The time at which a speaker search task was updated.
     * </p>
     * 
     * @return The time at which a speaker search task was updated.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    /**
     * <p>
     * The time at which the speaker search task began.
     * </p>
     * 
     * @return The time at which the speaker search task began.
     */
    public final Instant startedTimestamp() {
        return startedTimestamp;
    }

    /**
     * <p>
     * A detailed message about the status of a speaker search.
     * </p>
     * 
     * @return A detailed message about the status of a speaker search.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(speakerSearchTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(speakerSearchTaskStatus());
        hashCode = 31 * hashCode + Objects.hashCode(callDetails());
        hashCode = 31 * hashCode + Objects.hashCode(speakerSearchDetails());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(startedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpeakerSearchTask)) {
            return false;
        }
        SpeakerSearchTask other = (SpeakerSearchTask) obj;
        return Objects.equals(speakerSearchTaskId(), other.speakerSearchTaskId())
                && Objects.equals(speakerSearchTaskStatus(), other.speakerSearchTaskStatus())
                && Objects.equals(callDetails(), other.callDetails())
                && Objects.equals(speakerSearchDetails(), other.speakerSearchDetails())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp())
                && Objects.equals(startedTimestamp(), other.startedTimestamp())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpeakerSearchTask").add("SpeakerSearchTaskId", speakerSearchTaskId())
                .add("SpeakerSearchTaskStatus", speakerSearchTaskStatus()).add("CallDetails", callDetails())
                .add("SpeakerSearchDetails", speakerSearchDetails()).add("CreatedTimestamp", createdTimestamp())
                .add("UpdatedTimestamp", updatedTimestamp()).add("StartedTimestamp", startedTimestamp())
                .add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SpeakerSearchTaskId":
            return Optional.ofNullable(clazz.cast(speakerSearchTaskId()));
        case "SpeakerSearchTaskStatus":
            return Optional.ofNullable(clazz.cast(speakerSearchTaskStatus()));
        case "CallDetails":
            return Optional.ofNullable(clazz.cast(callDetails()));
        case "SpeakerSearchDetails":
            return Optional.ofNullable(clazz.cast(speakerSearchDetails()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        case "StartedTimestamp":
            return Optional.ofNullable(clazz.cast(startedTimestamp()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SpeakerSearchTaskId", SPEAKER_SEARCH_TASK_ID_FIELD);
        map.put("SpeakerSearchTaskStatus", SPEAKER_SEARCH_TASK_STATUS_FIELD);
        map.put("CallDetails", CALL_DETAILS_FIELD);
        map.put("SpeakerSearchDetails", SPEAKER_SEARCH_DETAILS_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        map.put("StartedTimestamp", STARTED_TIMESTAMP_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpeakerSearchTask, T> g) {
        return obj -> g.apply((SpeakerSearchTask) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpeakerSearchTask> {
        /**
         * <p>
         * The speaker search task ID.
         * </p>
         * 
         * @param speakerSearchTaskId
         *        The speaker search task ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speakerSearchTaskId(String speakerSearchTaskId);

        /**
         * <p>
         * The status of the speaker search task, <code>IN_QUEUE</code>, <code>IN_PROGRESS</code>,
         * <code>PARTIAL_SUCCESS</code>, <code>SUCCEEDED</code>, <code>FAILED</code>, or <code>STOPPED</code>.
         * </p>
         * 
         * @param speakerSearchTaskStatus
         *        The status of the speaker search task, <code>IN_QUEUE</code>, <code>IN_PROGRESS</code>,
         *        <code>PARTIAL_SUCCESS</code>, <code>SUCCEEDED</code>, <code>FAILED</code>, or <code>STOPPED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speakerSearchTaskStatus(String speakerSearchTaskStatus);

        /**
         * <p>
         * The call details of a speaker search task.
         * </p>
         * 
         * @param callDetails
         *        The call details of a speaker search task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callDetails(CallDetails callDetails);

        /**
         * <p>
         * The call details of a speaker search task.
         * </p>
         * This is a convenience method that creates an instance of the {@link CallDetails.Builder} avoiding the need to
         * create one manually via {@link CallDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CallDetails.Builder#build()} is called immediately and its result
         * is passed to {@link #callDetails(CallDetails)}.
         * 
         * @param callDetails
         *        a consumer that will call methods on {@link CallDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #callDetails(CallDetails)
         */
        default Builder callDetails(Consumer<CallDetails.Builder> callDetails) {
            return callDetails(CallDetails.builder().applyMutation(callDetails).build());
        }

        /**
         * <p>
         * The details of a speaker search task.
         * </p>
         * 
         * @param speakerSearchDetails
         *        The details of a speaker search task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speakerSearchDetails(SpeakerSearchDetails speakerSearchDetails);

        /**
         * <p>
         * The details of a speaker search task.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpeakerSearchDetails.Builder} avoiding
         * the need to create one manually via {@link SpeakerSearchDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpeakerSearchDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #speakerSearchDetails(SpeakerSearchDetails)}.
         * 
         * @param speakerSearchDetails
         *        a consumer that will call methods on {@link SpeakerSearchDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #speakerSearchDetails(SpeakerSearchDetails)
         */
        default Builder speakerSearchDetails(Consumer<SpeakerSearchDetails.Builder> speakerSearchDetails) {
            return speakerSearchDetails(SpeakerSearchDetails.builder().applyMutation(speakerSearchDetails).build());
        }

        /**
         * <p>
         * The time at which a speaker search task was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time at which a speaker search task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The time at which a speaker search task was updated.
         * </p>
         * 
         * @param updatedTimestamp
         *        The time at which a speaker search task was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);

        /**
         * <p>
         * The time at which the speaker search task began.
         * </p>
         * 
         * @param startedTimestamp
         *        The time at which the speaker search task began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedTimestamp(Instant startedTimestamp);

        /**
         * <p>
         * A detailed message about the status of a speaker search.
         * </p>
         * 
         * @param statusMessage
         *        A detailed message about the status of a speaker search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String speakerSearchTaskId;

        private String speakerSearchTaskStatus;

        private CallDetails callDetails;

        private SpeakerSearchDetails speakerSearchDetails;

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private Instant startedTimestamp;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(SpeakerSearchTask model) {
            speakerSearchTaskId(model.speakerSearchTaskId);
            speakerSearchTaskStatus(model.speakerSearchTaskStatus);
            callDetails(model.callDetails);
            speakerSearchDetails(model.speakerSearchDetails);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
            startedTimestamp(model.startedTimestamp);
            statusMessage(model.statusMessage);
        }

        public final String getSpeakerSearchTaskId() {
            return speakerSearchTaskId;
        }

        public final void setSpeakerSearchTaskId(String speakerSearchTaskId) {
            this.speakerSearchTaskId = speakerSearchTaskId;
        }

        @Override
        public final Builder speakerSearchTaskId(String speakerSearchTaskId) {
            this.speakerSearchTaskId = speakerSearchTaskId;
            return this;
        }

        public final String getSpeakerSearchTaskStatus() {
            return speakerSearchTaskStatus;
        }

        public final void setSpeakerSearchTaskStatus(String speakerSearchTaskStatus) {
            this.speakerSearchTaskStatus = speakerSearchTaskStatus;
        }

        @Override
        public final Builder speakerSearchTaskStatus(String speakerSearchTaskStatus) {
            this.speakerSearchTaskStatus = speakerSearchTaskStatus;
            return this;
        }

        public final CallDetails.Builder getCallDetails() {
            return callDetails != null ? callDetails.toBuilder() : null;
        }

        public final void setCallDetails(CallDetails.BuilderImpl callDetails) {
            this.callDetails = callDetails != null ? callDetails.build() : null;
        }

        @Override
        public final Builder callDetails(CallDetails callDetails) {
            this.callDetails = callDetails;
            return this;
        }

        public final SpeakerSearchDetails.Builder getSpeakerSearchDetails() {
            return speakerSearchDetails != null ? speakerSearchDetails.toBuilder() : null;
        }

        public final void setSpeakerSearchDetails(SpeakerSearchDetails.BuilderImpl speakerSearchDetails) {
            this.speakerSearchDetails = speakerSearchDetails != null ? speakerSearchDetails.build() : null;
        }

        @Override
        public final Builder speakerSearchDetails(SpeakerSearchDetails speakerSearchDetails) {
            this.speakerSearchDetails = speakerSearchDetails;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final Instant getStartedTimestamp() {
            return startedTimestamp;
        }

        public final void setStartedTimestamp(Instant startedTimestamp) {
            this.startedTimestamp = startedTimestamp;
        }

        @Override
        public final Builder startedTimestamp(Instant startedTimestamp) {
            this.startedTimestamp = startedTimestamp;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public SpeakerSearchTask build() {
            return new SpeakerSearchTask(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
