/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartVoiceToneAnalysisTaskRequest extends ChimeSdkVoiceRequest implements
        ToCopyableBuilder<StartVoiceToneAnalysisTaskRequest.Builder, StartVoiceToneAnalysisTaskRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceConnectorId").getter(getter(StartVoiceToneAnalysisTaskRequest::voiceConnectorId))
            .setter(setter(Builder::voiceConnectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("VoiceConnectorId").build()).build();

    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransactionId").getter(getter(StartVoiceToneAnalysisTaskRequest::transactionId))
            .setter(setter(Builder::transactionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(StartVoiceToneAnalysisTaskRequest::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken").getter(getter(StartVoiceToneAnalysisTaskRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD,
            TRANSACTION_ID_FIELD, LANGUAGE_CODE_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String voiceConnectorId;

    private final String transactionId;

    private final String languageCode;

    private final String clientRequestToken;

    private StartVoiceToneAnalysisTaskRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorId = builder.voiceConnectorId;
        this.transactionId = builder.transactionId;
        this.languageCode = builder.languageCode;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The Voice Connector ID.
     * </p>
     * 
     * @return The Voice Connector ID.
     */
    public final String voiceConnectorId() {
        return voiceConnectorId;
    }

    /**
     * <p>
     * The transaction ID.
     * </p>
     * 
     * @return The transaction ID.
     */
    public final String transactionId() {
        return transactionId;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The unique identifier for the client request. Use a different token for different voice tone analysis tasks.
     * </p>
     * 
     * @return The unique identifier for the client request. Use a different token for different voice tone analysis
     *         tasks.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartVoiceToneAnalysisTaskRequest)) {
            return false;
        }
        StartVoiceToneAnalysisTaskRequest other = (StartVoiceToneAnalysisTaskRequest) obj;
        return Objects.equals(voiceConnectorId(), other.voiceConnectorId())
                && Objects.equals(transactionId(), other.transactionId())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartVoiceToneAnalysisTaskRequest").add("VoiceConnectorId", voiceConnectorId())
                .add("TransactionId", transactionId()).add("LanguageCode", languageCodeAsString())
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceConnectorId":
            return Optional.ofNullable(clazz.cast(voiceConnectorId()));
        case "TransactionId":
            return Optional.ofNullable(clazz.cast(transactionId()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VoiceConnectorId", VOICE_CONNECTOR_ID_FIELD);
        map.put("TransactionId", TRANSACTION_ID_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartVoiceToneAnalysisTaskRequest, T> g) {
        return obj -> g.apply((StartVoiceToneAnalysisTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartVoiceToneAnalysisTaskRequest> {
        /**
         * <p>
         * The Voice Connector ID.
         * </p>
         * 
         * @param voiceConnectorId
         *        The Voice Connector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorId(String voiceConnectorId);

        /**
         * <p>
         * The transaction ID.
         * </p>
         * 
         * @param transactionId
         *        The transaction ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionId(String transactionId);

        /**
         * <p>
         * The language code.
         * </p>
         * 
         * @param languageCode
         *        The language code.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code.
         * </p>
         * 
         * @param languageCode
         *        The language code.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The unique identifier for the client request. Use a different token for different voice tone analysis tasks.
         * </p>
         * 
         * @param clientRequestToken
         *        The unique identifier for the client request. Use a different token for different voice tone analysis
         *        tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkVoiceRequest.BuilderImpl implements Builder {
        private String voiceConnectorId;

        private String transactionId;

        private String languageCode;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartVoiceToneAnalysisTaskRequest model) {
            super(model);
            voiceConnectorId(model.voiceConnectorId);
            transactionId(model.transactionId);
            languageCode(model.languageCode);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getVoiceConnectorId() {
            return voiceConnectorId;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final String getTransactionId() {
            return transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartVoiceToneAnalysisTaskRequest build() {
            return new StartVoiceToneAnalysisTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
