/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVoiceProfileDomainRequest extends ChimeSdkVoiceRequest implements
        ToCopyableBuilder<UpdateVoiceProfileDomainRequest.Builder, UpdateVoiceProfileDomainRequest> {
    private static final SdkField<String> VOICE_PROFILE_DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceProfileDomainId").getter(getter(UpdateVoiceProfileDomainRequest::voiceProfileDomainId))
            .setter(setter(Builder::voiceProfileDomainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("VoiceProfileDomainId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateVoiceProfileDomainRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateVoiceProfileDomainRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_PROFILE_DOMAIN_ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String voiceProfileDomainId;

    private final String name;

    private final String description;

    private UpdateVoiceProfileDomainRequest(BuilderImpl builder) {
        super(builder);
        this.voiceProfileDomainId = builder.voiceProfileDomainId;
        this.name = builder.name;
        this.description = builder.description;
    }

    /**
     * <p>
     * The domain ID.
     * </p>
     * 
     * @return The domain ID.
     */
    public final String voiceProfileDomainId() {
        return voiceProfileDomainId;
    }

    /**
     * <p>
     * The name of the voice profile domain.
     * </p>
     * 
     * @return The name of the voice profile domain.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the voice profile domain.
     * </p>
     * 
     * @return The description of the voice profile domain.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(voiceProfileDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVoiceProfileDomainRequest)) {
            return false;
        }
        UpdateVoiceProfileDomainRequest other = (UpdateVoiceProfileDomainRequest) obj;
        return Objects.equals(voiceProfileDomainId(), other.voiceProfileDomainId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVoiceProfileDomainRequest").add("VoiceProfileDomainId", voiceProfileDomainId())
                .add("Name", name()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceProfileDomainId":
            return Optional.ofNullable(clazz.cast(voiceProfileDomainId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VoiceProfileDomainId", VOICE_PROFILE_DOMAIN_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateVoiceProfileDomainRequest, T> g) {
        return obj -> g.apply((UpdateVoiceProfileDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateVoiceProfileDomainRequest> {
        /**
         * <p>
         * The domain ID.
         * </p>
         * 
         * @param voiceProfileDomainId
         *        The domain ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceProfileDomainId(String voiceProfileDomainId);

        /**
         * <p>
         * The name of the voice profile domain.
         * </p>
         * 
         * @param name
         *        The name of the voice profile domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the voice profile domain.
         * </p>
         * 
         * @param description
         *        The description of the voice profile domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkVoiceRequest.BuilderImpl implements Builder {
        private String voiceProfileDomainId;

        private String name;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVoiceProfileDomainRequest model) {
            super(model);
            voiceProfileDomainId(model.voiceProfileDomainId);
            name(model.name);
            description(model.description);
        }

        public final String getVoiceProfileDomainId() {
            return voiceProfileDomainId;
        }

        public final void setVoiceProfileDomainId(String voiceProfileDomainId) {
            this.voiceProfileDomainId = voiceProfileDomainId;
        }

        @Override
        public final Builder voiceProfileDomainId(String voiceProfileDomainId) {
            this.voiceProfileDomainId = voiceProfileDomainId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVoiceProfileDomainRequest build() {
            return new UpdateVoiceProfileDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
