/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Chime SDK Voice Connector group configuration, including associated Voice Connectors. You can include
 * Voice Connectors from different AWS Regions in a group. This creates a fault tolerant mechanism for fallback in case
 * of availability events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VoiceConnectorGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<VoiceConnectorGroup.Builder, VoiceConnectorGroup> {
    private static final SdkField<String> VOICE_CONNECTOR_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceConnectorGroupId").getter(getter(VoiceConnectorGroup::voiceConnectorGroupId))
            .setter(setter(Builder::voiceConnectorGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnectorGroupId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(VoiceConnectorGroup::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<VoiceConnectorItem>> VOICE_CONNECTOR_ITEMS_FIELD = SdkField
            .<List<VoiceConnectorItem>> builder(MarshallingType.LIST)
            .memberName("VoiceConnectorItems")
            .getter(getter(VoiceConnectorGroup::voiceConnectorItems))
            .setter(setter(Builder::voiceConnectorItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnectorItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VoiceConnectorItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(VoiceConnectorItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp")
            .getter(getter(VoiceConnectorGroup::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp")
            .getter(getter(VoiceConnectorGroup::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> VOICE_CONNECTOR_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceConnectorGroupArn").getter(getter(VoiceConnectorGroup::voiceConnectorGroupArn))
            .setter(setter(Builder::voiceConnectorGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnectorGroupArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VOICE_CONNECTOR_GROUP_ID_FIELD, NAME_FIELD, VOICE_CONNECTOR_ITEMS_FIELD, CREATED_TIMESTAMP_FIELD,
            UPDATED_TIMESTAMP_FIELD, VOICE_CONNECTOR_GROUP_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String voiceConnectorGroupId;

    private final String name;

    private final List<VoiceConnectorItem> voiceConnectorItems;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private final String voiceConnectorGroupArn;

    private VoiceConnectorGroup(BuilderImpl builder) {
        this.voiceConnectorGroupId = builder.voiceConnectorGroupId;
        this.name = builder.name;
        this.voiceConnectorItems = builder.voiceConnectorItems;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
        this.voiceConnectorGroupArn = builder.voiceConnectorGroupArn;
    }

    /**
     * <p>
     * The ID of a Voice Connector group.
     * </p>
     * 
     * @return The ID of a Voice Connector group.
     */
    public final String voiceConnectorGroupId() {
        return voiceConnectorGroupId;
    }

    /**
     * <p>
     * The name of a Voice Connector group.
     * </p>
     * 
     * @return The name of a Voice Connector group.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the VoiceConnectorItems property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVoiceConnectorItems() {
        return voiceConnectorItems != null && !(voiceConnectorItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Voice Connectors to which you route inbound calls.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVoiceConnectorItems} method.
     * </p>
     * 
     * @return The Voice Connectors to which you route inbound calls.
     */
    public final List<VoiceConnectorItem> voiceConnectorItems() {
        return voiceConnectorItems;
    }

    /**
     * <p>
     * The Voice Connector group's creation time stamp, in ISO 8601 format.
     * </p>
     * 
     * @return The Voice Connector group's creation time stamp, in ISO 8601 format.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The Voice Connector group's creation time stamp, in ISO 8601 format.
     * </p>
     * 
     * @return The Voice Connector group's creation time stamp, in ISO 8601 format.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    /**
     * <p>
     * The ARN of the Voice Connector group.
     * </p>
     * 
     * @return The ARN of the Voice Connector group.
     */
    public final String voiceConnectorGroupArn() {
        return voiceConnectorGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(voiceConnectorGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasVoiceConnectorItems() ? voiceConnectorItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(voiceConnectorGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceConnectorGroup)) {
            return false;
        }
        VoiceConnectorGroup other = (VoiceConnectorGroup) obj;
        return Objects.equals(voiceConnectorGroupId(), other.voiceConnectorGroupId()) && Objects.equals(name(), other.name())
                && hasVoiceConnectorItems() == other.hasVoiceConnectorItems()
                && Objects.equals(voiceConnectorItems(), other.voiceConnectorItems())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp())
                && Objects.equals(voiceConnectorGroupArn(), other.voiceConnectorGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VoiceConnectorGroup").add("VoiceConnectorGroupId", voiceConnectorGroupId()).add("Name", name())
                .add("VoiceConnectorItems", hasVoiceConnectorItems() ? voiceConnectorItems() : null)
                .add("CreatedTimestamp", createdTimestamp()).add("UpdatedTimestamp", updatedTimestamp())
                .add("VoiceConnectorGroupArn", voiceConnectorGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceConnectorGroupId":
            return Optional.ofNullable(clazz.cast(voiceConnectorGroupId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "VoiceConnectorItems":
            return Optional.ofNullable(clazz.cast(voiceConnectorItems()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        case "VoiceConnectorGroupArn":
            return Optional.ofNullable(clazz.cast(voiceConnectorGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VoiceConnectorGroupId", VOICE_CONNECTOR_GROUP_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("VoiceConnectorItems", VOICE_CONNECTOR_ITEMS_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        map.put("VoiceConnectorGroupArn", VOICE_CONNECTOR_GROUP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VoiceConnectorGroup, T> g) {
        return obj -> g.apply((VoiceConnectorGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VoiceConnectorGroup> {
        /**
         * <p>
         * The ID of a Voice Connector group.
         * </p>
         * 
         * @param voiceConnectorGroupId
         *        The ID of a Voice Connector group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorGroupId(String voiceConnectorGroupId);

        /**
         * <p>
         * The name of a Voice Connector group.
         * </p>
         * 
         * @param name
         *        The name of a Voice Connector group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Voice Connectors to which you route inbound calls.
         * </p>
         * 
         * @param voiceConnectorItems
         *        The Voice Connectors to which you route inbound calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorItems(Collection<VoiceConnectorItem> voiceConnectorItems);

        /**
         * <p>
         * The Voice Connectors to which you route inbound calls.
         * </p>
         * 
         * @param voiceConnectorItems
         *        The Voice Connectors to which you route inbound calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorItems(VoiceConnectorItem... voiceConnectorItems);

        /**
         * <p>
         * The Voice Connectors to which you route inbound calls.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnectorItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnectorItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnectorItem.Builder#build()} is called
         * immediately and its result is passed to {@link #voiceConnectorItems(List<VoiceConnectorItem>)}.
         * 
         * @param voiceConnectorItems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnectorItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceConnectorItems(java.util.Collection<VoiceConnectorItem>)
         */
        Builder voiceConnectorItems(Consumer<VoiceConnectorItem.Builder>... voiceConnectorItems);

        /**
         * <p>
         * The Voice Connector group's creation time stamp, in ISO 8601 format.
         * </p>
         * 
         * @param createdTimestamp
         *        The Voice Connector group's creation time stamp, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The Voice Connector group's creation time stamp, in ISO 8601 format.
         * </p>
         * 
         * @param updatedTimestamp
         *        The Voice Connector group's creation time stamp, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);

        /**
         * <p>
         * The ARN of the Voice Connector group.
         * </p>
         * 
         * @param voiceConnectorGroupArn
         *        The ARN of the Voice Connector group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorGroupArn(String voiceConnectorGroupArn);
    }

    static final class BuilderImpl implements Builder {
        private String voiceConnectorGroupId;

        private String name;

        private List<VoiceConnectorItem> voiceConnectorItems = DefaultSdkAutoConstructList.getInstance();

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private String voiceConnectorGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceConnectorGroup model) {
            voiceConnectorGroupId(model.voiceConnectorGroupId);
            name(model.name);
            voiceConnectorItems(model.voiceConnectorItems);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
            voiceConnectorGroupArn(model.voiceConnectorGroupArn);
        }

        public final String getVoiceConnectorGroupId() {
            return voiceConnectorGroupId;
        }

        public final void setVoiceConnectorGroupId(String voiceConnectorGroupId) {
            this.voiceConnectorGroupId = voiceConnectorGroupId;
        }

        @Override
        public final Builder voiceConnectorGroupId(String voiceConnectorGroupId) {
            this.voiceConnectorGroupId = voiceConnectorGroupId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<VoiceConnectorItem.Builder> getVoiceConnectorItems() {
            List<VoiceConnectorItem.Builder> result = VoiceConnectorItemListCopier.copyToBuilder(this.voiceConnectorItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVoiceConnectorItems(Collection<VoiceConnectorItem.BuilderImpl> voiceConnectorItems) {
            this.voiceConnectorItems = VoiceConnectorItemListCopier.copyFromBuilder(voiceConnectorItems);
        }

        @Override
        public final Builder voiceConnectorItems(Collection<VoiceConnectorItem> voiceConnectorItems) {
            this.voiceConnectorItems = VoiceConnectorItemListCopier.copy(voiceConnectorItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voiceConnectorItems(VoiceConnectorItem... voiceConnectorItems) {
            voiceConnectorItems(Arrays.asList(voiceConnectorItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voiceConnectorItems(Consumer<VoiceConnectorItem.Builder>... voiceConnectorItems) {
            voiceConnectorItems(Stream.of(voiceConnectorItems).map(c -> VoiceConnectorItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final String getVoiceConnectorGroupArn() {
            return voiceConnectorGroupArn;
        }

        public final void setVoiceConnectorGroupArn(String voiceConnectorGroupArn) {
            this.voiceConnectorGroupArn = voiceConnectorGroupArn;
        }

        @Override
        public final Builder voiceConnectorGroupArn(String voiceConnectorGroupArn) {
            this.voiceConnectorGroupArn = voiceConnectorGroupArn;
            return this;
        }

        @Override
        public VoiceConnectorGroup build() {
            return new VoiceConnectorGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
