/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkvoice.ChimeSdkVoiceClient;
import software.amazon.awssdk.services.chimesdkvoice.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.SipRule;

public class ListSipRulesIterable
implements SdkIterable<ListSipRulesResponse> {
    private final ChimeSdkVoiceClient client;
    private final ListSipRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSipRulesIterable(ChimeSdkVoiceClient client, ListSipRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSipRulesResponseFetcher();
    }

    public Iterator<ListSipRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SipRule> sipRules() {
        Function<ListSipRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.sipRules() != null) {
                return response.sipRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSipRulesResponseFetcher
    implements SyncPageFetcher<ListSipRulesResponse> {
        private ListSipRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListSipRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSipRulesResponse nextPage(ListSipRulesResponse previousPage) {
            if (previousPage == null) {
                return ListSipRulesIterable.this.client.listSipRules(ListSipRulesIterable.this.firstRequest);
            }
            return ListSipRulesIterable.this.client.listSipRules((ListSipRulesRequest)((Object)ListSipRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

