/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkvoice.model.ChimeSdkVoiceRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.SipRuleTargetApplication;
import software.amazon.awssdk.services.chimesdkvoice.model.SipRuleTargetApplicationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSipRuleRequest
extends ChimeSdkVoiceRequest
implements ToCopyableBuilder<Builder, UpdateSipRuleRequest> {
    private static final SdkField<String> SIP_RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SipRuleId").getter(UpdateSipRuleRequest.getter(UpdateSipRuleRequest::sipRuleId)).setter(UpdateSipRuleRequest.setter(Builder::sipRuleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sipRuleId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateSipRuleRequest.getter(UpdateSipRuleRequest::name)).setter(UpdateSipRuleRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Disabled").getter(UpdateSipRuleRequest.getter(UpdateSipRuleRequest::disabled)).setter(UpdateSipRuleRequest.setter(Builder::disabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()}).build();
    private static final SdkField<List<SipRuleTargetApplication>> TARGET_APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetApplications").getter(UpdateSipRuleRequest.getter(UpdateSipRuleRequest::targetApplications)).setter(UpdateSipRuleRequest.setter(Builder::targetApplications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetApplications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SipRuleTargetApplication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIP_RULE_ID_FIELD, NAME_FIELD, DISABLED_FIELD, TARGET_APPLICATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSipRuleRequest.memberNameToFieldInitializer();
    private final String sipRuleId;
    private final String name;
    private final Boolean disabled;
    private final List<SipRuleTargetApplication> targetApplications;

    private UpdateSipRuleRequest(BuilderImpl builder) {
        super(builder);
        this.sipRuleId = builder.sipRuleId;
        this.name = builder.name;
        this.disabled = builder.disabled;
        this.targetApplications = builder.targetApplications;
    }

    public final String sipRuleId() {
        return this.sipRuleId;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean disabled() {
        return this.disabled;
    }

    public final boolean hasTargetApplications() {
        return this.targetApplications != null && !(this.targetApplications instanceof SdkAutoConstructList);
    }

    public final List<SipRuleTargetApplication> targetApplications() {
        return this.targetApplications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sipRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetApplications() ? this.targetApplications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSipRuleRequest)) {
            return false;
        }
        UpdateSipRuleRequest other = (UpdateSipRuleRequest)((Object)obj);
        return Objects.equals(this.sipRuleId(), other.sipRuleId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.disabled(), other.disabled()) && this.hasTargetApplications() == other.hasTargetApplications() && Objects.equals(this.targetApplications(), other.targetApplications());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSipRuleRequest").add("SipRuleId", (Object)this.sipRuleId()).add("Name", (Object)this.name()).add("Disabled", (Object)this.disabled()).add("TargetApplications", this.hasTargetApplications() ? this.targetApplications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SipRuleId": {
                return Optional.ofNullable(clazz.cast(this.sipRuleId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Disabled": {
                return Optional.ofNullable(clazz.cast(this.disabled()));
            }
            case "TargetApplications": {
                return Optional.ofNullable(clazz.cast(this.targetApplications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sipRuleId", SIP_RULE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Disabled", DISABLED_FIELD);
        map.put("TargetApplications", TARGET_APPLICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSipRuleRequest, T> g) {
        return obj -> g.apply((UpdateSipRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkVoiceRequest.BuilderImpl
    implements Builder {
        private String sipRuleId;
        private String name;
        private Boolean disabled;
        private List<SipRuleTargetApplication> targetApplications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSipRuleRequest model) {
            super(model);
            this.sipRuleId(model.sipRuleId);
            this.name(model.name);
            this.disabled(model.disabled);
            this.targetApplications(model.targetApplications);
        }

        public final String getSipRuleId() {
            return this.sipRuleId;
        }

        public final void setSipRuleId(String sipRuleId) {
            this.sipRuleId = sipRuleId;
        }

        @Override
        public final Builder sipRuleId(String sipRuleId) {
            this.sipRuleId = sipRuleId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getDisabled() {
            return this.disabled;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public final List<SipRuleTargetApplication.Builder> getTargetApplications() {
            List<SipRuleTargetApplication.Builder> result = SipRuleTargetApplicationListCopier.copyToBuilder(this.targetApplications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetApplications(Collection<SipRuleTargetApplication.BuilderImpl> targetApplications) {
            this.targetApplications = SipRuleTargetApplicationListCopier.copyFromBuilder(targetApplications);
        }

        @Override
        public final Builder targetApplications(Collection<SipRuleTargetApplication> targetApplications) {
            this.targetApplications = SipRuleTargetApplicationListCopier.copy(targetApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetApplications(SipRuleTargetApplication ... targetApplications) {
            this.targetApplications(Arrays.asList(targetApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetApplications(Consumer<SipRuleTargetApplication.Builder> ... targetApplications) {
            this.targetApplications(Stream.of(targetApplications).map(c -> (SipRuleTargetApplication)((SipRuleTargetApplication.Builder)SipRuleTargetApplication.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSipRuleRequest build() {
            return new UpdateSipRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkVoiceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSipRuleRequest> {
        public Builder sipRuleId(String var1);

        public Builder name(String var1);

        public Builder disabled(Boolean var1);

        public Builder targetApplications(Collection<SipRuleTargetApplication> var1);

        public Builder targetApplications(SipRuleTargetApplication ... var1);

        public Builder targetApplications(Consumer<SipRuleTargetApplication.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

