/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkvoice.model.ChimeSdkVoiceRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.Tag;
import software.amazon.awssdk.services.chimesdkvoice.model.TagListCopier;
import software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnectorAwsRegion;
import software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnectorIntegrationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVoiceConnectorRequest
extends ChimeSdkVoiceRequest
implements ToCopyableBuilder<Builder, CreateVoiceConnectorRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateVoiceConnectorRequest.getter(CreateVoiceConnectorRequest::name)).setter(CreateVoiceConnectorRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsRegion").getter(CreateVoiceConnectorRequest.getter(CreateVoiceConnectorRequest::awsRegionAsString)).setter(CreateVoiceConnectorRequest.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()}).build();
    private static final SdkField<Boolean> REQUIRE_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequireEncryption").getter(CreateVoiceConnectorRequest.getter(CreateVoiceConnectorRequest::requireEncryption)).setter(CreateVoiceConnectorRequest.setter(Builder::requireEncryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireEncryption").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateVoiceConnectorRequest.getter(CreateVoiceConnectorRequest::tags)).setter(CreateVoiceConnectorRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INTEGRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationType").getter(CreateVoiceConnectorRequest.getter(CreateVoiceConnectorRequest::integrationTypeAsString)).setter(CreateVoiceConnectorRequest.setter(Builder::integrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, AWS_REGION_FIELD, REQUIRE_ENCRYPTION_FIELD, TAGS_FIELD, INTEGRATION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateVoiceConnectorRequest.memberNameToFieldInitializer();
    private final String name;
    private final String awsRegion;
    private final Boolean requireEncryption;
    private final List<Tag> tags;
    private final String integrationType;

    private CreateVoiceConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.awsRegion = builder.awsRegion;
        this.requireEncryption = builder.requireEncryption;
        this.tags = builder.tags;
        this.integrationType = builder.integrationType;
    }

    public final String name() {
        return this.name;
    }

    public final VoiceConnectorAwsRegion awsRegion() {
        return VoiceConnectorAwsRegion.fromValue(this.awsRegion);
    }

    public final String awsRegionAsString() {
        return this.awsRegion;
    }

    public final Boolean requireEncryption() {
        return this.requireEncryption;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final VoiceConnectorIntegrationType integrationType() {
        return VoiceConnectorIntegrationType.fromValue(this.integrationType);
    }

    public final String integrationTypeAsString() {
        return this.integrationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVoiceConnectorRequest)) {
            return false;
        }
        CreateVoiceConnectorRequest other = (CreateVoiceConnectorRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.awsRegionAsString(), other.awsRegionAsString()) && Objects.equals(this.requireEncryption(), other.requireEncryption()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.integrationTypeAsString(), other.integrationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVoiceConnectorRequest").add("Name", (Object)this.name()).add("AwsRegion", (Object)this.awsRegionAsString()).add("RequireEncryption", (Object)this.requireEncryption()).add("Tags", this.hasTags() ? this.tags() : null).add("IntegrationType", (Object)this.integrationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AwsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegionAsString()));
            }
            case "RequireEncryption": {
                return Optional.ofNullable(clazz.cast(this.requireEncryption()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "IntegrationType": {
                return Optional.ofNullable(clazz.cast(this.integrationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("AwsRegion", AWS_REGION_FIELD);
        map.put("RequireEncryption", REQUIRE_ENCRYPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("IntegrationType", INTEGRATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVoiceConnectorRequest, T> g) {
        return obj -> g.apply((CreateVoiceConnectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkVoiceRequest.BuilderImpl
    implements Builder {
        private String name;
        private String awsRegion;
        private Boolean requireEncryption;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String integrationType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVoiceConnectorRequest model) {
            super(model);
            this.name(model.name);
            this.awsRegion(model.awsRegion);
            this.requireEncryption(model.requireEncryption);
            this.tags(model.tags);
            this.integrationType(model.integrationType);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        @Override
        public final Builder awsRegion(VoiceConnectorAwsRegion awsRegion) {
            this.awsRegion(awsRegion == null ? null : awsRegion.toString());
            return this;
        }

        public final Boolean getRequireEncryption() {
            return this.requireEncryption;
        }

        public final void setRequireEncryption(Boolean requireEncryption) {
            this.requireEncryption = requireEncryption;
        }

        @Override
        public final Builder requireEncryption(Boolean requireEncryption) {
            this.requireEncryption = requireEncryption;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIntegrationType() {
            return this.integrationType;
        }

        public final void setIntegrationType(String integrationType) {
            this.integrationType = integrationType;
        }

        @Override
        public final Builder integrationType(String integrationType) {
            this.integrationType = integrationType;
            return this;
        }

        @Override
        public final Builder integrationType(VoiceConnectorIntegrationType integrationType) {
            this.integrationType(integrationType == null ? null : integrationType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVoiceConnectorRequest build() {
            return new CreateVoiceConnectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ChimeSdkVoiceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVoiceConnectorRequest> {
        public Builder name(String var1);

        public Builder awsRegion(String var1);

        public Builder awsRegion(VoiceConnectorAwsRegion var1);

        public Builder requireEncryption(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder integrationType(String var1);

        public Builder integrationType(VoiceConnectorIntegrationType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

