/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProxySessionResponse extends ChimeSdkVoiceResponse implements
        ToCopyableBuilder<GetProxySessionResponse.Builder, GetProxySessionResponse> {
    private static final SdkField<ProxySession> PROXY_SESSION_FIELD = SdkField.<ProxySession> builder(MarshallingType.SDK_POJO)
            .memberName("ProxySession").getter(getter(GetProxySessionResponse::proxySession))
            .setter(setter(Builder::proxySession)).constructor(ProxySession::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxySession").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_SESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ProxySession proxySession;

    private GetProxySessionResponse(BuilderImpl builder) {
        super(builder);
        this.proxySession = builder.proxySession;
    }

    /**
     * <p>
     * The proxy session details.
     * </p>
     * 
     * @return The proxy session details.
     */
    public final ProxySession proxySession() {
        return proxySession;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(proxySession());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProxySessionResponse)) {
            return false;
        }
        GetProxySessionResponse other = (GetProxySessionResponse) obj;
        return Objects.equals(proxySession(), other.proxySession());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetProxySessionResponse").add("ProxySession", proxySession()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProxySession":
            return Optional.ofNullable(clazz.cast(proxySession()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProxySession", PROXY_SESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetProxySessionResponse, T> g) {
        return obj -> g.apply((GetProxySessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ChimeSdkVoiceResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetProxySessionResponse> {
        /**
         * <p>
         * The proxy session details.
         * </p>
         * 
         * @param proxySession
         *        The proxy session details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxySession(ProxySession proxySession);

        /**
         * <p>
         * The proxy session details.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProxySession.Builder} avoiding the need
         * to create one manually via {@link ProxySession#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProxySession.Builder#build()} is called immediately and its
         * result is passed to {@link #proxySession(ProxySession)}.
         * 
         * @param proxySession
         *        a consumer that will call methods on {@link ProxySession.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proxySession(ProxySession)
         */
        default Builder proxySession(Consumer<ProxySession.Builder> proxySession) {
            return proxySession(ProxySession.builder().applyMutation(proxySession).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkVoiceResponse.BuilderImpl implements Builder {
        private ProxySession proxySession;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProxySessionResponse model) {
            super(model);
            proxySession(model.proxySession);
        }

        public final ProxySession.Builder getProxySession() {
            return proxySession != null ? proxySession.toBuilder() : null;
        }

        public final void setProxySession(ProxySession.BuilderImpl proxySession) {
            this.proxySession = proxySession != null ? proxySession.build() : null;
        }

        @Override
        public final Builder proxySession(ProxySession proxySession) {
            this.proxySession = proxySession;
            return this;
        }

        @Override
        public GetProxySessionResponse build() {
            return new GetProxySessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
