/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVoiceProfileDomainResponse extends ChimeSdkVoiceResponse implements
        ToCopyableBuilder<GetVoiceProfileDomainResponse.Builder, GetVoiceProfileDomainResponse> {
    private static final SdkField<VoiceProfileDomain> VOICE_PROFILE_DOMAIN_FIELD = SdkField
            .<VoiceProfileDomain> builder(MarshallingType.SDK_POJO).memberName("VoiceProfileDomain")
            .getter(getter(GetVoiceProfileDomainResponse::voiceProfileDomain)).setter(setter(Builder::voiceProfileDomain))
            .constructor(VoiceProfileDomain::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceProfileDomain").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_PROFILE_DOMAIN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VoiceProfileDomain voiceProfileDomain;

    private GetVoiceProfileDomainResponse(BuilderImpl builder) {
        super(builder);
        this.voiceProfileDomain = builder.voiceProfileDomain;
    }

    /**
     * <p>
     * The details of the voice profile domain.
     * </p>
     * 
     * @return The details of the voice profile domain.
     */
    public final VoiceProfileDomain voiceProfileDomain() {
        return voiceProfileDomain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(voiceProfileDomain());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVoiceProfileDomainResponse)) {
            return false;
        }
        GetVoiceProfileDomainResponse other = (GetVoiceProfileDomainResponse) obj;
        return Objects.equals(voiceProfileDomain(), other.voiceProfileDomain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetVoiceProfileDomainResponse").add("VoiceProfileDomain", voiceProfileDomain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceProfileDomain":
            return Optional.ofNullable(clazz.cast(voiceProfileDomain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VoiceProfileDomain", VOICE_PROFILE_DOMAIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetVoiceProfileDomainResponse, T> g) {
        return obj -> g.apply((GetVoiceProfileDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ChimeSdkVoiceResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetVoiceProfileDomainResponse> {
        /**
         * <p>
         * The details of the voice profile domain.
         * </p>
         * 
         * @param voiceProfileDomain
         *        The details of the voice profile domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceProfileDomain(VoiceProfileDomain voiceProfileDomain);

        /**
         * <p>
         * The details of the voice profile domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link VoiceProfileDomain.Builder} avoiding the
         * need to create one manually via {@link VoiceProfileDomain#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VoiceProfileDomain.Builder#build()} is called immediately and its
         * result is passed to {@link #voiceProfileDomain(VoiceProfileDomain)}.
         * 
         * @param voiceProfileDomain
         *        a consumer that will call methods on {@link VoiceProfileDomain.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceProfileDomain(VoiceProfileDomain)
         */
        default Builder voiceProfileDomain(Consumer<VoiceProfileDomain.Builder> voiceProfileDomain) {
            return voiceProfileDomain(VoiceProfileDomain.builder().applyMutation(voiceProfileDomain).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkVoiceResponse.BuilderImpl implements Builder {
        private VoiceProfileDomain voiceProfileDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVoiceProfileDomainResponse model) {
            super(model);
            voiceProfileDomain(model.voiceProfileDomain);
        }

        public final VoiceProfileDomain.Builder getVoiceProfileDomain() {
            return voiceProfileDomain != null ? voiceProfileDomain.toBuilder() : null;
        }

        public final void setVoiceProfileDomain(VoiceProfileDomain.BuilderImpl voiceProfileDomain) {
            this.voiceProfileDomain = voiceProfileDomain != null ? voiceProfileDomain.build() : null;
        }

        @Override
        public final Builder voiceProfileDomain(VoiceProfileDomain voiceProfileDomain) {
            this.voiceProfileDomain = voiceProfileDomain;
            return this;
        }

        @Override
        public GetVoiceProfileDomainResponse build() {
            return new GetVoiceProfileDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
