/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The logging configuration associated with an Amazon Chime SDK Voice Connector. Specifies whether SIP message logs can
 * be sent to Amazon CloudWatch Logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LoggingConfiguration.Builder, LoggingConfiguration> {
    private static final SdkField<Boolean> ENABLE_SIP_LOGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableSIPLogs").getter(getter(LoggingConfiguration::enableSIPLogs))
            .setter(setter(Builder::enableSIPLogs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableSIPLogs").build()).build();

    private static final SdkField<Boolean> ENABLE_MEDIA_METRIC_LOGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableMediaMetricLogs").getter(getter(LoggingConfiguration::enableMediaMetricLogs))
            .setter(setter(Builder::enableMediaMetricLogs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableMediaMetricLogs").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_SIP_LOGS_FIELD,
            ENABLE_MEDIA_METRIC_LOGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enableSIPLogs;

    private final Boolean enableMediaMetricLogs;

    private LoggingConfiguration(BuilderImpl builder) {
        this.enableSIPLogs = builder.enableSIPLogs;
        this.enableMediaMetricLogs = builder.enableMediaMetricLogs;
    }

    /**
     * <p>
     * Boolean that enables sending SIP message logs to Amazon CloudWatch.
     * </p>
     * 
     * @return Boolean that enables sending SIP message logs to Amazon CloudWatch.
     */
    public final Boolean enableSIPLogs() {
        return enableSIPLogs;
    }

    /**
     * <p>
     * Enables or disables media metrics logging.
     * </p>
     * 
     * @return Enables or disables media metrics logging.
     */
    public final Boolean enableMediaMetricLogs() {
        return enableMediaMetricLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableSIPLogs());
        hashCode = 31 * hashCode + Objects.hashCode(enableMediaMetricLogs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfiguration)) {
            return false;
        }
        LoggingConfiguration other = (LoggingConfiguration) obj;
        return Objects.equals(enableSIPLogs(), other.enableSIPLogs())
                && Objects.equals(enableMediaMetricLogs(), other.enableMediaMetricLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoggingConfiguration").add("EnableSIPLogs", enableSIPLogs())
                .add("EnableMediaMetricLogs", enableMediaMetricLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableSIPLogs":
            return Optional.ofNullable(clazz.cast(enableSIPLogs()));
        case "EnableMediaMetricLogs":
            return Optional.ofNullable(clazz.cast(enableMediaMetricLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnableSIPLogs", ENABLE_SIP_LOGS_FIELD);
        map.put("EnableMediaMetricLogs", ENABLE_MEDIA_METRIC_LOGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoggingConfiguration, T> g) {
        return obj -> g.apply((LoggingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoggingConfiguration> {
        /**
         * <p>
         * Boolean that enables sending SIP message logs to Amazon CloudWatch.
         * </p>
         * 
         * @param enableSIPLogs
         *        Boolean that enables sending SIP message logs to Amazon CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableSIPLogs(Boolean enableSIPLogs);

        /**
         * <p>
         * Enables or disables media metrics logging.
         * </p>
         * 
         * @param enableMediaMetricLogs
         *        Enables or disables media metrics logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableMediaMetricLogs(Boolean enableMediaMetricLogs);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableSIPLogs;

        private Boolean enableMediaMetricLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfiguration model) {
            enableSIPLogs(model.enableSIPLogs);
            enableMediaMetricLogs(model.enableMediaMetricLogs);
        }

        public final Boolean getEnableSIPLogs() {
            return enableSIPLogs;
        }

        public final void setEnableSIPLogs(Boolean enableSIPLogs) {
            this.enableSIPLogs = enableSIPLogs;
        }

        @Override
        public final Builder enableSIPLogs(Boolean enableSIPLogs) {
            this.enableSIPLogs = enableSIPLogs;
            return this;
        }

        public final Boolean getEnableMediaMetricLogs() {
            return enableMediaMetricLogs;
        }

        public final void setEnableMediaMetricLogs(Boolean enableMediaMetricLogs) {
            this.enableMediaMetricLogs = enableMediaMetricLogs;
        }

        @Override
        public final Builder enableMediaMetricLogs(Boolean enableMediaMetricLogs) {
            this.enableMediaMetricLogs = enableMediaMetricLogs;
            return this;
        }

        @Override
        public LoggingConfiguration build() {
            return new LoggingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
