/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSipMediaApplicationAlexaSkillConfigurationRequest extends ChimeSdkVoiceRequest
        implements
        ToCopyableBuilder<PutSipMediaApplicationAlexaSkillConfigurationRequest.Builder, PutSipMediaApplicationAlexaSkillConfigurationRequest> {
    private static final SdkField<String> SIP_MEDIA_APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SipMediaApplicationId")
            .getter(getter(PutSipMediaApplicationAlexaSkillConfigurationRequest::sipMediaApplicationId))
            .setter(setter(Builder::sipMediaApplicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sipMediaApplicationId").build())
            .build();

    private static final SdkField<SipMediaApplicationAlexaSkillConfiguration> SIP_MEDIA_APPLICATION_ALEXA_SKILL_CONFIGURATION_FIELD = SdkField
            .<SipMediaApplicationAlexaSkillConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("SipMediaApplicationAlexaSkillConfiguration")
            .getter(getter(PutSipMediaApplicationAlexaSkillConfigurationRequest::sipMediaApplicationAlexaSkillConfiguration))
            .setter(setter(Builder::sipMediaApplicationAlexaSkillConfiguration))
            .constructor(SipMediaApplicationAlexaSkillConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SipMediaApplicationAlexaSkillConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SIP_MEDIA_APPLICATION_ID_FIELD, SIP_MEDIA_APPLICATION_ALEXA_SKILL_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sipMediaApplicationId;

    private final SipMediaApplicationAlexaSkillConfiguration sipMediaApplicationAlexaSkillConfiguration;

    private PutSipMediaApplicationAlexaSkillConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.sipMediaApplicationId = builder.sipMediaApplicationId;
        this.sipMediaApplicationAlexaSkillConfiguration = builder.sipMediaApplicationAlexaSkillConfiguration;
    }

    /**
     * <p>
     * The SIP media application ID.
     * </p>
     * 
     * @return The SIP media application ID.
     */
    public final String sipMediaApplicationId() {
        return sipMediaApplicationId;
    }

    /**
     * <p>
     * The Alexa Skill configuration.
     * </p>
     * 
     * @return The Alexa Skill configuration.
     */
    public final SipMediaApplicationAlexaSkillConfiguration sipMediaApplicationAlexaSkillConfiguration() {
        return sipMediaApplicationAlexaSkillConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sipMediaApplicationId());
        hashCode = 31 * hashCode + Objects.hashCode(sipMediaApplicationAlexaSkillConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSipMediaApplicationAlexaSkillConfigurationRequest)) {
            return false;
        }
        PutSipMediaApplicationAlexaSkillConfigurationRequest other = (PutSipMediaApplicationAlexaSkillConfigurationRequest) obj;
        return Objects.equals(sipMediaApplicationId(), other.sipMediaApplicationId())
                && Objects.equals(sipMediaApplicationAlexaSkillConfiguration(),
                        other.sipMediaApplicationAlexaSkillConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSipMediaApplicationAlexaSkillConfigurationRequest")
                .add("SipMediaApplicationId", sipMediaApplicationId())
                .add("SipMediaApplicationAlexaSkillConfiguration", sipMediaApplicationAlexaSkillConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SipMediaApplicationId":
            return Optional.ofNullable(clazz.cast(sipMediaApplicationId()));
        case "SipMediaApplicationAlexaSkillConfiguration":
            return Optional.ofNullable(clazz.cast(sipMediaApplicationAlexaSkillConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sipMediaApplicationId", SIP_MEDIA_APPLICATION_ID_FIELD);
        map.put("SipMediaApplicationAlexaSkillConfiguration", SIP_MEDIA_APPLICATION_ALEXA_SKILL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutSipMediaApplicationAlexaSkillConfigurationRequest, T> g) {
        return obj -> g.apply((PutSipMediaApplicationAlexaSkillConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ChimeSdkVoiceRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutSipMediaApplicationAlexaSkillConfigurationRequest> {
        /**
         * <p>
         * The SIP media application ID.
         * </p>
         * 
         * @param sipMediaApplicationId
         *        The SIP media application ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sipMediaApplicationId(String sipMediaApplicationId);

        /**
         * <p>
         * The Alexa Skill configuration.
         * </p>
         * 
         * @param sipMediaApplicationAlexaSkillConfiguration
         *        The Alexa Skill configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sipMediaApplicationAlexaSkillConfiguration(
                SipMediaApplicationAlexaSkillConfiguration sipMediaApplicationAlexaSkillConfiguration);

        /**
         * <p>
         * The Alexa Skill configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SipMediaApplicationAlexaSkillConfiguration.Builder} avoiding the need to create one manually via
         * {@link SipMediaApplicationAlexaSkillConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SipMediaApplicationAlexaSkillConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #sipMediaApplicationAlexaSkillConfiguration(SipMediaApplicationAlexaSkillConfiguration)}.
         * 
         * @param sipMediaApplicationAlexaSkillConfiguration
         *        a consumer that will call methods on {@link SipMediaApplicationAlexaSkillConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sipMediaApplicationAlexaSkillConfiguration(SipMediaApplicationAlexaSkillConfiguration)
         */
        default Builder sipMediaApplicationAlexaSkillConfiguration(
                Consumer<SipMediaApplicationAlexaSkillConfiguration.Builder> sipMediaApplicationAlexaSkillConfiguration) {
            return sipMediaApplicationAlexaSkillConfiguration(SipMediaApplicationAlexaSkillConfiguration.builder()
                    .applyMutation(sipMediaApplicationAlexaSkillConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkVoiceRequest.BuilderImpl implements Builder {
        private String sipMediaApplicationId;

        private SipMediaApplicationAlexaSkillConfiguration sipMediaApplicationAlexaSkillConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSipMediaApplicationAlexaSkillConfigurationRequest model) {
            super(model);
            sipMediaApplicationId(model.sipMediaApplicationId);
            sipMediaApplicationAlexaSkillConfiguration(model.sipMediaApplicationAlexaSkillConfiguration);
        }

        public final String getSipMediaApplicationId() {
            return sipMediaApplicationId;
        }

        public final void setSipMediaApplicationId(String sipMediaApplicationId) {
            this.sipMediaApplicationId = sipMediaApplicationId;
        }

        @Override
        public final Builder sipMediaApplicationId(String sipMediaApplicationId) {
            this.sipMediaApplicationId = sipMediaApplicationId;
            return this;
        }

        public final SipMediaApplicationAlexaSkillConfiguration.Builder getSipMediaApplicationAlexaSkillConfiguration() {
            return sipMediaApplicationAlexaSkillConfiguration != null ? sipMediaApplicationAlexaSkillConfiguration.toBuilder()
                    : null;
        }

        public final void setSipMediaApplicationAlexaSkillConfiguration(
                SipMediaApplicationAlexaSkillConfiguration.BuilderImpl sipMediaApplicationAlexaSkillConfiguration) {
            this.sipMediaApplicationAlexaSkillConfiguration = sipMediaApplicationAlexaSkillConfiguration != null ? sipMediaApplicationAlexaSkillConfiguration
                    .build() : null;
        }

        @Override
        public final Builder sipMediaApplicationAlexaSkillConfiguration(
                SipMediaApplicationAlexaSkillConfiguration sipMediaApplicationAlexaSkillConfiguration) {
            this.sipMediaApplicationAlexaSkillConfiguration = sipMediaApplicationAlexaSkillConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSipMediaApplicationAlexaSkillConfigurationRequest build() {
            return new PutSipMediaApplicationAlexaSkillConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
