/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProxySessionRequest extends ChimeSdkVoiceRequest implements
        ToCopyableBuilder<UpdateProxySessionRequest.Builder, UpdateProxySessionRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceConnectorId").getter(getter(UpdateProxySessionRequest::voiceConnectorId))
            .setter(setter(Builder::voiceConnectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("voiceConnectorId").build()).build();

    private static final SdkField<String> PROXY_SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxySessionId").getter(getter(UpdateProxySessionRequest::proxySessionId))
            .setter(setter(Builder::proxySessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("proxySessionId").build()).build();

    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Capabilities")
            .getter(getter(UpdateProxySessionRequest::capabilitiesAsStrings))
            .setter(setter(Builder::capabilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> EXPIRY_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExpiryMinutes").getter(getter(UpdateProxySessionRequest::expiryMinutes))
            .setter(setter(Builder::expiryMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryMinutes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD,
            PROXY_SESSION_ID_FIELD, CAPABILITIES_FIELD, EXPIRY_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String voiceConnectorId;

    private final String proxySessionId;

    private final List<String> capabilities;

    private final Integer expiryMinutes;

    private UpdateProxySessionRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorId = builder.voiceConnectorId;
        this.proxySessionId = builder.proxySessionId;
        this.capabilities = builder.capabilities;
        this.expiryMinutes = builder.expiryMinutes;
    }

    /**
     * <p>
     * The Voice Connector ID.
     * </p>
     * 
     * @return The Voice Connector ID.
     */
    public final String voiceConnectorId() {
        return voiceConnectorId;
    }

    /**
     * <p>
     * The proxy session ID.
     * </p>
     * 
     * @return The proxy session ID.
     */
    public final String proxySessionId() {
        return proxySessionId;
    }

    /**
     * <p>
     * The proxy session capabilities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return The proxy session capabilities.
     */
    public final List<Capability> capabilities() {
        return CapabilityListCopier.copyStringToEnum(capabilities);
    }

    /**
     * For responses, this returns true if the service returned a value for the Capabilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapabilities() {
        return capabilities != null && !(capabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The proxy session capabilities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return The proxy session capabilities.
     */
    public final List<String> capabilitiesAsStrings() {
        return capabilities;
    }

    /**
     * <p>
     * The number of minutes allowed for the proxy session.
     * </p>
     * 
     * @return The number of minutes allowed for the proxy session.
     */
    public final Integer expiryMinutes() {
        return expiryMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(proxySessionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilities() ? capabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(expiryMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProxySessionRequest)) {
            return false;
        }
        UpdateProxySessionRequest other = (UpdateProxySessionRequest) obj;
        return Objects.equals(voiceConnectorId(), other.voiceConnectorId())
                && Objects.equals(proxySessionId(), other.proxySessionId()) && hasCapabilities() == other.hasCapabilities()
                && Objects.equals(capabilitiesAsStrings(), other.capabilitiesAsStrings())
                && Objects.equals(expiryMinutes(), other.expiryMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProxySessionRequest").add("VoiceConnectorId", voiceConnectorId())
                .add("ProxySessionId", proxySessionId()).add("Capabilities", hasCapabilities() ? capabilitiesAsStrings() : null)
                .add("ExpiryMinutes", expiryMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceConnectorId":
            return Optional.ofNullable(clazz.cast(voiceConnectorId()));
        case "ProxySessionId":
            return Optional.ofNullable(clazz.cast(proxySessionId()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilitiesAsStrings()));
        case "ExpiryMinutes":
            return Optional.ofNullable(clazz.cast(expiryMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("voiceConnectorId", VOICE_CONNECTOR_ID_FIELD);
        map.put("proxySessionId", PROXY_SESSION_ID_FIELD);
        map.put("Capabilities", CAPABILITIES_FIELD);
        map.put("ExpiryMinutes", EXPIRY_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProxySessionRequest, T> g) {
        return obj -> g.apply((UpdateProxySessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ChimeSdkVoiceRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProxySessionRequest> {
        /**
         * <p>
         * The Voice Connector ID.
         * </p>
         * 
         * @param voiceConnectorId
         *        The Voice Connector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorId(String voiceConnectorId);

        /**
         * <p>
         * The proxy session ID.
         * </p>
         * 
         * @param proxySessionId
         *        The proxy session ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxySessionId(String proxySessionId);

        /**
         * <p>
         * The proxy session capabilities.
         * </p>
         * 
         * @param capabilities
         *        The proxy session capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(Collection<String> capabilities);

        /**
         * <p>
         * The proxy session capabilities.
         * </p>
         * 
         * @param capabilities
         *        The proxy session capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(String... capabilities);

        /**
         * <p>
         * The proxy session capabilities.
         * </p>
         * 
         * @param capabilities
         *        The proxy session capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<Capability> capabilities);

        /**
         * <p>
         * The proxy session capabilities.
         * </p>
         * 
         * @param capabilities
         *        The proxy session capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Capability... capabilities);

        /**
         * <p>
         * The number of minutes allowed for the proxy session.
         * </p>
         * 
         * @param expiryMinutes
         *        The number of minutes allowed for the proxy session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiryMinutes(Integer expiryMinutes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkVoiceRequest.BuilderImpl implements Builder {
        private String voiceConnectorId;

        private String proxySessionId;

        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();

        private Integer expiryMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProxySessionRequest model) {
            super(model);
            voiceConnectorId(model.voiceConnectorId);
            proxySessionId(model.proxySessionId);
            capabilitiesWithStrings(model.capabilities);
            expiryMinutes(model.expiryMinutes);
        }

        public final String getVoiceConnectorId() {
            return voiceConnectorId;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final String getProxySessionId() {
            return proxySessionId;
        }

        public final void setProxySessionId(String proxySessionId) {
            this.proxySessionId = proxySessionId;
        }

        @Override
        public final Builder proxySessionId(String proxySessionId) {
            this.proxySessionId = proxySessionId;
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilityListCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilityListCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String... capabilities) {
            capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<Capability> capabilities) {
            this.capabilities = CapabilityListCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final Integer getExpiryMinutes() {
            return expiryMinutes;
        }

        public final void setExpiryMinutes(Integer expiryMinutes) {
            this.expiryMinutes = expiryMinutes;
        }

        @Override
        public final Builder expiryMinutes(Integer expiryMinutes) {
            this.expiryMinutes = expiryMinutes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProxySessionRequest build() {
            return new UpdateProxySessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
