/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSipRuleRequest extends ChimeSdkVoiceRequest implements
        ToCopyableBuilder<UpdateSipRuleRequest.Builder, UpdateSipRuleRequest> {
    private static final SdkField<String> SIP_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SipRuleId").getter(getter(UpdateSipRuleRequest::sipRuleId)).setter(setter(Builder::sipRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sipRuleId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateSipRuleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Disabled").getter(getter(UpdateSipRuleRequest::disabled)).setter(setter(Builder::disabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()).build();

    private static final SdkField<List<SipRuleTargetApplication>> TARGET_APPLICATIONS_FIELD = SdkField
            .<List<SipRuleTargetApplication>> builder(MarshallingType.LIST)
            .memberName("TargetApplications")
            .getter(getter(UpdateSipRuleRequest::targetApplications))
            .setter(setter(Builder::targetApplications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetApplications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SipRuleTargetApplication> builder(MarshallingType.SDK_POJO)
                                            .constructor(SipRuleTargetApplication::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIP_RULE_ID_FIELD, NAME_FIELD,
            DISABLED_FIELD, TARGET_APPLICATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sipRuleId;

    private final String name;

    private final Boolean disabled;

    private final List<SipRuleTargetApplication> targetApplications;

    private UpdateSipRuleRequest(BuilderImpl builder) {
        super(builder);
        this.sipRuleId = builder.sipRuleId;
        this.name = builder.name;
        this.disabled = builder.disabled;
        this.targetApplications = builder.targetApplications;
    }

    /**
     * <p>
     * The SIP rule ID.
     * </p>
     * 
     * @return The SIP rule ID.
     */
    public final String sipRuleId() {
        return sipRuleId;
    }

    /**
     * <p>
     * The new name for the specified SIP rule.
     * </p>
     * 
     * @return The new name for the specified SIP rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The new value that indicates whether the rule is disabled.
     * </p>
     * 
     * @return The new value that indicates whether the rule is disabled.
     */
    public final Boolean disabled() {
        return disabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetApplications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetApplications() {
        return targetApplications != null && !(targetApplications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The new list of target applications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetApplications} method.
     * </p>
     * 
     * @return The new list of target applications.
     */
    public final List<SipRuleTargetApplication> targetApplications() {
        return targetApplications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sipRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(disabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetApplications() ? targetApplications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSipRuleRequest)) {
            return false;
        }
        UpdateSipRuleRequest other = (UpdateSipRuleRequest) obj;
        return Objects.equals(sipRuleId(), other.sipRuleId()) && Objects.equals(name(), other.name())
                && Objects.equals(disabled(), other.disabled()) && hasTargetApplications() == other.hasTargetApplications()
                && Objects.equals(targetApplications(), other.targetApplications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSipRuleRequest").add("SipRuleId", sipRuleId()).add("Name", name())
                .add("Disabled", disabled()).add("TargetApplications", hasTargetApplications() ? targetApplications() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SipRuleId":
            return Optional.ofNullable(clazz.cast(sipRuleId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Disabled":
            return Optional.ofNullable(clazz.cast(disabled()));
        case "TargetApplications":
            return Optional.ofNullable(clazz.cast(targetApplications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sipRuleId", SIP_RULE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Disabled", DISABLED_FIELD);
        map.put("TargetApplications", TARGET_APPLICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSipRuleRequest, T> g) {
        return obj -> g.apply((UpdateSipRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ChimeSdkVoiceRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSipRuleRequest> {
        /**
         * <p>
         * The SIP rule ID.
         * </p>
         * 
         * @param sipRuleId
         *        The SIP rule ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sipRuleId(String sipRuleId);

        /**
         * <p>
         * The new name for the specified SIP rule.
         * </p>
         * 
         * @param name
         *        The new name for the specified SIP rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The new value that indicates whether the rule is disabled.
         * </p>
         * 
         * @param disabled
         *        The new value that indicates whether the rule is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabled(Boolean disabled);

        /**
         * <p>
         * The new list of target applications.
         * </p>
         * 
         * @param targetApplications
         *        The new list of target applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetApplications(Collection<SipRuleTargetApplication> targetApplications);

        /**
         * <p>
         * The new list of target applications.
         * </p>
         * 
         * @param targetApplications
         *        The new list of target applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetApplications(SipRuleTargetApplication... targetApplications);

        /**
         * <p>
         * The new list of target applications.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.SipRuleTargetApplication.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.SipRuleTargetApplication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.SipRuleTargetApplication.Builder#build()} is
         * called immediately and its result is passed to {@link #targetApplications(List<SipRuleTargetApplication>)}.
         * 
         * @param targetApplications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkvoice.model.SipRuleTargetApplication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetApplications(java.util.Collection<SipRuleTargetApplication>)
         */
        Builder targetApplications(Consumer<SipRuleTargetApplication.Builder>... targetApplications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkVoiceRequest.BuilderImpl implements Builder {
        private String sipRuleId;

        private String name;

        private Boolean disabled;

        private List<SipRuleTargetApplication> targetApplications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSipRuleRequest model) {
            super(model);
            sipRuleId(model.sipRuleId);
            name(model.name);
            disabled(model.disabled);
            targetApplications(model.targetApplications);
        }

        public final String getSipRuleId() {
            return sipRuleId;
        }

        public final void setSipRuleId(String sipRuleId) {
            this.sipRuleId = sipRuleId;
        }

        @Override
        public final Builder sipRuleId(String sipRuleId) {
            this.sipRuleId = sipRuleId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getDisabled() {
            return disabled;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public final List<SipRuleTargetApplication.Builder> getTargetApplications() {
            List<SipRuleTargetApplication.Builder> result = SipRuleTargetApplicationListCopier
                    .copyToBuilder(this.targetApplications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetApplications(Collection<SipRuleTargetApplication.BuilderImpl> targetApplications) {
            this.targetApplications = SipRuleTargetApplicationListCopier.copyFromBuilder(targetApplications);
        }

        @Override
        public final Builder targetApplications(Collection<SipRuleTargetApplication> targetApplications) {
            this.targetApplications = SipRuleTargetApplicationListCopier.copy(targetApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetApplications(SipRuleTargetApplication... targetApplications) {
            targetApplications(Arrays.asList(targetApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetApplications(Consumer<SipRuleTargetApplication.Builder>... targetApplications) {
            targetApplications(Stream.of(targetApplications)
                    .map(c -> SipRuleTargetApplication.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSipRuleRequest build() {
            return new UpdateSipRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
