/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Chime SDK Voice Connector settings. Includes any Amazon S3 buckets designated for storing call detail
 * records.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VoiceConnectorSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<VoiceConnectorSettings.Builder, VoiceConnectorSettings> {
    private static final SdkField<String> CDR_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CdrBucket").getter(getter(VoiceConnectorSettings::cdrBucket)).setter(setter(Builder::cdrBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdrBucket").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CDR_BUCKET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cdrBucket;

    private VoiceConnectorSettings(BuilderImpl builder) {
        this.cdrBucket = builder.cdrBucket;
    }

    /**
     * <p>
     * The S3 bucket that stores the Voice Connector's call detail records.
     * </p>
     * 
     * @return The S3 bucket that stores the Voice Connector's call detail records.
     */
    public final String cdrBucket() {
        return cdrBucket;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cdrBucket());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceConnectorSettings)) {
            return false;
        }
        VoiceConnectorSettings other = (VoiceConnectorSettings) obj;
        return Objects.equals(cdrBucket(), other.cdrBucket());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VoiceConnectorSettings").add("CdrBucket", cdrBucket()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CdrBucket":
            return Optional.ofNullable(clazz.cast(cdrBucket()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CdrBucket", CDR_BUCKET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VoiceConnectorSettings, T> g) {
        return obj -> g.apply((VoiceConnectorSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VoiceConnectorSettings> {
        /**
         * <p>
         * The S3 bucket that stores the Voice Connector's call detail records.
         * </p>
         * 
         * @param cdrBucket
         *        The S3 bucket that stores the Voice Connector's call detail records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdrBucket(String cdrBucket);
    }

    static final class BuilderImpl implements Builder {
        private String cdrBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceConnectorSettings model) {
            cdrBucket(model.cdrBucket);
        }

        public final String getCdrBucket() {
            return cdrBucket;
        }

        public final void setCdrBucket(String cdrBucket) {
            this.cdrBucket = cdrBucket;
        }

        @Override
        public final Builder cdrBucket(String cdrBucket) {
            this.cdrBucket = cdrBucket;
            return this;
        }

        @Override
        public VoiceConnectorSettings build() {
            return new VoiceConnectorSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
