/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The combination of a voice print and caller ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VoiceProfile implements SdkPojo, Serializable, ToCopyableBuilder<VoiceProfile.Builder, VoiceProfile> {
    private static final SdkField<String> VOICE_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceProfileId").getter(getter(VoiceProfile::voiceProfileId)).setter(setter(Builder::voiceProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceProfileId").build()).build();

    private static final SdkField<String> VOICE_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceProfileArn").getter(getter(VoiceProfile::voiceProfileArn)).setter(setter(Builder::voiceProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceProfileArn").build()).build();

    private static final SdkField<String> VOICE_PROFILE_DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceProfileDomainId").getter(getter(VoiceProfile::voiceProfileDomainId))
            .setter(setter(Builder::voiceProfileDomainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceProfileDomainId").build())
            .build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp")
            .getter(getter(VoiceProfile::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp")
            .getter(getter(VoiceProfile::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> EXPIRATION_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpirationTimestamp")
            .getter(getter(VoiceProfile::expirationTimestamp))
            .setter(setter(Builder::expirationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_PROFILE_ID_FIELD,
            VOICE_PROFILE_ARN_FIELD, VOICE_PROFILE_DOMAIN_ID_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD,
            EXPIRATION_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String voiceProfileId;

    private final String voiceProfileArn;

    private final String voiceProfileDomainId;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private final Instant expirationTimestamp;

    private VoiceProfile(BuilderImpl builder) {
        this.voiceProfileId = builder.voiceProfileId;
        this.voiceProfileArn = builder.voiceProfileArn;
        this.voiceProfileDomainId = builder.voiceProfileDomainId;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
        this.expirationTimestamp = builder.expirationTimestamp;
    }

    /**
     * <p>
     * The ID of the voice profile.
     * </p>
     * 
     * @return The ID of the voice profile.
     */
    public final String voiceProfileId() {
        return voiceProfileId;
    }

    /**
     * <p>
     * The ARN of the voice profile.
     * </p>
     * 
     * @return The ARN of the voice profile.
     */
    public final String voiceProfileArn() {
        return voiceProfileArn;
    }

    /**
     * <p>
     * The ID of the domain that contains the voice profile.
     * </p>
     * 
     * @return The ID of the domain that contains the voice profile.
     */
    public final String voiceProfileDomainId() {
        return voiceProfileDomainId;
    }

    /**
     * <p>
     * The time at which the voice profile was created and enrolled.
     * </p>
     * 
     * @return The time at which the voice profile was created and enrolled.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The time at which the voice profile was last updated.
     * </p>
     * 
     * @return The time at which the voice profile was last updated.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    /**
     * <p>
     * The time at which a voice profile expires unless you re-enroll the caller via the <code>UpdateVoiceProfile</code>
     * API.
     * </p>
     * 
     * @return The time at which a voice profile expires unless you re-enroll the caller via the
     *         <code>UpdateVoiceProfile</code> API.
     */
    public final Instant expirationTimestamp() {
        return expirationTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(voiceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(voiceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(voiceProfileDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceProfile)) {
            return false;
        }
        VoiceProfile other = (VoiceProfile) obj;
        return Objects.equals(voiceProfileId(), other.voiceProfileId())
                && Objects.equals(voiceProfileArn(), other.voiceProfileArn())
                && Objects.equals(voiceProfileDomainId(), other.voiceProfileDomainId())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp())
                && Objects.equals(expirationTimestamp(), other.expirationTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VoiceProfile").add("VoiceProfileId", voiceProfileId())
                .add("VoiceProfileArn", voiceProfileArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("VoiceProfileDomainId", voiceProfileDomainId()).add("CreatedTimestamp", createdTimestamp())
                .add("UpdatedTimestamp", updatedTimestamp()).add("ExpirationTimestamp", expirationTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceProfileId":
            return Optional.ofNullable(clazz.cast(voiceProfileId()));
        case "VoiceProfileArn":
            return Optional.ofNullable(clazz.cast(voiceProfileArn()));
        case "VoiceProfileDomainId":
            return Optional.ofNullable(clazz.cast(voiceProfileDomainId()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        case "ExpirationTimestamp":
            return Optional.ofNullable(clazz.cast(expirationTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VoiceProfileId", VOICE_PROFILE_ID_FIELD);
        map.put("VoiceProfileArn", VOICE_PROFILE_ARN_FIELD);
        map.put("VoiceProfileDomainId", VOICE_PROFILE_DOMAIN_ID_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        map.put("ExpirationTimestamp", EXPIRATION_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VoiceProfile, T> g) {
        return obj -> g.apply((VoiceProfile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VoiceProfile> {
        /**
         * <p>
         * The ID of the voice profile.
         * </p>
         * 
         * @param voiceProfileId
         *        The ID of the voice profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceProfileId(String voiceProfileId);

        /**
         * <p>
         * The ARN of the voice profile.
         * </p>
         * 
         * @param voiceProfileArn
         *        The ARN of the voice profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceProfileArn(String voiceProfileArn);

        /**
         * <p>
         * The ID of the domain that contains the voice profile.
         * </p>
         * 
         * @param voiceProfileDomainId
         *        The ID of the domain that contains the voice profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceProfileDomainId(String voiceProfileDomainId);

        /**
         * <p>
         * The time at which the voice profile was created and enrolled.
         * </p>
         * 
         * @param createdTimestamp
         *        The time at which the voice profile was created and enrolled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The time at which the voice profile was last updated.
         * </p>
         * 
         * @param updatedTimestamp
         *        The time at which the voice profile was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);

        /**
         * <p>
         * The time at which a voice profile expires unless you re-enroll the caller via the
         * <code>UpdateVoiceProfile</code> API.
         * </p>
         * 
         * @param expirationTimestamp
         *        The time at which a voice profile expires unless you re-enroll the caller via the
         *        <code>UpdateVoiceProfile</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTimestamp(Instant expirationTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String voiceProfileId;

        private String voiceProfileArn;

        private String voiceProfileDomainId;

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private Instant expirationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceProfile model) {
            voiceProfileId(model.voiceProfileId);
            voiceProfileArn(model.voiceProfileArn);
            voiceProfileDomainId(model.voiceProfileDomainId);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
            expirationTimestamp(model.expirationTimestamp);
        }

        public final String getVoiceProfileId() {
            return voiceProfileId;
        }

        public final void setVoiceProfileId(String voiceProfileId) {
            this.voiceProfileId = voiceProfileId;
        }

        @Override
        public final Builder voiceProfileId(String voiceProfileId) {
            this.voiceProfileId = voiceProfileId;
            return this;
        }

        public final String getVoiceProfileArn() {
            return voiceProfileArn;
        }

        public final void setVoiceProfileArn(String voiceProfileArn) {
            this.voiceProfileArn = voiceProfileArn;
        }

        @Override
        public final Builder voiceProfileArn(String voiceProfileArn) {
            this.voiceProfileArn = voiceProfileArn;
            return this;
        }

        public final String getVoiceProfileDomainId() {
            return voiceProfileDomainId;
        }

        public final void setVoiceProfileDomainId(String voiceProfileDomainId) {
            this.voiceProfileDomainId = voiceProfileDomainId;
        }

        @Override
        public final Builder voiceProfileDomainId(String voiceProfileDomainId) {
            this.voiceProfileDomainId = voiceProfileDomainId;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final Instant getExpirationTimestamp() {
            return expirationTimestamp;
        }

        public final void setExpirationTimestamp(Instant expirationTimestamp) {
            this.expirationTimestamp = expirationTimestamp;
        }

        @Override
        public final Builder expirationTimestamp(Instant expirationTimestamp) {
            this.expirationTimestamp = expirationTimestamp;
            return this;
        }

        @Override
        public VoiceProfile build() {
            return new VoiceProfile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
