/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdatePhoneNumberRequest extends ChimeSdkVoiceRequest implements
        ToCopyableBuilder<BatchUpdatePhoneNumberRequest.Builder, BatchUpdatePhoneNumberRequest> {
    private static final SdkField<List<UpdatePhoneNumberRequestItem>> UPDATE_PHONE_NUMBER_REQUEST_ITEMS_FIELD = SdkField
            .<List<UpdatePhoneNumberRequestItem>> builder(MarshallingType.LIST)
            .memberName("UpdatePhoneNumberRequestItems")
            .getter(getter(BatchUpdatePhoneNumberRequest::updatePhoneNumberRequestItems))
            .setter(setter(Builder::updatePhoneNumberRequestItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatePhoneNumberRequestItems")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpdatePhoneNumberRequestItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdatePhoneNumberRequestItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(UPDATE_PHONE_NUMBER_REQUEST_ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<UpdatePhoneNumberRequestItem> updatePhoneNumberRequestItems;

    private BatchUpdatePhoneNumberRequest(BuilderImpl builder) {
        super(builder);
        this.updatePhoneNumberRequestItems = builder.updatePhoneNumberRequestItems;
    }

    /**
     * For responses, this returns true if the service returned a value for the UpdatePhoneNumberRequestItems property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUpdatePhoneNumberRequestItems() {
        return updatePhoneNumberRequestItems != null && !(updatePhoneNumberRequestItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the phone numbers in the update request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpdatePhoneNumberRequestItems} method.
     * </p>
     * 
     * @return Lists the phone numbers in the update request.
     */
    public final List<UpdatePhoneNumberRequestItem> updatePhoneNumberRequestItems() {
        return updatePhoneNumberRequestItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUpdatePhoneNumberRequestItems() ? updatePhoneNumberRequestItems() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdatePhoneNumberRequest)) {
            return false;
        }
        BatchUpdatePhoneNumberRequest other = (BatchUpdatePhoneNumberRequest) obj;
        return hasUpdatePhoneNumberRequestItems() == other.hasUpdatePhoneNumberRequestItems()
                && Objects.equals(updatePhoneNumberRequestItems(), other.updatePhoneNumberRequestItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("BatchUpdatePhoneNumberRequest")
                .add("UpdatePhoneNumberRequestItems", hasUpdatePhoneNumberRequestItems() ? updatePhoneNumberRequestItems() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpdatePhoneNumberRequestItems":
            return Optional.ofNullable(clazz.cast(updatePhoneNumberRequestItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UpdatePhoneNumberRequestItems", UPDATE_PHONE_NUMBER_REQUEST_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdatePhoneNumberRequest, T> g) {
        return obj -> g.apply((BatchUpdatePhoneNumberRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ChimeSdkVoiceRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchUpdatePhoneNumberRequest> {
        /**
         * <p>
         * Lists the phone numbers in the update request.
         * </p>
         * 
         * @param updatePhoneNumberRequestItems
         *        Lists the phone numbers in the update request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatePhoneNumberRequestItems(Collection<UpdatePhoneNumberRequestItem> updatePhoneNumberRequestItems);

        /**
         * <p>
         * Lists the phone numbers in the update request.
         * </p>
         * 
         * @param updatePhoneNumberRequestItems
         *        Lists the phone numbers in the update request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatePhoneNumberRequestItems(UpdatePhoneNumberRequestItem... updatePhoneNumberRequestItems);

        /**
         * <p>
         * Lists the phone numbers in the update request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberRequestItem.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberRequestItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberRequestItem.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #updatePhoneNumberRequestItems(List<UpdatePhoneNumberRequestItem>)}.
         * 
         * @param updatePhoneNumberRequestItems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberRequestItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updatePhoneNumberRequestItems(java.util.Collection<UpdatePhoneNumberRequestItem>)
         */
        Builder updatePhoneNumberRequestItems(Consumer<UpdatePhoneNumberRequestItem.Builder>... updatePhoneNumberRequestItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkVoiceRequest.BuilderImpl implements Builder {
        private List<UpdatePhoneNumberRequestItem> updatePhoneNumberRequestItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdatePhoneNumberRequest model) {
            super(model);
            updatePhoneNumberRequestItems(model.updatePhoneNumberRequestItems);
        }

        public final List<UpdatePhoneNumberRequestItem.Builder> getUpdatePhoneNumberRequestItems() {
            List<UpdatePhoneNumberRequestItem.Builder> result = UpdatePhoneNumberRequestItemListCopier
                    .copyToBuilder(this.updatePhoneNumberRequestItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdatePhoneNumberRequestItems(
                Collection<UpdatePhoneNumberRequestItem.BuilderImpl> updatePhoneNumberRequestItems) {
            this.updatePhoneNumberRequestItems = UpdatePhoneNumberRequestItemListCopier
                    .copyFromBuilder(updatePhoneNumberRequestItems);
        }

        @Override
        public final Builder updatePhoneNumberRequestItems(Collection<UpdatePhoneNumberRequestItem> updatePhoneNumberRequestItems) {
            this.updatePhoneNumberRequestItems = UpdatePhoneNumberRequestItemListCopier.copy(updatePhoneNumberRequestItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updatePhoneNumberRequestItems(UpdatePhoneNumberRequestItem... updatePhoneNumberRequestItems) {
            updatePhoneNumberRequestItems(Arrays.asList(updatePhoneNumberRequestItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updatePhoneNumberRequestItems(
                Consumer<UpdatePhoneNumberRequestItem.Builder>... updatePhoneNumberRequestItems) {
            updatePhoneNumberRequestItems(Stream.of(updatePhoneNumberRequestItems)
                    .map(c -> UpdatePhoneNumberRequestItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdatePhoneNumberRequest build() {
            return new BatchUpdatePhoneNumberRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
