/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVoiceProfilesResponse extends ChimeSdkVoiceResponse implements
        ToCopyableBuilder<ListVoiceProfilesResponse.Builder, ListVoiceProfilesResponse> {
    private static final SdkField<List<VoiceProfileSummary>> VOICE_PROFILES_FIELD = SdkField
            .<List<VoiceProfileSummary>> builder(MarshallingType.LIST)
            .memberName("VoiceProfiles")
            .getter(getter(ListVoiceProfilesResponse::voiceProfiles))
            .setter(setter(Builder::voiceProfiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceProfiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VoiceProfileSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(VoiceProfileSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListVoiceProfilesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_PROFILES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<VoiceProfileSummary> voiceProfiles;

    private final String nextToken;

    private ListVoiceProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.voiceProfiles = builder.voiceProfiles;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the VoiceProfiles property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVoiceProfiles() {
        return voiceProfiles != null && !(voiceProfiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of voice profiles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVoiceProfiles} method.
     * </p>
     * 
     * @return The list of voice profiles.
     */
    public final List<VoiceProfileSummary> voiceProfiles() {
        return voiceProfiles;
    }

    /**
     * <p>
     * The token used to retrieve the next page of results.
     * </p>
     * 
     * @return The token used to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVoiceProfiles() ? voiceProfiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVoiceProfilesResponse)) {
            return false;
        }
        ListVoiceProfilesResponse other = (ListVoiceProfilesResponse) obj;
        return hasVoiceProfiles() == other.hasVoiceProfiles() && Objects.equals(voiceProfiles(), other.voiceProfiles())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVoiceProfilesResponse").add("VoiceProfiles", hasVoiceProfiles() ? voiceProfiles() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceProfiles":
            return Optional.ofNullable(clazz.cast(voiceProfiles()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VoiceProfiles", VOICE_PROFILES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVoiceProfilesResponse, T> g) {
        return obj -> g.apply((ListVoiceProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ChimeSdkVoiceResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListVoiceProfilesResponse> {
        /**
         * <p>
         * The list of voice profiles.
         * </p>
         * 
         * @param voiceProfiles
         *        The list of voice profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceProfiles(Collection<VoiceProfileSummary> voiceProfiles);

        /**
         * <p>
         * The list of voice profiles.
         * </p>
         * 
         * @param voiceProfiles
         *        The list of voice profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceProfiles(VoiceProfileSummary... voiceProfiles);

        /**
         * <p>
         * The list of voice profiles.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.VoiceProfileSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.VoiceProfileSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.VoiceProfileSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #voiceProfiles(List<VoiceProfileSummary>)}.
         * 
         * @param voiceProfiles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkvoice.model.VoiceProfileSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceProfiles(java.util.Collection<VoiceProfileSummary>)
         */
        Builder voiceProfiles(Consumer<VoiceProfileSummary.Builder>... voiceProfiles);

        /**
         * <p>
         * The token used to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token used to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChimeSdkVoiceResponse.BuilderImpl implements Builder {
        private List<VoiceProfileSummary> voiceProfiles = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVoiceProfilesResponse model) {
            super(model);
            voiceProfiles(model.voiceProfiles);
            nextToken(model.nextToken);
        }

        public final List<VoiceProfileSummary.Builder> getVoiceProfiles() {
            List<VoiceProfileSummary.Builder> result = VoiceProfileSummaryListCopier.copyToBuilder(this.voiceProfiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVoiceProfiles(Collection<VoiceProfileSummary.BuilderImpl> voiceProfiles) {
            this.voiceProfiles = VoiceProfileSummaryListCopier.copyFromBuilder(voiceProfiles);
        }

        @Override
        public final Builder voiceProfiles(Collection<VoiceProfileSummary> voiceProfiles) {
            this.voiceProfiles = VoiceProfileSummaryListCopier.copy(voiceProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voiceProfiles(VoiceProfileSummary... voiceProfiles) {
            voiceProfiles(Arrays.asList(voiceProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voiceProfiles(Consumer<VoiceProfileSummary.Builder>... voiceProfiles) {
            voiceProfiles(Stream.of(voiceProfiles).map(c -> VoiceProfileSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListVoiceProfilesResponse build() {
            return new ListVoiceProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
