/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A high-level overview of a voice profile domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VoiceProfileDomainSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<VoiceProfileDomainSummary.Builder, VoiceProfileDomainSummary> {
    private static final SdkField<String> VOICE_PROFILE_DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceProfileDomainId").getter(getter(VoiceProfileDomainSummary::voiceProfileDomainId))
            .setter(setter(Builder::voiceProfileDomainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceProfileDomainId").build())
            .build();

    private static final SdkField<String> VOICE_PROFILE_DOMAIN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceProfileDomainArn").getter(getter(VoiceProfileDomainSummary::voiceProfileDomainArn))
            .setter(setter(Builder::voiceProfileDomainArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceProfileDomainArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(VoiceProfileDomainSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(VoiceProfileDomainSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp")
            .getter(getter(VoiceProfileDomainSummary::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp")
            .getter(getter(VoiceProfileDomainSummary::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_PROFILE_DOMAIN_ID_FIELD,
            VOICE_PROFILE_DOMAIN_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String voiceProfileDomainId;

    private final String voiceProfileDomainArn;

    private final String name;

    private final String description;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private VoiceProfileDomainSummary(BuilderImpl builder) {
        this.voiceProfileDomainId = builder.voiceProfileDomainId;
        this.voiceProfileDomainArn = builder.voiceProfileDomainArn;
        this.name = builder.name;
        this.description = builder.description;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    /**
     * <p>
     * The ID of the voice profile domain summary.
     * </p>
     * 
     * @return The ID of the voice profile domain summary.
     */
    public final String voiceProfileDomainId() {
        return voiceProfileDomainId;
    }

    /**
     * <p>
     * The ARN of a voice profile in a voice profile domain summary.
     * </p>
     * 
     * @return The ARN of a voice profile in a voice profile domain summary.
     */
    public final String voiceProfileDomainArn() {
        return voiceProfileDomainArn;
    }

    /**
     * <p>
     * The name of the voice profile domain summary.
     * </p>
     * 
     * @return The name of the voice profile domain summary.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Describes the voice profile domain summary.
     * </p>
     * 
     * @return Describes the voice profile domain summary.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The time at which the voice profile domain summary was created.
     * </p>
     * 
     * @return The time at which the voice profile domain summary was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The time at which the voice profile domain summary was last updated.
     * </p>
     * 
     * @return The time at which the voice profile domain summary was last updated.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(voiceProfileDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(voiceProfileDomainArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceProfileDomainSummary)) {
            return false;
        }
        VoiceProfileDomainSummary other = (VoiceProfileDomainSummary) obj;
        return Objects.equals(voiceProfileDomainId(), other.voiceProfileDomainId())
                && Objects.equals(voiceProfileDomainArn(), other.voiceProfileDomainArn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VoiceProfileDomainSummary").add("VoiceProfileDomainId", voiceProfileDomainId())
                .add("VoiceProfileDomainArn", voiceProfileDomainArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Name", name()).add("Description", description()).add("CreatedTimestamp", createdTimestamp())
                .add("UpdatedTimestamp", updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceProfileDomainId":
            return Optional.ofNullable(clazz.cast(voiceProfileDomainId()));
        case "VoiceProfileDomainArn":
            return Optional.ofNullable(clazz.cast(voiceProfileDomainArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VoiceProfileDomainId", VOICE_PROFILE_DOMAIN_ID_FIELD);
        map.put("VoiceProfileDomainArn", VOICE_PROFILE_DOMAIN_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VoiceProfileDomainSummary, T> g) {
        return obj -> g.apply((VoiceProfileDomainSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VoiceProfileDomainSummary> {
        /**
         * <p>
         * The ID of the voice profile domain summary.
         * </p>
         * 
         * @param voiceProfileDomainId
         *        The ID of the voice profile domain summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceProfileDomainId(String voiceProfileDomainId);

        /**
         * <p>
         * The ARN of a voice profile in a voice profile domain summary.
         * </p>
         * 
         * @param voiceProfileDomainArn
         *        The ARN of a voice profile in a voice profile domain summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceProfileDomainArn(String voiceProfileDomainArn);

        /**
         * <p>
         * The name of the voice profile domain summary.
         * </p>
         * 
         * @param name
         *        The name of the voice profile domain summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Describes the voice profile domain summary.
         * </p>
         * 
         * @param description
         *        Describes the voice profile domain summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time at which the voice profile domain summary was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time at which the voice profile domain summary was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The time at which the voice profile domain summary was last updated.
         * </p>
         * 
         * @param updatedTimestamp
         *        The time at which the voice profile domain summary was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String voiceProfileDomainId;

        private String voiceProfileDomainArn;

        private String name;

        private String description;

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceProfileDomainSummary model) {
            voiceProfileDomainId(model.voiceProfileDomainId);
            voiceProfileDomainArn(model.voiceProfileDomainArn);
            name(model.name);
            description(model.description);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
        }

        public final String getVoiceProfileDomainId() {
            return voiceProfileDomainId;
        }

        public final void setVoiceProfileDomainId(String voiceProfileDomainId) {
            this.voiceProfileDomainId = voiceProfileDomainId;
        }

        @Override
        public final Builder voiceProfileDomainId(String voiceProfileDomainId) {
            this.voiceProfileDomainId = voiceProfileDomainId;
            return this;
        }

        public final String getVoiceProfileDomainArn() {
            return voiceProfileDomainArn;
        }

        public final void setVoiceProfileDomainArn(String voiceProfileDomainArn) {
            this.voiceProfileDomainArn = voiceProfileDomainArn;
        }

        @Override
        public final Builder voiceProfileDomainArn(String voiceProfileDomainArn) {
            this.voiceProfileDomainArn = voiceProfileDomainArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        @Override
        public VoiceProfileDomainSummary build() {
            return new VoiceProfileDomainSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
