/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The member object listed by the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemberSummary implements SdkPojo, Serializable, ToCopyableBuilder<MemberSummary.Builder, MemberSummary> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(MemberSummary::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(MemberSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(MemberSummary::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<List<String>> ABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("abilities")
            .getter(getter(MemberSummary::abilitiesAsStrings))
            .setter(setter(Builder::abilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("abilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(MemberSummary::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(MemberSummary::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipId").getter(getter(MemberSummary::membershipId)).setter(setter(Builder::membershipId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()).build();

    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipArn").getter(getter(MemberSummary::membershipArn)).setter(setter(Builder::membershipArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            STATUS_FIELD, DISPLAY_NAME_FIELD, ABILITIES_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, MEMBERSHIP_ID_FIELD,
            MEMBERSHIP_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String status;

    private final String displayName;

    private final List<String> abilities;

    private final Instant createTime;

    private final Instant updateTime;

    private final String membershipId;

    private final String membershipArn;

    private MemberSummary(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.status = builder.status;
        this.displayName = builder.displayName;
        this.abilities = builder.abilities;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.membershipId = builder.membershipId;
        this.membershipArn = builder.membershipArn;
    }

    /**
     * <p>
     * The identifier used to reference members of the collaboration. Currently only supports AWS Account ID.
     * </p>
     * 
     * @return The identifier used to reference members of the collaboration. Currently only supports AWS Account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The status of the member. Valid values are `INVITED`, `ACTIVE`, `LEFT`, and `REMOVED`.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MemberStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the member. Valid values are `INVITED`, `ACTIVE`, `LEFT`, and `REMOVED`.
     * @see MemberStatus
     */
    public final MemberStatus status() {
        return MemberStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the member. Valid values are `INVITED`, `ACTIVE`, `LEFT`, and `REMOVED`.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MemberStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the member. Valid values are `INVITED`, `ACTIVE`, `LEFT`, and `REMOVED`.
     * @see MemberStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The member's display name.
     * </p>
     * 
     * @return The member's display name.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The abilities granted to the collaboration member.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAbilities} method.
     * </p>
     * 
     * @return The abilities granted to the collaboration member.
     */
    public final List<MemberAbility> abilities() {
        return MemberAbilitiesCopier.copyStringToEnum(abilities);
    }

    /**
     * For responses, this returns true if the service returned a value for the Abilities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAbilities() {
        return abilities != null && !(abilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The abilities granted to the collaboration member.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAbilities} method.
     * </p>
     * 
     * @return The abilities granted to the collaboration member.
     */
    public final List<String> abilitiesAsStrings() {
        return abilities;
    }

    /**
     * <p>
     * The time when the member was created.
     * </p>
     * 
     * @return The time when the member was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The time the member metadata was last updated.
     * </p>
     * 
     * @return The time the member metadata was last updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The unique ID for the member's associated membership, if present.
     * </p>
     * 
     * @return The unique ID for the member's associated membership, if present.
     */
    public final String membershipId() {
        return membershipId;
    }

    /**
     * <p>
     * The unique ARN for the member's associated membership, if present.
     * </p>
     * 
     * @return The unique ARN for the member's associated membership, if present.
     */
    public final String membershipArn() {
        return membershipArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAbilities() ? abilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(membershipArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberSummary)) {
            return false;
        }
        MemberSummary other = (MemberSummary) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(displayName(), other.displayName()) && hasAbilities() == other.hasAbilities()
                && Objects.equals(abilitiesAsStrings(), other.abilitiesAsStrings())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(membershipId(), other.membershipId()) && Objects.equals(membershipArn(), other.membershipArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MemberSummary").add("AccountId", accountId()).add("Status", statusAsString())
                .add("DisplayName", displayName()).add("Abilities", hasAbilities() ? abilitiesAsStrings() : null)
                .add("CreateTime", createTime()).add("UpdateTime", updateTime()).add("MembershipId", membershipId())
                .add("MembershipArn", membershipArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "abilities":
            return Optional.ofNullable(clazz.cast(abilitiesAsStrings()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "membershipId":
            return Optional.ofNullable(clazz.cast(membershipId()));
        case "membershipArn":
            return Optional.ofNullable(clazz.cast(membershipArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemberSummary, T> g) {
        return obj -> g.apply((MemberSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemberSummary> {
        /**
         * <p>
         * The identifier used to reference members of the collaboration. Currently only supports AWS Account ID.
         * </p>
         * 
         * @param accountId
         *        The identifier used to reference members of the collaboration. Currently only supports AWS Account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The status of the member. Valid values are `INVITED`, `ACTIVE`, `LEFT`, and `REMOVED`.
         * </p>
         * 
         * @param status
         *        The status of the member. Valid values are `INVITED`, `ACTIVE`, `LEFT`, and `REMOVED`.
         * @see MemberStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the member. Valid values are `INVITED`, `ACTIVE`, `LEFT`, and `REMOVED`.
         * </p>
         * 
         * @param status
         *        The status of the member. Valid values are `INVITED`, `ACTIVE`, `LEFT`, and `REMOVED`.
         * @see MemberStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberStatus
         */
        Builder status(MemberStatus status);

        /**
         * <p>
         * The member's display name.
         * </p>
         * 
         * @param displayName
         *        The member's display name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The abilities granted to the collaboration member.
         * </p>
         * 
         * @param abilities
         *        The abilities granted to the collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abilitiesWithStrings(Collection<String> abilities);

        /**
         * <p>
         * The abilities granted to the collaboration member.
         * </p>
         * 
         * @param abilities
         *        The abilities granted to the collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abilitiesWithStrings(String... abilities);

        /**
         * <p>
         * The abilities granted to the collaboration member.
         * </p>
         * 
         * @param abilities
         *        The abilities granted to the collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abilities(Collection<MemberAbility> abilities);

        /**
         * <p>
         * The abilities granted to the collaboration member.
         * </p>
         * 
         * @param abilities
         *        The abilities granted to the collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abilities(MemberAbility... abilities);

        /**
         * <p>
         * The time when the member was created.
         * </p>
         * 
         * @param createTime
         *        The time when the member was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The time the member metadata was last updated.
         * </p>
         * 
         * @param updateTime
         *        The time the member metadata was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The unique ID for the member's associated membership, if present.
         * </p>
         * 
         * @param membershipId
         *        The unique ID for the member's associated membership, if present.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipId(String membershipId);

        /**
         * <p>
         * The unique ARN for the member's associated membership, if present.
         * </p>
         * 
         * @param membershipArn
         *        The unique ARN for the member's associated membership, if present.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipArn(String membershipArn);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String status;

        private String displayName;

        private List<String> abilities = DefaultSdkAutoConstructList.getInstance();

        private Instant createTime;

        private Instant updateTime;

        private String membershipId;

        private String membershipArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberSummary model) {
            accountId(model.accountId);
            status(model.status);
            displayName(model.displayName);
            abilitiesWithStrings(model.abilities);
            createTime(model.createTime);
            updateTime(model.updateTime);
            membershipId(model.membershipId);
            membershipArn(model.membershipArn);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MemberStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Collection<String> getAbilities() {
            if (abilities instanceof SdkAutoConstructList) {
                return null;
            }
            return abilities;
        }

        public final void setAbilities(Collection<String> abilities) {
            this.abilities = MemberAbilitiesCopier.copy(abilities);
        }

        @Override
        public final Builder abilitiesWithStrings(Collection<String> abilities) {
            this.abilities = MemberAbilitiesCopier.copy(abilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder abilitiesWithStrings(String... abilities) {
            abilitiesWithStrings(Arrays.asList(abilities));
            return this;
        }

        @Override
        public final Builder abilities(Collection<MemberAbility> abilities) {
            this.abilities = MemberAbilitiesCopier.copyEnumToString(abilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder abilities(MemberAbility... abilities) {
            abilities(Arrays.asList(abilities));
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getMembershipId() {
            return membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getMembershipArn() {
            return membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        @Override
        public MemberSummary build() {
            return new MemberSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
