/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the configured audience model association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfiguredAudienceModelAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfiguredAudienceModelAssociation.Builder, ConfiguredAudienceModelAssociation> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ConfiguredAudienceModelAssociation::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ConfiguredAudienceModelAssociation::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredAudienceModelArn")
            .getter(getter(ConfiguredAudienceModelAssociation::configuredAudienceModelArn))
            .setter(setter(Builder::configuredAudienceModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredAudienceModelArn").build())
            .build();

    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipId").getter(getter(ConfiguredAudienceModelAssociation::membershipId))
            .setter(setter(Builder::membershipId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()).build();

    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipArn").getter(getter(ConfiguredAudienceModelAssociation::membershipArn))
            .setter(setter(Builder::membershipArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()).build();

    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationId").getter(getter(ConfiguredAudienceModelAssociation::collaborationId))
            .setter(setter(Builder::collaborationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()).build();

    private static final SdkField<String> COLLABORATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationArn").getter(getter(ConfiguredAudienceModelAssociation::collaborationArn))
            .setter(setter(Builder::collaborationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ConfiguredAudienceModelAssociation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Boolean> MANAGE_RESOURCE_POLICIES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("manageResourcePolicies").getter(getter(ConfiguredAudienceModelAssociation::manageResourcePolicies))
            .setter(setter(Builder::manageResourcePolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manageResourcePolicies").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ConfiguredAudienceModelAssociation::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(ConfiguredAudienceModelAssociation::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(ConfiguredAudienceModelAssociation::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            CONFIGURED_AUDIENCE_MODEL_ARN_FIELD, MEMBERSHIP_ID_FIELD, MEMBERSHIP_ARN_FIELD, COLLABORATION_ID_FIELD,
            COLLABORATION_ARN_FIELD, NAME_FIELD, MANAGE_RESOURCE_POLICIES_FIELD, DESCRIPTION_FIELD, CREATE_TIME_FIELD,
            UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String configuredAudienceModelArn;

    private final String membershipId;

    private final String membershipArn;

    private final String collaborationId;

    private final String collaborationArn;

    private final String name;

    private final Boolean manageResourcePolicies;

    private final String description;

    private final Instant createTime;

    private final Instant updateTime;

    private ConfiguredAudienceModelAssociation(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.configuredAudienceModelArn = builder.configuredAudienceModelArn;
        this.membershipId = builder.membershipId;
        this.membershipArn = builder.membershipArn;
        this.collaborationId = builder.collaborationId;
        this.collaborationArn = builder.collaborationArn;
        this.name = builder.name;
        this.manageResourcePolicies = builder.manageResourcePolicies;
        this.description = builder.description;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * A unique identifier of the configured audience model association.
     * </p>
     * 
     * @return A unique identifier of the configured audience model association.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configured audience model association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configured audience model association.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configured audience model that was used for this configured audience model
     * association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configured audience model that was used for this configured
     *         audience model association.
     */
    public final String configuredAudienceModelArn() {
        return configuredAudienceModelArn;
    }

    /**
     * <p>
     * A unique identifier for the membership that contains this configured audience model association.
     * </p>
     * 
     * @return A unique identifier for the membership that contains this configured audience model association.
     */
    public final String membershipId() {
        return membershipId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the membership that contains this configured audience model association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the membership that contains this configured audience model
     *         association.
     */
    public final String membershipArn() {
        return membershipArn;
    }

    /**
     * <p>
     * A unique identifier of the collaboration that contains this configured audience model association.
     * </p>
     * 
     * @return A unique identifier of the collaboration that contains this configured audience model association.
     */
    public final String collaborationId() {
        return collaborationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the collaboration that contains this configured audience model association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the collaboration that contains this configured audience model
     *         association.
     */
    public final String collaborationArn() {
        return collaborationArn;
    }

    /**
     * <p>
     * The name of the configured audience model association.
     * </p>
     * 
     * @return The name of the configured audience model association.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * When <code>TRUE</code>, indicates that the resource policy for the configured audience model resource being
     * associated is configured for Clean Rooms to manage permissions related to the given collaboration. When
     * <code>FALSE</code>, indicates that the configured audience model resource owner will manage permissions related
     * to the given collaboration.
     * </p>
     * 
     * @return When <code>TRUE</code>, indicates that the resource policy for the configured audience model resource
     *         being associated is configured for Clean Rooms to manage permissions related to the given collaboration.
     *         When <code>FALSE</code>, indicates that the configured audience model resource owner will manage
     *         permissions related to the given collaboration.
     */
    public final Boolean manageResourcePolicies() {
        return manageResourcePolicies;
    }

    /**
     * <p>
     * The description of the configured audience model association.
     * </p>
     * 
     * @return The description of the configured audience model association.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The time at which the configured audience model association was created.
     * </p>
     * 
     * @return The time at which the configured audience model association was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the configured audience model association was updated.
     * </p>
     * 
     * @return The most recent time at which the configured audience model association was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(configuredAudienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(manageResourcePolicies());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfiguredAudienceModelAssociation)) {
            return false;
        }
        ConfiguredAudienceModelAssociation other = (ConfiguredAudienceModelAssociation) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(configuredAudienceModelArn(), other.configuredAudienceModelArn())
                && Objects.equals(membershipId(), other.membershipId()) && Objects.equals(membershipArn(), other.membershipArn())
                && Objects.equals(collaborationId(), other.collaborationId())
                && Objects.equals(collaborationArn(), other.collaborationArn()) && Objects.equals(name(), other.name())
                && Objects.equals(manageResourcePolicies(), other.manageResourcePolicies())
                && Objects.equals(description(), other.description()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfiguredAudienceModelAssociation").add("Id", id()).add("Arn", arn())
                .add("ConfiguredAudienceModelArn", configuredAudienceModelArn()).add("MembershipId", membershipId())
                .add("MembershipArn", membershipArn()).add("CollaborationId", collaborationId())
                .add("CollaborationArn", collaborationArn()).add("Name", name())
                .add("ManageResourcePolicies", manageResourcePolicies()).add("Description", description())
                .add("CreateTime", createTime()).add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "configuredAudienceModelArn":
            return Optional.ofNullable(clazz.cast(configuredAudienceModelArn()));
        case "membershipId":
            return Optional.ofNullable(clazz.cast(membershipId()));
        case "membershipArn":
            return Optional.ofNullable(clazz.cast(membershipArn()));
        case "collaborationId":
            return Optional.ofNullable(clazz.cast(collaborationId()));
        case "collaborationArn":
            return Optional.ofNullable(clazz.cast(collaborationArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "manageResourcePolicies":
            return Optional.ofNullable(clazz.cast(manageResourcePolicies()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfiguredAudienceModelAssociation, T> g) {
        return obj -> g.apply((ConfiguredAudienceModelAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfiguredAudienceModelAssociation> {
        /**
         * <p>
         * A unique identifier of the configured audience model association.
         * </p>
         * 
         * @param id
         *        A unique identifier of the configured audience model association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configured audience model association.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the configured audience model association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configured audience model that was used for this configured audience
         * model association.
         * </p>
         * 
         * @param configuredAudienceModelArn
         *        The Amazon Resource Name (ARN) of the configured audience model that was used for this configured
         *        audience model association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredAudienceModelArn(String configuredAudienceModelArn);

        /**
         * <p>
         * A unique identifier for the membership that contains this configured audience model association.
         * </p>
         * 
         * @param membershipId
         *        A unique identifier for the membership that contains this configured audience model association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipId(String membershipId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the membership that contains this configured audience model association.
         * </p>
         * 
         * @param membershipArn
         *        The Amazon Resource Name (ARN) of the membership that contains this configured audience model
         *        association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipArn(String membershipArn);

        /**
         * <p>
         * A unique identifier of the collaboration that contains this configured audience model association.
         * </p>
         * 
         * @param collaborationId
         *        A unique identifier of the collaboration that contains this configured audience model association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationId(String collaborationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the collaboration that contains this configured audience model association.
         * </p>
         * 
         * @param collaborationArn
         *        The Amazon Resource Name (ARN) of the collaboration that contains this configured audience model
         *        association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationArn(String collaborationArn);

        /**
         * <p>
         * The name of the configured audience model association.
         * </p>
         * 
         * @param name
         *        The name of the configured audience model association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * When <code>TRUE</code>, indicates that the resource policy for the configured audience model resource being
         * associated is configured for Clean Rooms to manage permissions related to the given collaboration. When
         * <code>FALSE</code>, indicates that the configured audience model resource owner will manage permissions
         * related to the given collaboration.
         * </p>
         * 
         * @param manageResourcePolicies
         *        When <code>TRUE</code>, indicates that the resource policy for the configured audience model resource
         *        being associated is configured for Clean Rooms to manage permissions related to the given
         *        collaboration. When <code>FALSE</code>, indicates that the configured audience model resource owner
         *        will manage permissions related to the given collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manageResourcePolicies(Boolean manageResourcePolicies);

        /**
         * <p>
         * The description of the configured audience model association.
         * </p>
         * 
         * @param description
         *        The description of the configured audience model association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time at which the configured audience model association was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the configured audience model association was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the configured audience model association was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the configured audience model association was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String configuredAudienceModelArn;

        private String membershipId;

        private String membershipArn;

        private String collaborationId;

        private String collaborationArn;

        private String name;

        private Boolean manageResourcePolicies;

        private String description;

        private Instant createTime;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfiguredAudienceModelAssociation model) {
            id(model.id);
            arn(model.arn);
            configuredAudienceModelArn(model.configuredAudienceModelArn);
            membershipId(model.membershipId);
            membershipArn(model.membershipArn);
            collaborationId(model.collaborationId);
            collaborationArn(model.collaborationArn);
            name(model.name);
            manageResourcePolicies(model.manageResourcePolicies);
            description(model.description);
            createTime(model.createTime);
            updateTime(model.updateTime);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getConfiguredAudienceModelArn() {
            return configuredAudienceModelArn;
        }

        public final void setConfiguredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
        }

        @Override
        public final Builder configuredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
            return this;
        }

        public final String getMembershipId() {
            return membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getMembershipArn() {
            return membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final String getCollaborationId() {
            return collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getCollaborationArn() {
            return collaborationArn;
        }

        public final void setCollaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
        }

        @Override
        public final Builder collaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getManageResourcePolicies() {
            return manageResourcePolicies;
        }

        public final void setManageResourcePolicies(Boolean manageResourcePolicies) {
            this.manageResourcePolicies = manageResourcePolicies;
        }

        @Override
        public final Builder manageResourcePolicies(Boolean manageResourcePolicies) {
            this.manageResourcePolicies = manageResourcePolicies;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public ConfiguredAudienceModelAssociation build() {
            return new ConfiguredAudienceModelAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
