/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePrivacyBudgetTemplateRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<DeletePrivacyBudgetTemplateRequest.Builder, DeletePrivacyBudgetTemplateRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(DeletePrivacyBudgetTemplateRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final SdkField<String> PRIVACY_BUDGET_TEMPLATE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("privacyBudgetTemplateIdentifier")
            .getter(getter(DeletePrivacyBudgetTemplateRequest::privacyBudgetTemplateIdentifier))
            .setter(setter(Builder::privacyBudgetTemplateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("privacyBudgetTemplateIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD,
            PRIVACY_BUDGET_TEMPLATE_IDENTIFIER_FIELD));

    private final String membershipIdentifier;

    private final String privacyBudgetTemplateIdentifier;

    private DeletePrivacyBudgetTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.privacyBudgetTemplateIdentifier = builder.privacyBudgetTemplateIdentifier;
    }

    /**
     * <p>
     * A unique identifier for one of your memberships for a collaboration. The privacy budget template is deleted from
     * the collaboration that this membership belongs to. Accepts a membership ID.
     * </p>
     * 
     * @return A unique identifier for one of your memberships for a collaboration. The privacy budget template is
     *         deleted from the collaboration that this membership belongs to. Accepts a membership ID.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * A unique identifier for your privacy budget template.
     * </p>
     * 
     * @return A unique identifier for your privacy budget template.
     */
    public final String privacyBudgetTemplateIdentifier() {
        return privacyBudgetTemplateIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(privacyBudgetTemplateIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePrivacyBudgetTemplateRequest)) {
            return false;
        }
        DeletePrivacyBudgetTemplateRequest other = (DeletePrivacyBudgetTemplateRequest) obj;
        return Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(privacyBudgetTemplateIdentifier(), other.privacyBudgetTemplateIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeletePrivacyBudgetTemplateRequest").add("MembershipIdentifier", membershipIdentifier())
                .add("PrivacyBudgetTemplateIdentifier", privacyBudgetTemplateIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "privacyBudgetTemplateIdentifier":
            return Optional.ofNullable(clazz.cast(privacyBudgetTemplateIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePrivacyBudgetTemplateRequest, T> g) {
        return obj -> g.apply((DeletePrivacyBudgetTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeletePrivacyBudgetTemplateRequest> {
        /**
         * <p>
         * A unique identifier for one of your memberships for a collaboration. The privacy budget template is deleted
         * from the collaboration that this membership belongs to. Accepts a membership ID.
         * </p>
         * 
         * @param membershipIdentifier
         *        A unique identifier for one of your memberships for a collaboration. The privacy budget template is
         *        deleted from the collaboration that this membership belongs to. Accepts a membership ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * A unique identifier for your privacy budget template.
         * </p>
         * 
         * @param privacyBudgetTemplateIdentifier
         *        A unique identifier for your privacy budget template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privacyBudgetTemplateIdentifier(String privacyBudgetTemplateIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String membershipIdentifier;

        private String privacyBudgetTemplateIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePrivacyBudgetTemplateRequest model) {
            super(model);
            membershipIdentifier(model.membershipIdentifier);
            privacyBudgetTemplateIdentifier(model.privacyBudgetTemplateIdentifier);
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getPrivacyBudgetTemplateIdentifier() {
            return privacyBudgetTemplateIdentifier;
        }

        public final void setPrivacyBudgetTemplateIdentifier(String privacyBudgetTemplateIdentifier) {
            this.privacyBudgetTemplateIdentifier = privacyBudgetTemplateIdentifier;
        }

        @Override
        public final Builder privacyBudgetTemplateIdentifier(String privacyBudgetTemplateIdentifier) {
            this.privacyBudgetTemplateIdentifier = privacyBudgetTemplateIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeletePrivacyBudgetTemplateRequest build() {
            return new DeletePrivacyBudgetTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
