/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConfiguredTableAssociationRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<GetConfiguredTableAssociationRequest.Builder, GetConfiguredTableAssociationRequest> {
    private static final SdkField<String> CONFIGURED_TABLE_ASSOCIATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredTableAssociationIdentifier")
            .getter(getter(GetConfiguredTableAssociationRequest::configuredTableAssociationIdentifier))
            .setter(setter(Builder::configuredTableAssociationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("configuredTableAssociationIdentifier")
                    .build()).build();

    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(GetConfiguredTableAssociationRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURED_TABLE_ASSOCIATION_IDENTIFIER_FIELD, MEMBERSHIP_IDENTIFIER_FIELD));

    private final String configuredTableAssociationIdentifier;

    private final String membershipIdentifier;

    private GetConfiguredTableAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.configuredTableAssociationIdentifier = builder.configuredTableAssociationIdentifier;
        this.membershipIdentifier = builder.membershipIdentifier;
    }

    /**
     * <p>
     * The unique ID for the configured table association to retrieve. Currently accepts the configured table ID.
     * </p>
     * 
     * @return The unique ID for the configured table association to retrieve. Currently accepts the configured table
     *         ID.
     */
    public final String configuredTableAssociationIdentifier() {
        return configuredTableAssociationIdentifier;
    }

    /**
     * <p>
     * A unique identifier for the membership that the configured table association belongs to. Currently accepts the
     * membership ID.
     * </p>
     * 
     * @return A unique identifier for the membership that the configured table association belongs to. Currently
     *         accepts the membership ID.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuredTableAssociationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfiguredTableAssociationRequest)) {
            return false;
        }
        GetConfiguredTableAssociationRequest other = (GetConfiguredTableAssociationRequest) obj;
        return Objects.equals(configuredTableAssociationIdentifier(), other.configuredTableAssociationIdentifier())
                && Objects.equals(membershipIdentifier(), other.membershipIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConfiguredTableAssociationRequest")
                .add("ConfiguredTableAssociationIdentifier", configuredTableAssociationIdentifier())
                .add("MembershipIdentifier", membershipIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuredTableAssociationIdentifier":
            return Optional.ofNullable(clazz.cast(configuredTableAssociationIdentifier()));
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConfiguredTableAssociationRequest, T> g) {
        return obj -> g.apply((GetConfiguredTableAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConfiguredTableAssociationRequest> {
        /**
         * <p>
         * The unique ID for the configured table association to retrieve. Currently accepts the configured table ID.
         * </p>
         * 
         * @param configuredTableAssociationIdentifier
         *        The unique ID for the configured table association to retrieve. Currently accepts the configured table
         *        ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredTableAssociationIdentifier(String configuredTableAssociationIdentifier);

        /**
         * <p>
         * A unique identifier for the membership that the configured table association belongs to. Currently accepts
         * the membership ID.
         * </p>
         * 
         * @param membershipIdentifier
         *        A unique identifier for the membership that the configured table association belongs to. Currently
         *        accepts the membership ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String configuredTableAssociationIdentifier;

        private String membershipIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfiguredTableAssociationRequest model) {
            super(model);
            configuredTableAssociationIdentifier(model.configuredTableAssociationIdentifier);
            membershipIdentifier(model.membershipIdentifier);
        }

        public final String getConfiguredTableAssociationIdentifier() {
            return configuredTableAssociationIdentifier;
        }

        public final void setConfiguredTableAssociationIdentifier(String configuredTableAssociationIdentifier) {
            this.configuredTableAssociationIdentifier = configuredTableAssociationIdentifier;
        }

        @Override
        public final Builder configuredTableAssociationIdentifier(String configuredTableAssociationIdentifier) {
            this.configuredTableAssociationIdentifier = configuredTableAssociationIdentifier;
            return this;
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetConfiguredTableAssociationRequest build() {
            return new GetConfiguredTableAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
