/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A pointer to the dataset that underlies this table. Currently, this can only be an Glue table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableReference implements SdkPojo, Serializable, ToCopyableBuilder<TableReference.Builder, TableReference> {
    private static final SdkField<GlueTableReference> GLUE_FIELD = SdkField
            .<GlueTableReference> builder(MarshallingType.SDK_POJO).memberName("glue").getter(getter(TableReference::glue))
            .setter(setter(Builder::glue)).constructor(GlueTableReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final GlueTableReference glue;

    private final Type type;

    private TableReference(BuilderImpl builder) {
        this.glue = builder.glue;
        this.type = builder.type;
    }

    /**
     * <p>
     * If present, a reference to the Glue table referred to by this table reference.
     * </p>
     * 
     * @return If present, a reference to the Glue table referred to by this table reference.
     */
    public final GlueTableReference glue() {
        return glue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(glue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableReference)) {
            return false;
        }
        TableReference other = (TableReference) obj;
        return Objects.equals(glue(), other.glue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableReference").add("Glue", glue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "glue":
            return Optional.ofNullable(clazz.cast(glue()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #glue()} initialized to the given value.
     *
     * <p>
     * If present, a reference to the Glue table referred to by this table reference.
     * </p>
     * 
     * @param glue
     *        If present, a reference to the Glue table referred to by this table reference.
     */
    public static TableReference fromGlue(GlueTableReference glue) {
        return builder().glue(glue).build();
    }

    /**
     * Create an instance of this class with {@link #glue()} initialized to the given value.
     *
     * <p>
     * If present, a reference to the Glue table referred to by this table reference.
     * </p>
     * 
     * @param glue
     *        If present, a reference to the Glue table referred to by this table reference.
     */
    public static TableReference fromGlue(Consumer<GlueTableReference.Builder> glue) {
        GlueTableReference.Builder builder = GlueTableReference.builder();
        glue.accept(builder);
        return fromGlue(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableReference, T> g) {
        return obj -> g.apply((TableReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableReference> {
        /**
         * <p>
         * If present, a reference to the Glue table referred to by this table reference.
         * </p>
         * 
         * @param glue
         *        If present, a reference to the Glue table referred to by this table reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glue(GlueTableReference glue);

        /**
         * <p>
         * If present, a reference to the Glue table referred to by this table reference.
         * </p>
         * This is a convenience method that creates an instance of the {@link GlueTableReference.Builder} avoiding the
         * need to create one manually via {@link GlueTableReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GlueTableReference.Builder#build()} is called immediately and its
         * result is passed to {@link #glue(GlueTableReference)}.
         * 
         * @param glue
         *        a consumer that will call methods on {@link GlueTableReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #glue(GlueTableReference)
         */
        default Builder glue(Consumer<GlueTableReference.Builder> glue) {
            return glue(GlueTableReference.builder().applyMutation(glue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GlueTableReference glue;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TableReference model) {
            glue(model.glue);
        }

        public final GlueTableReference.Builder getGlue() {
            return glue != null ? glue.toBuilder() : null;
        }

        public final void setGlue(GlueTableReference.BuilderImpl glue) {
            Object oldValue = this.glue;
            this.glue = glue != null ? glue.build() : null;
            handleUnionValueChange(Type.GLUE, oldValue, this.glue);
        }

        @Override
        public final Builder glue(GlueTableReference glue) {
            Object oldValue = this.glue;
            this.glue = glue;
            handleUnionValueChange(Type.GLUE, oldValue, this.glue);
            return this;
        }

        @Override
        public TableReference build() {
            return new TableReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see TableReference#type()
     */
    public enum Type {
        GLUE,

        UNKNOWN_TO_SDK_VERSION
    }
}
