/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A type of analysis rule that enables the table owner to approve custom SQL queries on their configured tables. It
 * supports differential privacy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisRuleCustom implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalysisRuleCustom.Builder, AnalysisRuleCustom> {
    private static final SdkField<List<String>> ALLOWED_ANALYSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedAnalyses")
            .getter(getter(AnalysisRuleCustom::allowedAnalyses))
            .setter(setter(Builder::allowedAnalyses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedAnalyses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOWED_ANALYSIS_PROVIDERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedAnalysisProviders")
            .getter(getter(AnalysisRuleCustom::allowedAnalysisProviders))
            .setter(setter(Builder::allowedAnalysisProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedAnalysisProviders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DifferentialPrivacyConfiguration> DIFFERENTIAL_PRIVACY_FIELD = SdkField
            .<DifferentialPrivacyConfiguration> builder(MarshallingType.SDK_POJO).memberName("differentialPrivacy")
            .getter(getter(AnalysisRuleCustom::differentialPrivacy)).setter(setter(Builder::differentialPrivacy))
            .constructor(DifferentialPrivacyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("differentialPrivacy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_ANALYSES_FIELD,
            ALLOWED_ANALYSIS_PROVIDERS_FIELD, DIFFERENTIAL_PRIVACY_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> allowedAnalyses;

    private final List<String> allowedAnalysisProviders;

    private final DifferentialPrivacyConfiguration differentialPrivacy;

    private AnalysisRuleCustom(BuilderImpl builder) {
        this.allowedAnalyses = builder.allowedAnalyses;
        this.allowedAnalysisProviders = builder.allowedAnalysisProviders;
        this.differentialPrivacy = builder.differentialPrivacy;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedAnalyses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedAnalyses() {
        return allowedAnalyses != null && !(allowedAnalyses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARN of the analysis templates that are allowed by the custom analysis rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedAnalyses} method.
     * </p>
     * 
     * @return The ARN of the analysis templates that are allowed by the custom analysis rule.
     */
    public final List<String> allowedAnalyses() {
        return allowedAnalyses;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedAnalysisProviders property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAllowedAnalysisProviders() {
        return allowedAnalysisProviders != null && !(allowedAnalysisProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Amazon Web Services accounts that are allowed to query by the custom analysis rule. Required when
     * <code>allowedAnalyses</code> is <code>ANY_QUERY</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedAnalysisProviders} method.
     * </p>
     * 
     * @return The IDs of the Amazon Web Services accounts that are allowed to query by the custom analysis rule.
     *         Required when <code>allowedAnalyses</code> is <code>ANY_QUERY</code>.
     */
    public final List<String> allowedAnalysisProviders() {
        return allowedAnalysisProviders;
    }

    /**
     * <p>
     * The differential privacy configuration.
     * </p>
     * 
     * @return The differential privacy configuration.
     */
    public final DifferentialPrivacyConfiguration differentialPrivacy() {
        return differentialPrivacy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedAnalyses() ? allowedAnalyses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedAnalysisProviders() ? allowedAnalysisProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(differentialPrivacy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisRuleCustom)) {
            return false;
        }
        AnalysisRuleCustom other = (AnalysisRuleCustom) obj;
        return hasAllowedAnalyses() == other.hasAllowedAnalyses() && Objects.equals(allowedAnalyses(), other.allowedAnalyses())
                && hasAllowedAnalysisProviders() == other.hasAllowedAnalysisProviders()
                && Objects.equals(allowedAnalysisProviders(), other.allowedAnalysisProviders())
                && Objects.equals(differentialPrivacy(), other.differentialPrivacy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisRuleCustom").add("AllowedAnalyses", hasAllowedAnalyses() ? allowedAnalyses() : null)
                .add("AllowedAnalysisProviders", hasAllowedAnalysisProviders() ? allowedAnalysisProviders() : null)
                .add("DifferentialPrivacy", differentialPrivacy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowedAnalyses":
            return Optional.ofNullable(clazz.cast(allowedAnalyses()));
        case "allowedAnalysisProviders":
            return Optional.ofNullable(clazz.cast(allowedAnalysisProviders()));
        case "differentialPrivacy":
            return Optional.ofNullable(clazz.cast(differentialPrivacy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisRuleCustom, T> g) {
        return obj -> g.apply((AnalysisRuleCustom) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisRuleCustom> {
        /**
         * <p>
         * The ARN of the analysis templates that are allowed by the custom analysis rule.
         * </p>
         * 
         * @param allowedAnalyses
         *        The ARN of the analysis templates that are allowed by the custom analysis rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAnalyses(Collection<String> allowedAnalyses);

        /**
         * <p>
         * The ARN of the analysis templates that are allowed by the custom analysis rule.
         * </p>
         * 
         * @param allowedAnalyses
         *        The ARN of the analysis templates that are allowed by the custom analysis rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAnalyses(String... allowedAnalyses);

        /**
         * <p>
         * The IDs of the Amazon Web Services accounts that are allowed to query by the custom analysis rule. Required
         * when <code>allowedAnalyses</code> is <code>ANY_QUERY</code>.
         * </p>
         * 
         * @param allowedAnalysisProviders
         *        The IDs of the Amazon Web Services accounts that are allowed to query by the custom analysis rule.
         *        Required when <code>allowedAnalyses</code> is <code>ANY_QUERY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAnalysisProviders(Collection<String> allowedAnalysisProviders);

        /**
         * <p>
         * The IDs of the Amazon Web Services accounts that are allowed to query by the custom analysis rule. Required
         * when <code>allowedAnalyses</code> is <code>ANY_QUERY</code>.
         * </p>
         * 
         * @param allowedAnalysisProviders
         *        The IDs of the Amazon Web Services accounts that are allowed to query by the custom analysis rule.
         *        Required when <code>allowedAnalyses</code> is <code>ANY_QUERY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAnalysisProviders(String... allowedAnalysisProviders);

        /**
         * <p>
         * The differential privacy configuration.
         * </p>
         * 
         * @param differentialPrivacy
         *        The differential privacy configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder differentialPrivacy(DifferentialPrivacyConfiguration differentialPrivacy);

        /**
         * <p>
         * The differential privacy configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link DifferentialPrivacyConfiguration.Builder}
         * avoiding the need to create one manually via {@link DifferentialPrivacyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DifferentialPrivacyConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #differentialPrivacy(DifferentialPrivacyConfiguration)}.
         * 
         * @param differentialPrivacy
         *        a consumer that will call methods on {@link DifferentialPrivacyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #differentialPrivacy(DifferentialPrivacyConfiguration)
         */
        default Builder differentialPrivacy(Consumer<DifferentialPrivacyConfiguration.Builder> differentialPrivacy) {
            return differentialPrivacy(DifferentialPrivacyConfiguration.builder().applyMutation(differentialPrivacy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> allowedAnalyses = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowedAnalysisProviders = DefaultSdkAutoConstructList.getInstance();

        private DifferentialPrivacyConfiguration differentialPrivacy;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisRuleCustom model) {
            allowedAnalyses(model.allowedAnalyses);
            allowedAnalysisProviders(model.allowedAnalysisProviders);
            differentialPrivacy(model.differentialPrivacy);
        }

        public final Collection<String> getAllowedAnalyses() {
            if (allowedAnalyses instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedAnalyses;
        }

        public final void setAllowedAnalyses(Collection<String> allowedAnalyses) {
            this.allowedAnalyses = AnalysisRuleCustomAllowedAnalysesListCopier.copy(allowedAnalyses);
        }

        @Override
        public final Builder allowedAnalyses(Collection<String> allowedAnalyses) {
            this.allowedAnalyses = AnalysisRuleCustomAllowedAnalysesListCopier.copy(allowedAnalyses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAnalyses(String... allowedAnalyses) {
            allowedAnalyses(Arrays.asList(allowedAnalyses));
            return this;
        }

        public final Collection<String> getAllowedAnalysisProviders() {
            if (allowedAnalysisProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedAnalysisProviders;
        }

        public final void setAllowedAnalysisProviders(Collection<String> allowedAnalysisProviders) {
            this.allowedAnalysisProviders = AnalysisRuleCustomAllowedAnalysisProvidersListCopier.copy(allowedAnalysisProviders);
        }

        @Override
        public final Builder allowedAnalysisProviders(Collection<String> allowedAnalysisProviders) {
            this.allowedAnalysisProviders = AnalysisRuleCustomAllowedAnalysisProvidersListCopier.copy(allowedAnalysisProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAnalysisProviders(String... allowedAnalysisProviders) {
            allowedAnalysisProviders(Arrays.asList(allowedAnalysisProviders));
            return this;
        }

        public final DifferentialPrivacyConfiguration.Builder getDifferentialPrivacy() {
            return differentialPrivacy != null ? differentialPrivacy.toBuilder() : null;
        }

        public final void setDifferentialPrivacy(DifferentialPrivacyConfiguration.BuilderImpl differentialPrivacy) {
            this.differentialPrivacy = differentialPrivacy != null ? differentialPrivacy.build() : null;
        }

        @Override
        public final Builder differentialPrivacy(DifferentialPrivacyConfiguration differentialPrivacy) {
            this.differentialPrivacy = differentialPrivacy;
            return this;
        }

        @Override
        public AnalysisRuleCustom build() {
            return new AnalysisRuleCustom(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
