/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An error that describes why a schema could not be fetched.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetSchemaAnalysisRuleError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchGetSchemaAnalysisRuleError.Builder, BatchGetSchemaAnalysisRuleError> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(BatchGetSchemaAnalysisRuleError::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(BatchGetSchemaAnalysisRuleError::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(BatchGetSchemaAnalysisRuleError::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(BatchGetSchemaAnalysisRuleError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            CODE_FIELD, MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final String code;

    private final String message;

    private BatchGetSchemaAnalysisRuleError(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * An error name for the error.
     * </p>
     * 
     * @return An error name for the error.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The analysis rule type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AnalysisRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The analysis rule type.
     * @see AnalysisRuleType
     */
    public final AnalysisRuleType type() {
        return AnalysisRuleType.fromValue(type);
    }

    /**
     * <p>
     * The analysis rule type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AnalysisRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The analysis rule type.
     * @see AnalysisRuleType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * An error code for the error.
     * </p>
     * 
     * @return An error code for the error.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * A description of why the call failed.
     * </p>
     * 
     * @return A description of why the call failed.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetSchemaAnalysisRuleError)) {
            return false;
        }
        BatchGetSchemaAnalysisRuleError other = (BatchGetSchemaAnalysisRuleError) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(code(), other.code()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetSchemaAnalysisRuleError").add("Name", name()).add("Type", typeAsString())
                .add("Code", code()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetSchemaAnalysisRuleError, T> g) {
        return obj -> g.apply((BatchGetSchemaAnalysisRuleError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchGetSchemaAnalysisRuleError> {
        /**
         * <p>
         * An error name for the error.
         * </p>
         * 
         * @param name
         *        An error name for the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The analysis rule type.
         * </p>
         * 
         * @param type
         *        The analysis rule type.
         * @see AnalysisRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisRuleType
         */
        Builder type(String type);

        /**
         * <p>
         * The analysis rule type.
         * </p>
         * 
         * @param type
         *        The analysis rule type.
         * @see AnalysisRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisRuleType
         */
        Builder type(AnalysisRuleType type);

        /**
         * <p>
         * An error code for the error.
         * </p>
         * 
         * @param code
         *        An error code for the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * A description of why the call failed.
         * </p>
         * 
         * @param message
         *        A description of why the call failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetSchemaAnalysisRuleError model) {
            name(model.name);
            type(model.type);
            code(model.code);
            message(model.message);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AnalysisRuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BatchGetSchemaAnalysisRuleError build() {
            return new BatchGetSchemaAnalysisRuleError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
